/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.core.dnq.dao;

import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.api.authority.profile.JabberContact;
import jetbrains.jetpass.auth.module.core.dnq.dao.BaseUserDetailsSerializer$setPassword$1;
import jetbrains.jetpass.auth.module.core.dnq.dao.BaseUserDetailsSerializer$updateEntity$3;
import jetbrains.jetpass.auth.module.core.rest.client.api.BaseCoreUserDetails;
import jetbrains.jetpass.auth.module.core.rest.client.api.MD5Password;
import jetbrains.jetpass.auth.module.core.rest.client.api.Password;
import jetbrains.jetpass.auth.module.core.rest.client.api.PlainPassword;
import jetbrains.jetpass.auth.module.core.rest.client.api.SHAPassword;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.EmptyFieldException;
import jetbrains.jetpass.dao.api.SecurityViolationException;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.authority.details.UserDetailsSerializer;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.XdPasswordUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u000e*\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Ljetbrains/jetpass/auth/module/core/dnq/dao/BaseUserDetailsSerializer;", "T", "Ljetbrains/jetpass/auth/module/core/rest/client/api/BaseCoreUserDetails;", "E", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdPasswordUserDetails;", "Ljetbrains/jetpass/dao/dnq/api/authority/details/UserDetailsSerializer;", "()V", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "setDaoContainer", "(Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "updateEntity", "", "xd", "item", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdPasswordUserDetails;Ljetbrains/jetpass/auth/module/core/rest/client/api/BaseCoreUserDetails;)V", "setPassword", "password", "Ljetbrains/jetpass/auth/module/core/rest/client/api/Password;", "jetbrains.jetpass.auth.module.core.dnq"})
public abstract class BaseUserDetailsSerializer<T extends BaseCoreUserDetails, E extends XdPasswordUserDetails>
implements UserDetailsSerializer<T, E> {
    @Autowired
    @Qualifier(value="daoContainer")
    @NotNull
    public JetPassDAOContainer daoContainer;

    @NotNull
    public final JetPassDAOContainer getDaoContainer() {
        JetPassDAOContainer jetPassDAOContainer = this.daoContainer;
        if (jetPassDAOContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"daoContainer");
        }
        return jetPassDAOContainer;
    }

    public final void setDaoContainer(@NotNull JetPassDAOContainer jetPassDAOContainer) {
        Intrinsics.checkParameterIsNotNull((Object)jetPassDAOContainer, (String)"<set-?>");
        this.daoContainer = jetPassDAOContainer;
    }

    /*
     * WARNING - void declaration
     */
    public void updateEntity(@NotNull E xd, @NotNull T item) throws DataAccessException {
        void field$iv;
        void $receiver$iv;
        Function0[] $receiver$iv$iv;
        void value$iv;
        String originServiceID;
        EmailContact it;
        EmailContact emailContact;
        Intrinsics.checkParameterIsNotNull(xd, (String)"xd");
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        EmailContact emailContact2 = item.getEmail();
        if (emailContact2 != null) {
            it = emailContact = emailContact2;
            xd.createOrUpdateEmailContact(it.getEmail(), it.isVerified());
        }
        JabberContact jabberContact = item.getJabber();
        if (jabberContact != null) {
            it = emailContact = jabberContact;
            xd.updateJabber(it.getJabber(), it.isVerified());
        }
        Service service = item.getOriginService();
        String string = originServiceID = service != null ? service.getId() : null;
        if (originServiceID != null) {
            XdService xdService = xd.getOriginService();
            if (Intrinsics.areEqual((Object)originServiceID, (Object)(xdService != null ? xdService.getUuid() : null)) ^ true) {
                JetPassDAOContainer jetPassDAOContainer = this.daoContainer;
                if (jetPassDAOContainer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"daoContainer");
                }
                xd.setOriginService(jetPassDAOContainer.getJetPassServiceDAO().resolveOrNull(originServiceID));
            }
        }
        this.setPassword((XdPasswordUserDetails)xd, item.getPassword());
        it = (XdEntity)xd;
        KMutableProperty1 $i$a$2$let = BaseUserDetailsSerializer$updateEntity$3.INSTANCE;
        Comparable comparable = item.isPasswordChangeRequired();
        Function0[] assertions$iv = new Function0[]{};
        if (value$iv != null && (!ReflectionUtilKt.isDefined((XdEntity)($receiver$iv$iv = $receiver$iv), XdPasswordUserDetails.class, (KProperty1)((KProperty1)field$iv)) || Intrinsics.areEqual((Object)value$iv, (Object)((Comparable)field$iv.get((Object)$receiver$iv))) ^ true)) {
            Function0[] function0Array = $receiver$iv$iv = assertions$iv;
            int n = function0Array.length;
            for (int i = 0; i < n; ++i) {
                Function0 element$iv$iv;
                Function0 it$iv = element$iv$iv = function0Array[i];
                it$iv.invoke();
            }
            field$iv.set((Object)$receiver$iv, (Object)value$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setPassword(@NotNull XdPasswordUserDetails $receiver, Password password) throws DataAccessException {
        if (password != null) {
            void $receiver$iv;
            XdEntity xdEntity = (XdEntity)$receiver;
            KProperty1 property$iv = (KProperty1)BaseUserDetailsSerializer$setPassword$1.INSTANCE;
            if (ReflectionUtilKt.isDefined((XdEntity)$receiver$iv, XdPasswordUserDetails.class, (KProperty1)property$iv)) {
                JetPassDAOContainer jetPassDAOContainer = this.daoContainer;
                if (jetPassDAOContainer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"daoContainer");
                }
                if (jetPassDAOContainer.getJetPassUserDAO().getSecurity().isSelf((XdBaseUser)$receiver.getUser()) && !$receiver.isNew()) {
                    CharSequence charSequence;
                    String oldPassword = password.getOldValue();
                    if (oldPassword == null || (charSequence = (CharSequence)oldPassword).length() == 0) {
                        throw (Throwable)new EmptyFieldException(Password.class.getSimpleName(), "oldValue");
                    }
                    if (!$receiver.matches(oldPassword)) {
                        SecurityViolationException securityViolationException = SecurityViolationException.oldPasswordMismatch((String)$receiver.getUser().getLogin());
                        Intrinsics.checkExpressionValueIsNotNull((Object)securityViolationException, (String)"SecurityViolationExcepti\u2026swordMismatch(user.login)");
                        throw (Throwable)securityViolationException;
                    }
                }
            }
            if ((xdEntity = password) instanceof PlainPassword) {
                String string = ((PlainPassword)password).getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"password.value");
                $receiver.setPlainPassword(string);
            } else if (xdEntity instanceof SHAPassword) {
                String string = ((SHAPassword)password).getHashedValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"password.hashedValue");
                $receiver.setSHAPassword(string, null);
            } else if (xdEntity instanceof MD5Password) {
                String string = ((MD5Password)password).getHashedValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"password.hashedValue");
                $receiver.setMD5Password(string, ((MD5Password)password).getSalt());
            }
        }
    }

    @NotNull
    public XdQuery<XdBaseUserDetails> filterAPIVersionCompatibleUserDetails(@NotNull XdQuery<? extends XdBaseUserDetails> source) {
        Intrinsics.checkParameterIsNotNull(source, (String)"source");
        return UserDetailsSerializer.DefaultImpls.filterAPIVersionCompatibleUserDetails((UserDetailsSerializer)this, source);
    }

    public boolean isAPIVersionCompatibleUserDetails(@NotNull XdBaseUserDetails userDetails) {
        Intrinsics.checkParameterIsNotNull((Object)userDetails, (String)"userDetails");
        return UserDetailsSerializer.DefaultImpls.isAPIVersionCompatibleUserDetails((UserDetailsSerializer)this, (XdBaseUserDetails)userDetails);
    }

    @NotNull
    public T toItem(@NotNull E $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return (T)((BaseCoreUserDetails)UserDetailsSerializer.DefaultImpls.toItem((UserDetailsSerializer)this, (XdBaseUserDetails)((XdBaseUserDetails)$receiver)));
    }
}

