/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.profiles;

import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.utils.JavaSystemSetting;
import software.amazon.awssdk.utils.StringUtils;

@SdkPublicApi
public final class ProfileFileLocation {
    private static final Pattern HOME_DIRECTORY_PATTERN = Pattern.compile("^~(/|" + Pattern.quote(FileSystems.getDefault().getSeparator()) + ").*$");

    private ProfileFileLocation() {
    }

    public static Optional<Path> configurationFileLocation() {
        return ProfileFileLocation.resolveProfileFilePath(SdkSystemSetting.AWS_CONFIG_FILE.getStringValue().orElse(Paths.get(ProfileFileLocation.userHomeDirectory(), ".aws", "config").toString()));
    }

    public static Optional<Path> credentialsFileLocation() {
        return ProfileFileLocation.resolveProfileFilePath(SdkSystemSetting.AWS_SHARED_CREDENTIALS_FILE.getStringValue().orElse(Paths.get(ProfileFileLocation.userHomeDirectory(), ".aws", "credentials").toString()));
    }

    @SdkInternalApi
    static String userHomeDirectory() {
        boolean isWindows = JavaSystemSetting.OS_NAME.getStringValue().map(s -> StringUtils.lowerCase((String)s).startsWith("windows")).orElse(false);
        String home = System.getenv("HOME");
        if (home != null) {
            return home;
        }
        if (isWindows) {
            String userProfile = System.getenv("USERPROFILE");
            if (userProfile != null) {
                return userProfile;
            }
            String homeDrive = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            if (homeDrive != null && homePath != null) {
                return homeDrive + homePath;
            }
        }
        return JavaSystemSetting.USER_HOME.getStringValueOrThrow();
    }

    private static Optional<Path> resolveProfileFilePath(String path) {
        if (HOME_DIRECTORY_PATTERN.matcher(path).matches()) {
            path = ProfileFileLocation.userHomeDirectory() + path.substring(1);
        }
        return Optional.ofNullable(Paths.get(path, new String[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable);
    }
}

