/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.dnq.runtime.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.exodus.query.metadata.AssociationEndMetaDataImpl;
import jetbrains.exodus.query.metadata.AssociationMetaData;
import jetbrains.exodus.query.metadata.AssociationMetaDataImpl;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.EntityMetaDataImpl;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.teamsys.dnq.runtime.metadata.AssociationEndMetaDataSample;
import jetbrains.teamsys.dnq.runtime.metadata.EntityMetaDataSample;

public class EntityMetaDataFactory {
    private Map<String, AssociationEndMetaDataSample> associationEndMetadataSamples = new HashMap<String, AssociationEndMetaDataSample>();
    private Collection<EntityMetaDataSample> mySamples;
    private Collection<EntityMetaDataImpl> myPersistentInterfaceSamples;
    private Collection<AssociationMetaDataImpl> myAssociationSamples;

    public Collection<EntityMetaData> createEntityMetaDatas() {
        ArrayList<EntityMetaData> result = new ArrayList<EntityMetaData>();
        for (EntityMetaDataSample sample : this.getSamples()) {
            EntityMetaDataImpl clone = new EntityMetaDataImpl();
            clone.setType(sample.getType());
            try {
                Class<?> clazz = sample.getInitializer().getClass();
                clone.setInitializer((Runnable)clazz.newInstance());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            clone.setRemoveOrphan(sample.getRemoveOrphan());
            clone.setAbstract(sample.isAbstract());
            clone.setSuperType(sample.getSuperType());
            clone.setInterfaces(new ArrayList(sample.getInterfaceTypes()));
            if (sample.getRequiredIfProperties() != null && !sample.getRequiredIfProperties().isEmpty()) {
                clone.setRequiredIfProperties(new HashSet<String>(sample.getRequiredIfProperties()));
            }
            if (!sample.getRequiredProperties().isEmpty()) {
                clone.setRequiredProperties(new HashSet(sample.getRequiredProperties()));
            }
            if (sample.getPropertiesMetaData().iterator().hasNext()) {
                clone.setPropertiesMetaData((Iterable)ListSequence.fromIterable((Iterable)sample.getPropertiesMetaData()));
            }
            if (!sample.getOwnIndexes().isEmpty()) {
                clone.setOwnIndexes(new HashSet(sample.getOwnIndexes()));
            }
            ArrayList<AssociationEndMetaData> associationEnds = new ArrayList<AssociationEndMetaData>();
            if (sample.getAssociationEndNames() != null) {
                for (String associationEndName : sample.getAssociationEndNames()) {
                    AssociationEndMetaDataSample associationEndMetaDataSample = this.associationEndMetadataSamples.get(associationEndName);
                    if (associationEndMetaDataSample == null) {
                        throw new IllegalStateException("No asocaition end with name " + associationEndName + " is defined for metadata " + sample.getType());
                    }
                    associationEnds.add(this.cloneAssociationEntMetadata(associationEndMetaDataSample));
                }
            }
            clone.setAssociationEnds(associationEnds);
            result.add((EntityMetaData)clone);
        }
        result.addAll(this.createMetadataForPersistentInterfaces());
        return result;
    }

    private AssociationEndMetaData cloneAssociationEntMetadata(AssociationEndMetaDataSample aemd) {
        AssociationEndMetaDataImpl clone = new AssociationEndMetaDataImpl();
        clone.setAssociationEndType(aemd.getAssociationEndType());
        clone.setAssociationMetaDataName(aemd.getPrivateAssociationMetaDataName());
        clone.setCardinality(aemd.getCardinality());
        clone.setCascadeDelete(aemd.getCascadeDelete());
        clone.setClearOnDelete(aemd.getClearOnDelete());
        clone.setName(aemd.getName());
        clone.setOppositeEndName(aemd.getOppositeEndName());
        clone.setOppositeEntityMetaDataType(aemd.getEmdType());
        clone.setTargetCascadeDelete(aemd.getTargetCascadeDelete());
        clone.setTargetClearOnDelete(aemd.getTargetClearOnDelete());
        return clone;
    }

    private Collection<EntityMetaData> createMetadataForPersistentInterfaces() {
        ArrayList<EntityMetaData> result = new ArrayList<EntityMetaData>();
        for (EntityMetaData entityMetaData : this.getPersistentInterfaceSamples()) {
            EntityMetaDataImpl metadata = new EntityMetaDataImpl();
            metadata.setType(entityMetaData.getType());
            metadata.setInterfaces(new ArrayList(entityMetaData.getInterfaceTypes()));
            result.add((EntityMetaData)metadata);
        }
        return result;
    }

    public Collection<AssociationMetaData> createAssociationMetaDatas() {
        ArrayList<AssociationMetaData> clone = new ArrayList<AssociationMetaData>();
        for (AssociationMetaDataImpl association : this.getAssociationSamples()) {
            clone.add((AssociationMetaData)new AssociationMetaDataImpl(association.getType(), association.getFullName()));
        }
        return clone;
    }

    public void setAssociationEndSamples(Collection<AssociationEndMetaDataSample> values) {
        if (values != null) {
            for (AssociationEndMetaDataSample sample : values) {
                this.associationEndMetadataSamples.put(sample.getAssociationFqName(), sample);
            }
        }
    }

    public Collection<EntityMetaDataSample> getSamples() {
        return this.mySamples;
    }

    public void setSamples(Collection<EntityMetaDataSample> value) {
        this.mySamples = value;
    }

    public Collection<EntityMetaDataImpl> getPersistentInterfaceSamples() {
        return this.myPersistentInterfaceSamples;
    }

    public void setPersistentInterfaceSamples(Collection<EntityMetaDataImpl> value) {
        this.myPersistentInterfaceSamples = value;
    }

    public Collection<AssociationMetaDataImpl> getAssociationSamples() {
        return this.myAssociationSamples;
    }

    public void setAssociationSamples(Collection<AssociationMetaDataImpl> value) {
        this.myAssociationSamples = value;
    }
}

