/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.dnq.runtime.queries;

import com.jetbrains.teamsys.dnq.database.TransientEntityIterable;
import java.util.Collection;
import java.util.List;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.StaticTypedIterableDecorator;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryOperations {
    protected static Log log = LogFactory.getLog(QueryOperations.class);

    public static TreeKeepingEntityIterable queryGetAll(String entityType) {
        return ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).queryGetAll(entityType);
    }

    public static TreeKeepingEntityIterable query(@NotNull String entityType, @NotNull NodeBase tree) {
        return ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).query(entityType, tree);
    }

    public static TreeKeepingEntityIterable query(@Nullable Iterable<Entity> instance, @NotNull String entityType, @NotNull NodeBase tree) {
        return ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).query(instance, entityType, tree);
    }

    public static Iterable<Entity> empty(String entityType) {
        return new StaticTypedIterableDecorator(entityType, (Iterable)EntityIterableBase.EMPTY, (QueryEngine)ServiceLocator.getBean((String)"queryEngine"));
    }

    public static Iterable<Entity> singleton(Entity entity) {
        if (entity == null) {
            return EntityIterableBase.EMPTY;
        }
        if (((TransientEntity)entity).isNew()) {
            return Sequence.singleton((Object)entity);
        }
        TransientStoreSession session = DnqUtils.getCurrentTransientSession();
        if (session == null) {
            throw new IllegalStateException("No current transient session.");
        }
        return session.getSingletonIterable(entity);
    }

    public static Iterable<Entity> intersect(Iterable<Entity> left, Iterable<Entity> right) {
        return ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).intersect(left, right);
    }

    public static Iterable<Entity> union(Iterable<Entity> left, Iterable<Entity> right) {
        return ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).union(left, right);
    }

    public static Iterable<Entity> concat(Iterable<Entity> left, Iterable<Entity> right) {
        return ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).concat(left, right);
    }

    public static Iterable<Entity> exclude(Iterable<Entity> left, Iterable<Entity> right) {
        return ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).exclude(left, right);
    }

    public static int getSize(Iterable<Entity> it) {
        if (it == null) {
            return 0;
        }
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        it = engine.toEntityIterable(it);
        if (it == EntityIterableBase.EMPTY) {
            return 0;
        }
        if (engine.isPersistentIterable(it)) {
            return (int)QueryOperations.getSource((EntityIterable)it).size();
        }
        if (it instanceof TransientEntityIterable) {
            return (int)((TransientEntityIterable)it).size();
        }
        if (it instanceof Collection) {
            return ((Collection)it).size();
        }
        return Sequence.fromIterable((Iterable)it).count();
    }

    public static int count(Iterable<Entity> it) {
        if (it == null) {
            return 0;
        }
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        it = engine.toEntityIterable(it);
        if (it == EntityIterableBase.EMPTY) {
            return 0;
        }
        if (engine.isPersistentIterable(it)) {
            return (int)QueryOperations.getSource((EntityIterable)it).count();
        }
        if (it instanceof TransientEntityIterable) {
            return (int)((TransientEntityIterable)it).count();
        }
        if (it instanceof Collection) {
            return ((Collection)it).size();
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)"Brute force calculation of count!", (Throwable)new Exception());
        }
        return Sequence.fromIterable((Iterable)it).count();
    }

    public static boolean isEmpty(Iterable<Entity> it) {
        if (it == null) {
            return true;
        }
        if (it instanceof Collection) {
            return ((Collection)it).isEmpty();
        }
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        if (engine.isPersistentIterable(it = engine.toEntityIterable(it))) {
            return QueryOperations.getSource((EntityIterable)it).isEmpty();
        }
        if (it instanceof TransientEntityIterable) {
            return ((TransientEntityIterable)it).isEmpty();
        }
        return Sequence.fromIterable((Iterable)it).isEmpty();
    }

    public static int roughCount(Iterable<Entity> it) {
        if (it == null) {
            return 0;
        }
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        if (engine.isPersistentIterable(it = engine.toEntityIterable(it))) {
            return (int)QueryOperations.getSource((EntityIterable)it).getRoughCount();
        }
        if (it instanceof TransientEntityIterable) {
            return (int)((TransientEntityIterable)it).getRoughCount();
        }
        if (it instanceof Collection) {
            return ((Collection)it).size();
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)"Brute force calculation of roughCount!", (Throwable)new Exception());
        }
        return Sequence.fromIterable((Iterable)it).count();
    }

    public static int roughSize(Iterable<Entity> it) {
        if (it == null) {
            return 0;
        }
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        if (engine.isPersistentIterable(it = engine.toEntityIterable(it))) {
            return (int)QueryOperations.getSource((EntityIterable)it).getRoughSize();
        }
        if (it instanceof TransientEntityIterable) {
            return (int)((TransientEntityIterable)it).getRoughSize();
        }
        if (it instanceof Collection) {
            return ((Collection)it).size();
        }
        return Sequence.fromIterable((Iterable)it).count();
    }

    public static Iterable<Entity> skip(Iterable<Entity> it, int elementsToSkip) {
        if (it == null) {
            return EntityIterableBase.EMPTY;
        }
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        if (engine.isPersistentIterable(it = engine.toEntityIterable(it))) {
            return QueryOperations.wrap(QueryOperations.getSource((EntityIterable)it).skip(elementsToSkip));
        }
        return Sequence.fromIterable((Iterable)it).skip(elementsToSkip);
    }

    public static Iterable<Entity> take(Iterable<Entity> it, int elementsToTake) {
        if (it == null) {
            return EntityIterableBase.EMPTY;
        }
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        if (engine.isPersistentIterable(it = engine.toEntityIterable(it))) {
            return QueryOperations.wrap(QueryOperations.getSource((EntityIterable)it).take(elementsToTake));
        }
        return Sequence.fromIterable((Iterable)it).take(elementsToTake);
    }

    public static Iterable<Entity> distinct(Iterable<Entity> it) {
        if (it == null) {
            return EntityIterableBase.EMPTY;
        }
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        if (engine.isPersistentIterable(it = engine.toEntityIterable(it))) {
            return QueryOperations.wrap(QueryOperations.getSource((EntityIterable)it).distinct());
        }
        return Sequence.fromIterable((Iterable)it).distinct();
    }

    public static Iterable<Entity> selectDistinct(Iterable<Entity> it, String linkName) {
        return ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).selectDistinct(it, linkName);
    }

    public static Iterable<Entity> selectManyDistinct(Iterable<Entity> it, String linkName) {
        return ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).selectManyDistinct(it, linkName);
    }

    public static int indexOf(Iterable<Entity> it, Entity entity) {
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        it = engine.toEntityIterable(it);
        if (entity != null) {
            if (engine.isPersistentIterable(it)) {
                return QueryOperations.getSource((EntityIterable)it).indexOf(entity);
            }
            if (it instanceof TransientEntityIterable) {
                return ((TransientEntityIterable)it).indexOf(entity);
            }
        }
        return Sequence.fromIterable((Iterable)it).indexOf((Object)entity);
    }

    public static boolean contains(Iterable<Entity> it, Entity entity) {
        if (it instanceof Collection) {
            return ((Collection)it).contains(entity);
        }
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        it = engine.toEntityIterable(it);
        if (entity != null) {
            if (engine.isPersistentIterable(it)) {
                return QueryOperations.getSource((EntityIterable)it).contains(entity);
            }
            if (it instanceof TransientEntityIterable) {
                return ((TransientEntityIterable)it).contains(entity);
            }
        }
        return Sequence.fromIterable((Iterable)it).contains((Object)entity);
    }

    public static Entity getFirst(Iterable<Entity> it) {
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        if (engine.isPersistentIterable(it = engine.toEntityIterable(it))) {
            return QueryOperations.wrap(QueryOperations.getSource((EntityIterable)it).getFirst());
        }
        return (Entity)Sequence.fromIterable((Iterable)it).first();
    }

    public static Entity getLast(Iterable<Entity> it) {
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        if (engine.isPersistentIterable(it = engine.toEntityIterable(it))) {
            return QueryOperations.wrap(QueryOperations.getSource((EntityIterable)it).getLast());
        }
        return (Entity)Sequence.fromIterable((Iterable)it).last();
    }

    public static Iterable<Entity> reverse(Iterable<Entity> it) {
        QueryEngine engine = (QueryEngine)ServiceLocator.getBean((String)"queryEngine");
        if (engine.isPersistentIterable(it = engine.toEntityIterable(it))) {
            return QueryOperations.wrap(QueryOperations.getSource((EntityIterable)it).reverse());
        }
        return ListSequence.fromList((List)Sequence.fromIterable((Iterable)it).toListSequence()).reversedList();
    }

    public static EntityIterable getSource(EntityIterable it) {
        if (it instanceof EntityIterableBase) {
            return ((EntityIterableBase)it).getSource();
        }
        return it;
    }

    public static Iterable<Entity> getSource(Iterable<Entity> it) {
        if (it instanceof EntityIterable) {
            return QueryOperations.getSource((EntityIterable)it);
        }
        return it;
    }

    private static Entity wrap(@Nullable Entity entity) {
        return entity == null ? null : DnqUtils.getCurrentTransientSession().newEntity(entity);
    }

    private static EntityIterable wrap(@NotNull EntityIterable it) {
        return DnqUtils.getCurrentTransientSession().createPersistentEntityIterableWrapper(it);
    }
}

