/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.dnq.runtime.util;

import com.jetbrains.teamsys.dnq.database.ValidationUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Validator {
    protected static Log log = LogFactory.getLog(Validator.class);

    public static void validate() {
        Validator.validate((ModelMetaData)ServiceLocator.getBean((String)"modelMetaData"));
    }

    public static void validate(ModelMetaData mmd) {
        for (EntityMetaData emd : Sequence.fromIterable((Iterable)mmd.getEntitiesMetaData())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Validation: " + emd.getType()));
            }
            int cnt = 0;
            for (Entity entity : QueryOperations.queryGetAll(emd.getType())) {
                ValidationUtil.validateEntity((Entity)entity, (ModelMetaData)mmd);
                if (++cnt % 100 != 0 || !log.isTraceEnabled()) continue;
                log.trace((Object)(cnt + " entities validated"));
            }
        }
    }
}

