/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.util.xml.BasePlaneConfigHandler;
import com.jetbrains.bundle.util.xml.XmlUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallationConfiguration {
    private static final String DEFAULT_APP_DATA_ROOT_DIR = "default-appdata-root";
    private static final String CONF_LOCATION_PROPERTY = "conf-location";
    private static final String INSTALLATION_TYPE_PROPERTY = "type";
    private static final String INSTALLATION_DIR = "installationDir";
    private static final String SYSTEM_APP_DATA_DIR = "commonAppDataFolder";
    private static final String DEFAULT_INSTALLATION_FOLDER_NAME_PROPERTY = "defaultInstallationFolderName";
    private static final String DEFAULT_APP_DATA_FOLDER_NAME_PROPERTY = "defaultApplicationDataFolderName";
    private static final String INSTALLATION_USER_PROPERTY = "installationUser";
    private static final String INSTALLATION_PORT_PROPERTY = "installationPort";
    private static final String USER_DNS_DOMAIN_PROPERTY = "userDnsDomain";
    private static final String WIZARD_TOKEN_PROPERTY = "wizardToken";
    private static final String LISTEN_ADDRESS_PROPERTY = "listen-address";
    private static final Collection<String> PROPERTY_NAMES;
    private final Date myLastModifiedDate;
    private final Properties myProperties = new Properties();

    InstallationConfiguration(Path configFilePath) {
        if (Files.exists(configFilePath, new LinkOption[0])) {
            File file = configFilePath.toFile();
            this.myLastModifiedDate = new Date(file.lastModified());
            try {
                XmlUtil.parse(file, new BasePlaneConfigHandler(this.myProperties, PROPERTY_NAMES));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to read installation properties from %s", file), e);
            }
        } else {
            throw new IllegalStateException(String.format("Installation folder is corrupted: file %s doesn't exist", configFilePath));
        }
    }

    String getApplicationDataRootDirectory() {
        return this.myProperties.getProperty(DEFAULT_APP_DATA_ROOT_DIR);
    }

    public String getInstallationDir() {
        return this.myProperties.getProperty(INSTALLATION_DIR);
    }

    String getSystemAppDataDir() {
        return this.myProperties.getProperty(SYSTEM_APP_DATA_DIR);
    }

    String getDefaultApplicationDataFolder() {
        return this.myProperties.getProperty(DEFAULT_APP_DATA_FOLDER_NAME_PROPERTY);
    }

    public String getInstallationUser() {
        return this.myProperties.getProperty(INSTALLATION_USER_PROPERTY);
    }

    public Integer getInstallationPort() {
        Integer port = null;
        try {
            String installationPort = this.myProperties.getProperty(INSTALLATION_PORT_PROPERTY);
            if (installationPort != null && !installationPort.trim().isEmpty()) {
                port = Integer.parseInt(installationPort);
            }
        }
        catch (NumberFormatException e) {
            port = null;
        }
        return port;
    }

    @NotNull
    public BundleInstallationType getInstallationType() {
        String installationType = this.myProperties.getProperty(INSTALLATION_TYPE_PROPERTY);
        return installationType == null ? BundleInstallationType.ZIP : BundleInstallationType.valueOf(installationType);
    }

    @Nullable
    public String getUserDnsDomain() {
        String userDnsDomain = this.myProperties.getProperty(USER_DNS_DOMAIN_PROPERTY);
        return userDnsDomain == null || userDnsDomain.trim().isEmpty() ? null : userDnsDomain.trim();
    }

    @Nullable
    public String getWizardToken() {
        String wizardToken = this.myProperties.getProperty(WIZARD_TOKEN_PROPERTY);
        return wizardToken == null || wizardToken.trim().isEmpty() ? null : wizardToken.trim();
    }

    @Nullable
    public String getListenAddress() {
        String listenAddress = this.myProperties.getProperty(LISTEN_ADDRESS_PROPERTY);
        return listenAddress == null || listenAddress.trim().isEmpty() ? null : listenAddress.trim();
    }

    @Nullable
    public Date getFileLastModifiedDate() {
        return this.myLastModifiedDate;
    }

    @Nullable
    String getConfLocation() {
        String confLocation = this.myProperties.getProperty(CONF_LOCATION_PROPERTY);
        return confLocation == null || confLocation.trim().isEmpty() ? null : confLocation.trim();
    }

    static {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(DEFAULT_APP_DATA_ROOT_DIR);
        tmp.add(CONF_LOCATION_PROPERTY);
        tmp.add(INSTALLATION_TYPE_PROPERTY);
        tmp.add(INSTALLATION_DIR);
        tmp.add(SYSTEM_APP_DATA_DIR);
        tmp.add(DEFAULT_INSTALLATION_FOLDER_NAME_PROPERTY);
        tmp.add(DEFAULT_APP_DATA_FOLDER_NAME_PROPERTY);
        tmp.add(INSTALLATION_USER_PROPERTY);
        tmp.add(INSTALLATION_PORT_PROPERTY);
        tmp.add(USER_DNS_DOMAIN_PROPERTY);
        tmp.add(WIZARD_TOKEN_PROPERTY);
        tmp.add(LISTEN_ADDRESS_PROPERTY);
        PROPERTY_NAMES = Collections.unmodifiableCollection(tmp);
    }
}

