/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.restImport;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.youtrack.admin.IssueAttachmentStub;
import jetbrains.youtrack.restImport.ItemReport;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.joda.time.DateTimeFieldType;

public class AttachmentBean
implements IssueAttachmentStub {
    private Long created;
    private Entity permittedGroup;
    private Entity author;
    private DiskFileItem file;
    private Entity issue;
    private ItemReport itemReport = new ItemReport();

    public void parse(String issue, String authorLogin, String group, Long created, DiskFileItem file) {
        if (issue == null || issue.length() == 0) {
            this.itemReport.requireField("issue");
        } else {
            this.issue = IssueImpl.fromId((String)issue);
            if (EntityOperations.equals((Entity)this.issue, null)) {
                this.itemReport.unknownValue("issue", issue);
            }
        }
        if (authorLogin == null || authorLogin.length() == 0) {
            this.itemReport.requireField("authorLogin");
        } else {
            this.author = LoginUtils.isValidLogin((String)authorLogin) ? UserImpl.findUser((String)authorLogin) : UserImpl.findUser((String)LoginUtils.fix((String)authorLogin));
            if (EntityOperations.equals((Entity)this.author, null)) {
                this.itemReport.unknownValue("authorLogin", authorLogin);
            }
        }
        if (group != null && group.length() > 0) {
            this.permittedGroup = UserGroupImpl.findUserGroup((String)group);
            if (group == null) {
                this.itemReport.unknownValue("group", group);
            }
        }
        this.created = created;
        if (DateTimeOperations.compare((Long)created, (CompareType)CompareType.EQ, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
            this.itemReport.requireField("created");
        }
        this.file = file;
        if (file == null) {
            this.itemReport.requireField("MIME attachment");
        } else if (AttachmentBean.isEmpty_vmiymh_a0a0a01a0(file.getName())) {
            this.itemReport.requireField("MIME attachment.filename");
        }
    }

    @Override
    public Long getCreated() {
        return this.created;
    }

    @Override
    public Entity getPermittedGroup() {
        return this.permittedGroup;
    }

    @Override
    public Entity getAuthor() {
        return this.author;
    }

    @Override
    public DiskFileItem getFile() {
        return this.file;
    }

    @Override
    public Entity getIssue() {
        return this.issue;
    }

    public ItemReport getItemReport() {
        return this.itemReport;
    }

    public static boolean isEmpty_vmiymh_a0a0a01a0(String str) {
        return str == null || str.length() == 0;
    }
}

