/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.restImport;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.BaseCommentImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.admin.IssueCommentStub;
import jetbrains.youtrack.restImport.ItemReport;
import org.joda.time.DateTimeFieldType;

@XmlRootElement(name="comment")
public class CommentBean
implements IssueCommentStub {
    @XmlAttribute(name="author")
    private String authorLogin;
    @JsonIgnore
    private Entity author;
    @XmlAttribute
    private String text;
    @XmlAttribute
    private Boolean markdown;
    @XmlAttribute
    private Long created;
    @XmlAttribute
    private Long updated;
    @XmlAttribute(name="permittedGroup")
    private String permittedGroupName;
    @JsonIgnore
    private Entity permittedGroup;

    public CommentBean() {
    }

    public CommentBean(Entity comment) {
        this.author = AssociationSemantics.getToOne((Entity)comment, (String)"author");
        this.authorLogin = (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)comment, (String)"author"), (String)"login", String.class, (Object)"<no user>");
        this.text = PrimitiveAssociationSemantics.getBlobAsString((Entity)comment, (String)"text");
        this.markdown = (Boolean)PrimitiveAssociationSemantics.get((Entity)comment, (String)"usesMarkdown", Boolean.class, null);
        this.created = (Long)PrimitiveAssociationSemantics.get((Entity)comment, (String)"created", null);
        this.updated = (Long)PrimitiveAssociationSemantics.get((Entity)comment, (String)"updated", null);
        Entity permittedGroup = ((BaseCommentImpl)DnqUtils.getPersistentClassInstance((Entity)comment, (String)"BaseComment")).getPermittedGroup(comment);
        if (!EntityOperations.equals((Entity)permittedGroup, null)) {
            this.permittedGroupName = (String)PrimitiveAssociationSemantics.get((Entity)permittedGroup, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale());
            this.permittedGroup = permittedGroup;
        }
    }

    @Override
    public Entity getAuthor() {
        return this.author;
    }

    @Override
    public Entity getPermittedGroup() {
        return this.permittedGroup;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Boolean isMarkdown() {
        return this.markdown;
    }

    @Override
    public Long getCreated() {
        return this.created;
    }

    @Override
    public Long getUpdated() {
        return this.updated;
    }

    public IssueCommentStub check(ItemReport itemReport) {
        this.author = LoginUtils.isValidLogin((String)this.authorLogin) ? UserImpl.findUser((String)this.authorLogin) : UserImpl.findUser((String)LoginUtils.fix((String)this.authorLogin));
        if (EntityOperations.equals((Entity)this.author, null)) {
            itemReport.unknownValue("comment.author", this.authorLogin);
        }
        if (CommentBean.isEmpty_v6jd53_a0c0g(this.text)) {
            itemReport.requireField("comment.text");
        }
        if (DateTimeOperations.compare((Long)this.created, (CompareType)CompareType.EQ, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
            itemReport.requireField("comment.created");
        }
        if (this.permittedGroupName != null) {
            Entity group = UserGroupImpl.findUserGroup((String)this.permittedGroupName);
            if (EntityOperations.equals((Entity)group, null)) {
                itemReport.unknownField("comment.permittedGroupName");
            } else if (!((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
                this.permittedGroup = group;
            }
        }
        return this;
    }

    public static boolean isEmpty_v6jd53_a0c0g(String str) {
        return str == null || str.length() == 0;
    }
}

