/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.restImport;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.youtrack.restImport.ErrorMessage;

public class ItemReport {
    @XmlAttribute
    private boolean imported = true;
    @XmlAttribute(name="id")
    private String itemId;
    @XmlElements(value={@XmlElement(name="error")})
    private List<ErrorMessage> errors;

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    private void add(ErrorMessage error) {
        if (this.errors == null) {
            this.errors = ListSequence.fromList(new ArrayList());
            this.imported = false;
        }
        ListSequence.fromList(this.errors).addElement((Object)error);
    }

    public boolean isEmpty() {
        return ListSequence.fromList(this.errors).isEmpty();
    }

    public void badFormat(String fieldName, String valueS, String format) {
        ErrorMessage error = new ErrorMessage(ErrorMessage.Type.BAD_FORMAT, fieldName, valueS, format);
        this.add(error);
    }

    public void notUnique(String fieldName, String valueS) {
        ErrorMessage error = new ErrorMessage(ErrorMessage.Type.NOT_UNIQUE, fieldName, valueS, null);
        this.add(error);
    }

    public void unknownValue(String fieldName, String valueS) {
        ErrorMessage error = new ErrorMessage(ErrorMessage.Type.UNKNOWN_VALUE, fieldName, valueS, null);
        this.add(error);
    }

    public void unknownField(String fieldName) {
        ErrorMessage error = new ErrorMessage(ErrorMessage.Type.UNKNOWN_FIELD, fieldName, null, null);
        this.add(error);
    }

    public void requireField(String fieldName) {
        ErrorMessage error = new ErrorMessage(ErrorMessage.Type.REQUIRED_FIELD, fieldName, null, null);
        this.add(error);
    }
}

