/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleVersion;
import com.jetbrains.service.util.BundleBuildPropertyName;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleBuildProperties {
    private final Logger LOG;
    private final Properties myProperties;
    @NotNull
    private final BundleVersion myBundleVersion;

    public BundleBuildProperties(BundleEnvironment environment) {
        block15: {
            this.LOG = LoggerFactory.getLogger(this.getClass());
            this.myProperties = new Properties();
            this.myBundleVersion = new BundleVersion();
            Path bundleBuildConfig = environment.getBundleBuildConfig();
            if (Files.isReadable(bundleBuildConfig)) {
                this.LOG.debug(String.format("Reading config from %s", bundleBuildConfig));
                try (InputStream is = Files.newInputStream(bundleBuildConfig, new OpenOption[0]);){
                    this.myProperties.load(is);
                    break block15;
                }
                catch (IOException e) {
                    throw new StatusException("Could not load build properties config from " + bundleBuildConfig + ": " + e.getMessage());
                }
            }
            this.LOG.debug(String.format("Config does not exists at %s", bundleBuildConfig));
        }
        this.processProductManufacturerProperty();
        this.processProductPresentationNameProperty();
        this.processBundledInInternalServices("adminService");
        this.processBundledInInternalServices("startingPage");
        this.processBundledInInternalServices("configurationWizard");
        this.processBundledInInternalServices("bundleBackend");
        this.processBundledInInternalServices("bundle-hub-configurator");
    }

    private void processBundledInInternalServices(@NotNull String serviceId) {
        String bundledInDefaultContainerProperty = PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, "bundledin");
        boolean isInternalServiceDisabled = !this.isServiceEnabled(serviceId);
        String internalServiceBundledInService = this.myProperties.getProperty(bundledInDefaultContainerProperty);
        if (isInternalServiceDisabled) {
            if (internalServiceBundledInService != null) {
                this.myProperties.remove(bundledInDefaultContainerProperty);
            }
        } else {
            if (internalServiceBundledInService != null && !"bundleProcess".equals(internalServiceBundledInService)) {
                this.LOG.debug(String.format("Service %s could be started in Default Servlet Container of %s with id [%s] only", serviceId, this.getBundlePresentationName(), "bundleProcess"));
            }
            this.myProperties.setProperty(bundledInDefaultContainerProperty, "bundleProcess");
        }
    }

    private void processProductPresentationNameProperty() {
        if (!this.myProperties.containsKey("bundle.product.presentation_name")) {
            String bundleVersion;
            String manufacturer = this.myProperties.getProperty("bundle.product.manufacturer");
            if (manufacturer == null) {
                throw new StatusException(String.format("Mandatory field %s is not defined in bundle_build.properties", "bundle.product.manufacturer"));
            }
            String bundleProduct = this.getBundleProductName();
            String bundlePresentationName = bundleProduct != null ? ((bundleVersion = this.myProperties.getProperty("bundle.product.version")) != null ? manufacturer + " " + bundleProduct + " " + bundleVersion : manufacturer + " " + bundleProduct) : manufacturer + " Ring Bundle";
            this.myProperties.setProperty("bundle.product.presentation_name", bundlePresentationName);
        }
    }

    private void processProductManufacturerProperty() {
        if (!this.myProperties.containsKey("bundle.product.manufacturer")) {
            this.myProperties.setProperty("bundle.product.manufacturer", "JetBrains");
        }
    }

    @NotNull
    public String getProductFullVersionNumber() {
        return this.myProperties.getProperty("bundle.product.version") + "." + this.myProperties.getProperty("bundle.product.build");
    }

    @NotNull
    public String getBundlePresentationName() {
        return this.myProperties.getProperty("bundle.product.presentation_name");
    }

    public String getBundleProductName() {
        return this.myProperties.getProperty("bundle.product.name");
    }

    @Nullable
    public String getBundleProductUpgradeMinimalVersion() {
        return this.myProperties.getProperty("bundle.product.upgrade.minimal.version");
    }

    @NotNull
    public String getBundleProductManufacturer() {
        return this.myProperties.getProperty("bundle.product.manufacturer");
    }

    @NotNull
    public String getBundleUpgradeHelpLink() {
        return this.myProperties.getProperty("bundle.upgrade.help-link");
    }

    @Nullable
    public String getBundleProductWhatsNewLink() {
        return this.myProperties.getProperty("bundle.product.whats-new-link");
    }

    @Nullable
    public String getBundleTlsFilesGenerationPageLink() {
        return this.myProperties.getProperty("bundle.product.tls-files-generation-help-link");
    }

    @NotNull
    public String getBundleProductProxyHelpLink() {
        String proxyHelpLink = this.myProperties.getProperty("bundle.product.proxy-help-link");
        return proxyHelpLink != null ? proxyHelpLink : "http://proxy_help_link_is_not_defined";
    }

    @NotNull
    Map<String, String> getBundledServices() {
        return PropertiesBasedConfigurationHelper.getHelper().getAllBundledServices((Object)this.myProperties);
    }

    @NotNull
    Collection<String> getServicesBundledIn(@NotNull String serviceContainerId) {
        return PropertiesBasedConfigurationHelper.getHelper().getBundledInProcessServices((Object)this.myProperties, serviceContainerId);
    }

    @NotNull
    Set<String> getAllBundledServiceContainers() {
        return PropertiesBasedConfigurationHelper.getHelper().getAllBundleServiceContainers((Object)this.myProperties);
    }

    private boolean isBundledIn(String bundledServiceId, @NotNull String serviceContainer) {
        Map<String, String> serviceMap = this.getBundledServices();
        return serviceContainer.equals(serviceMap.get(bundledServiceId));
    }

    boolean isBundledInDefaultServiceContainer(String bundledServiceId) {
        return this.isBundledIn(bundledServiceId, "bundleProcess");
    }

    boolean isBundledService(String serviceId) {
        return PropertiesBasedConfigurationHelper.getHelper().getAllBundledServices((Object)this.myProperties).containsKey(serviceId);
    }

    boolean isDefaultService(@NotNull String serviceId) {
        String defaultService = this.myProperties.getProperty("default.service");
        return serviceId.equals(defaultService);
    }

    boolean isServiceEnabled(@NotNull String serviceId) {
        return Boolean.valueOf(this.myProperties.getProperty(BundleProperty.constructDisableServiceProperty((String)serviceId, (boolean)false))) == false;
    }

    String getDefaultService() {
        return this.myProperties.getProperty("default.service");
    }

    Properties getProperties() {
        return this.myProperties;
    }

    @NotNull
    String getBundleVersion() {
        return this.myBundleVersion.getBundleVersion();
    }

    public boolean isUpgradeAvailable() {
        return Boolean.valueOf(this.myProperties.getProperty("bundle.wizard.upgrade_available"));
    }

    public boolean isExternalHubPermitted() {
        return Boolean.valueOf(this.myProperties.getProperty("bundle.wizard.external_hub_permitted", Boolean.TRUE.toString()));
    }

    public boolean isListenAddressEditable() {
        return Boolean.valueOf(this.myProperties.getProperty(BundleBuildPropertyName.BUNDLE_LISTEN_ADDRESS_IS_ENABLED_IN_WIZARD_PROPERTY, Boolean.FALSE.toString()));
    }

    String getMinimalHubVersion() {
        return this.myProperties.getProperty("bundle.minimal-hub-version");
    }

    boolean hubCanBeUsedByExternalServices() {
        return Boolean.valueOf(this.myProperties.getProperty("bundle.hub-used-by-external-services"));
    }

    boolean isBundleProductEntropyCheckRequired() {
        return Boolean.valueOf(this.myProperties.getProperty(BundleBuildPropertyName.BUNDLE_PRODUCT_ENTROPY_CHECK));
    }

    boolean isFreePhysicalMemoryCheckRequired() {
        return Boolean.valueOf(this.myProperties.getProperty("bundle.free.physical.memory.check"));
    }

    public boolean isHttpsInWizardEnabled() {
        String value = this.myProperties.getProperty("bundle.wizard.https_feature_flag");
        return value == null || Boolean.valueOf(value) != false;
    }

    public String getLocalesCommunityLink() {
        return this.myProperties.getProperty("bundle.locales.community.link");
    }
}

