/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleBuildProperties;
import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.HubPropertiesProvider;
import com.jetbrains.bundle.PortAllocator;
import com.jetbrains.bundle.Services;
import com.jetbrains.bundle.UpgradeProperties;
import com.jetbrains.bundle.launcher.config.ConsistencyKeeper;
import com.jetbrains.bundle.launcher.config.ConsistencyKeeperFactory;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolderFactory;
import com.jetbrains.bundle.listener.BundleListener;
import com.jetbrains.bundle.listener.event.ConfigureFinishedEvent;
import com.jetbrains.bundle.listener.event.StartFinishedEvent;
import com.jetbrains.bundle.wizard.WizardConfiguredProperties;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.contexts.ApplicationContext;
import com.jetbrains.launcher.contexts.StartupContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleState {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final BundleEnvironment myEnvironment;
    private final BundleBuildProperties myBuildProperties;
    private final BundleProperties myProperties;
    @NotNull
    private final UpgradeProperties myUpgradeProperties;
    private final PortAllocator myPortAllocator;
    private final ConsistencyKeeper myConsistencyKeeper;
    private final ApplicationContextHolder myContextHolder;
    private Services myServices;
    private final String myRunId;
    private boolean myRunAfterWizardCompletionFlag = false;
    private final List<BundleListener<StartFinishedEvent>> startFinishedListeners = new ArrayList<BundleListener<StartFinishedEvent>>();
    private final List<BundleListener<ConfigureFinishedEvent>> configureFinishedListeners = new ArrayList<BundleListener<ConfigureFinishedEvent>>();
    private volatile Status myStatus = Status.STARTING;

    public BundleState(@NotNull BundleEnvironment environment, ApplicationContext context, String runId) {
        this.myRunId = runId;
        this.myEnvironment = environment;
        this.myContextHolder = new ApplicationContextHolderFactory().get(context);
        this.myBuildProperties = new BundleBuildProperties(this.myEnvironment);
        this.myProperties = new BundleProperties(this.myEnvironment, this.myContextHolder, this.myBuildProperties);
        this.myUpgradeProperties = new UpgradeProperties(environment, this.myBuildProperties, this.myProperties);
        this.myPortAllocator = new PortAllocator(this.myProperties, environment);
        this.myConsistencyKeeper = new ConsistencyKeeperFactory().get(this.myContextHolder.getContext());
        this.addStartFinishedListener(new BundleProperties.BundleStartFinishedListener());
        this.addConfigureFinishedListener(new BundleProperties.BundleConfigureFinishedListener());
        this.addStartFinishedListener(new HubPropertiesProvider.BundleStartFinishedListener());
        this.addStartFinishedListener(new WizardConfiguredProperties.BundleStartFinishedListener());
        this.addStartFinishedListener(new UpgradeProperties.StartFinishedListener());
        this.addConfigureFinishedListener(new UpgradeProperties.ConfigureFinishedListener());
        this.myConsistencyKeeper.addBundleLifeCycleListeners(this);
        BundleState.loadInstallationUserDnsDomain(environment);
    }

    @NotNull
    public BundleEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    @NotNull
    public BundleProperties getProperties() {
        return this.myProperties;
    }

    @NotNull
    public BundleBuildProperties getBuildProperties() {
        return this.myBuildProperties;
    }

    @NotNull
    public PortAllocator getPortAllocator() {
        return this.myPortAllocator;
    }

    public void updateBundleConfigFromWizard(WizardConfiguredProperties wizardConfiguredProperties) {
        this.updateBundleConfigFromWizard(wizardConfiguredProperties, false);
    }

    public void updateBundleConfigFromWizard(WizardConfiguredProperties wizardConfiguredProperties, boolean afterWizardCompletion) {
        this.myRunAfterWizardCompletionFlag = afterWizardCompletion;
        wizardConfiguredProperties.reloadProperties();
        this.LOG.debug("wizardConfiguredProperties.getProperties() is " + (wizardConfiguredProperties.exists() ? "not null" : "null"));
        if (wizardConfiguredProperties.exists()) {
            ArrayList<String> updatedProperties = new ArrayList<String>();
            updatedProperties.addAll(this.myProperties.updatePropertiesByWizard(wizardConfiguredProperties.getProperties()));
            updatedProperties.addAll(HubPropertiesProvider.updatePropertiesByWizard(wizardConfiguredProperties.getProperties(), this.myEnvironment));
            updatedProperties.addAll(this.myUpgradeProperties.updatePropertiesByWizard(wizardConfiguredProperties.getProperties(), this.myProperties));
            wizardConfiguredProperties.removeProperties(updatedProperties);
        }
    }

    boolean isDefaultServiceContainer(String serviceId) {
        return "bundleProcess".equals(serviceId) || "configurationWizard".equals(serviceId);
    }

    public boolean addStartFinishedListener(BundleListener<StartFinishedEvent> listener) {
        if (this.startFinishedListeners.contains(listener)) {
            this.startFinishedListeners.remove(listener);
        }
        return this.startFinishedListeners.add(listener);
    }

    public boolean removeStartFinishedListener(BundleListener<StartFinishedEvent> listener) {
        return this.startFinishedListeners.remove(listener);
    }

    public boolean addConfigureFinishedListener(BundleListener<ConfigureFinishedEvent> listener) {
        if (this.configureFinishedListeners.contains(listener)) {
            this.configureFinishedListeners.remove(listener);
        }
        return this.configureFinishedListeners.add(listener);
    }

    public boolean removeConfigureFinishedListener(BundleListener<ConfigureFinishedEvent> listener) {
        return this.configureFinishedListeners.remove(listener);
    }

    public void onStartFinished(Throwable t) {
        StartFinishedEvent event = new StartFinishedEvent(this);
        for (BundleListener<StartFinishedEvent> listener : this.startFinishedListeners) {
            try {
                if (t == null) {
                    listener.onSuccess(event);
                    continue;
                }
                listener.onFailure(event, t);
            }
            catch (Exception e) {
                this.LOG.debug(String.format("Listener [%s] failed to process 'start finished' event: %s", listener.getClass().getName(), e.getMessage()), (Throwable)e);
            }
        }
    }

    public void onConfigureFinished(Throwable t) {
        ConfigureFinishedEvent event = new ConfigureFinishedEvent(this);
        for (BundleListener<ConfigureFinishedEvent> listener : this.configureFinishedListeners) {
            try {
                if (t == null) {
                    listener.onSuccess(event);
                    continue;
                }
                listener.onFailure(event, t);
            }
            catch (Exception e) {
                this.LOG.debug(String.format("Listener [%s] failed to process 'configure finished' event: %s", listener.getClass().getName(), e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean isStartingMode() {
        return this.myContextHolder.getContext() instanceof StartupContext;
    }

    void updateLauncherConfig() {
        this.myConsistencyKeeper.updateLauncherConfig(this);
    }

    public void setStatus(Status status) {
        this.myStatus = status;
    }

    @NotNull
    static StatusDescriptor getStatus(@Nullable BundleState bundleState) {
        if (bundleState != null) {
            return bundleState.getStatus();
        }
        StatusDescriptor status = new StatusDescriptor(Status.STARTING, "Application has not been initialized yet.");
        return status;
    }

    @NotNull
    private StatusDescriptor getStatus() {
        StatusDescriptor status = this.myStatus == Status.CONFIGURING ? new StatusDescriptor(this.myStatus, String.format("%s is configuring", this.myBuildProperties.getBundlePresentationName())) : (this.myStatus == Status.SHUTTING_DOWN ? new StatusDescriptor(this.myStatus, String.format("%s is shutting down", this.myBuildProperties.getBundlePresentationName())) : (this.myServices == null ? new StatusDescriptor(Status.STARTING, String.format("%s has not been initialized yet.", this.myBuildProperties.getBundlePresentationName())) : this.myServices.getBundleStatus()));
        return status;
    }

    @NotNull
    public ApplicationContextHolder getContextHolder() {
        return this.myContextHolder;
    }

    @NotNull
    public UpgradeProperties getUpgradeProperties() {
        return this.myUpgradeProperties;
    }

    public String getRunId() {
        return this.myRunId;
    }

    private static void loadInstallationUserDnsDomain(@NotNull BundleEnvironment environment) {
        String userDnsDomain = environment.getInstallationConfig().getUserDnsDomain();
        if (userDnsDomain != null) {
            System.setProperty("jetbrains.bundle.installation.user.dns.domain", userDnsDomain);
        }
    }

    public Services getServices() {
        return this.myServices;
    }

    public void setServices(Services services) {
        this.myServices = services;
    }

    public boolean isRunAfterWizardCompletion() {
        return this.myRunAfterWizardCompletionFlag;
    }
}

