/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.service.util.StatusException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

class BundleVersion {
    private static final String BUNDLE_VERSION_PROPERTIES_FILE_NAME = "version.properties";
    private static final String BUNDLE_VERSION_PROPERTY = "bundle.build.number";
    private final Properties myProperties = new Properties();

    BundleVersion() {
        try (InputStream is = this.getClass().getResourceAsStream("/version.properties");){
            this.myProperties.load(is);
        }
        catch (IOException e) {
            throw new StatusException(String.format("Could not load resource file %s", BUNDLE_VERSION_PROPERTIES_FILE_NAME), (Throwable)e);
        }
        if (!this.myProperties.containsKey(BUNDLE_VERSION_PROPERTY)) {
            throw new IllegalStateException(String.format("Property %s is missing in resource file %s", BUNDLE_VERSION_PROPERTY, BUNDLE_VERSION_PROPERTIES_FILE_NAME));
        }
    }

    @NotNull
    String getBundleVersion() {
        return this.myProperties.getProperty(BUNDLE_VERSION_PROPERTY);
    }
}

