/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleBuildProperties;
import com.jetbrains.bundle.PropertiesProvider;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.service.util.BundleProperty;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class BundledBuildTimePropertyProvider
implements PropertiesProvider {
    private final BundleBuildProperties myBundleBuildProperties;
    private final List<ServiceDescriptor> myServices;

    public BundledBuildTimePropertyProvider(@NotNull BundleBuildProperties bundleBuildProperties, @NotNull List<ServiceDescriptor> services) {
        this.myBundleBuildProperties = bundleBuildProperties;
        this.myServices = services;
    }

    @Override
    public void addToServiceProperties(@NotNull ServiceDescriptor descriptor, @NotNull Properties serviceProperties) {
        String servicePropertyPrefix = "service." + descriptor.getId() + ".";
        Properties allBuildProperties = this.myBundleBuildProperties.getProperties();
        for (String buildPropName : allBuildProperties.stringPropertyNames()) {
            if (BundleProperty.VIRTUAL_HOSTS_DEFAULT.getPrefixedName().equals(buildPropName) && serviceProperties.containsKey(buildPropName)) continue;
            String servicePropName = buildPropName.startsWith(servicePropertyPrefix) ? buildPropName.substring(servicePropertyPrefix.length()) : buildPropName;
            serviceProperties.setProperty(servicePropName, allBuildProperties.getProperty(buildPropName));
        }
        for (ServiceDescriptor someServiceDescriptor : this.myServices) {
            String disableServicePropertyName = BundleProperty.constructDisableServiceProperty((String)someServiceDescriptor.getId(), (boolean)false);
            if (serviceProperties.containsKey(disableServicePropertyName) || !this.myBundleBuildProperties.isServiceEnabled(someServiceDescriptor.getId())) continue;
            serviceProperties.setProperty(disableServicePropertyName, Boolean.FALSE.toString());
        }
        serviceProperties.setProperty("bundle.version", this.myBundleBuildProperties.getBundleVersion());
    }
}

