/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleEnvironmentPropertiesProvider;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.BundlePropertiesProvider;
import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.BundledBuildTimePropertyProvider;
import com.jetbrains.bundle.HubPropertiesProvider;
import com.jetbrains.bundle.PropertiesProvider;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.UpgradePropertiesProvider;
import com.jetbrains.bundle.services.impl.BundleBackendService;
import com.jetbrains.bundle.wizard.WizardConfiguredProperties;
import com.jetbrains.bundle.wizard.WizardPropertiesProvider;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class ServicesConfiguration {
    private static final String LOCALHOST = "127.0.0.1";
    private static final String DEFAULT_LISTEN_VALUE = "127.0.0.1";
    private final List<ServiceDescriptor> myAllServices;
    private final WizardConfiguredProperties myWizardConfiguredProperties;
    private final BundleState myBundleState;

    public ServicesConfiguration(List<ServiceDescriptor> allServices, @NotNull BundleState bundleState) {
        this.myAllServices = allServices;
        this.myWizardConfiguredProperties = new WizardConfiguredProperties(bundleState.getEnvironment());
        this.myBundleState = bundleState;
    }

    private void addServiceConfiguration(Properties properties, ServiceDescriptor beingConfiguredService, ServiceDescriptor service) {
        boolean areTheSameServices = beingConfiguredService.getId().equals(service.getId());
        String propertyPrefix = areTheSameServices ? "" : PropertiesBasedConfigurationHelper.getHelper().constructServicePrefix(service.getId());
        String id = service.getId();
        ServicesConfiguration.setNetworkSettings(properties, propertyPrefix, id, this.myBundleState);
        properties.setProperty(propertyPrefix + ServiceProperties.DATA_DIR_PROPERTY, this.myBundleState.getProperties().getDataDirectory(id, service.isInternal()).toString());
        properties.setProperty(propertyPrefix + ServiceProperties.BACKUPS_DIR_PROPERTY, this.myBundleState.getProperties().getBackupsDirectory(id, service.isInternal()).toString());
        properties.setProperty(propertyPrefix + ServiceProperties.LOGS_DIR_PROPERTY, this.myBundleState.getProperties().getLogsDirectory(id, service.isInternal()).toString());
        properties.setProperty(propertyPrefix + ServiceProperties.TEMP_DIR_PROPERTY, this.myBundleState.getProperties().getTempDirectory(id, service.isInternal()).toString());
        properties.setProperty(propertyPrefix + "id", service.getId());
        properties.setProperty(propertyPrefix + "context", this.myBundleState.getProperties().getFullServiceUrlPath(service));
        properties.setProperty(propertyPrefix + "base-url", this.getServiceUrl(service));
        properties.setProperty(propertyPrefix + "service-folder-in-bundle", service.getFullPath().toString());
        if (this.myBundleState.getUpgradeProperties().isCleanInstallationInProgress()) {
            ServicesConfiguration.setIfNotNull(properties, propertyPrefix + "license-key", service.getLicenseKey());
            ServicesConfiguration.setIfNotNull(properties, propertyPrefix + "license-user-name", service.getLicenseUserName());
        }
        if (areTheSameServices && !this.myBundleState.isDefaultServiceContainer(service.getId()) && !this.myBundleState.getBuildProperties().getAllBundledServiceContainers().contains(id)) {
            properties.setProperty("disable-access-log", Boolean.TRUE.toString());
        }
        if (beingConfiguredService.isInternal() || areTheSameServices) {
            ServicesConfiguration.addInternalServiceProperties(properties, propertyPrefix, service);
        }
    }

    private static void setNetworkSettings(Properties properties, String propertyPrefix, String id, BundleState bundleState) {
        String host;
        String listenAddress;
        String listenPort;
        String bundleListenAddress = bundleState.getProperties().getListenAddress();
        if (bundleState.getBuildProperties().isBundledInDefaultServiceContainer(id)) {
            listenPort = Integer.toString(bundleState.getProperties().getListenPort());
            listenAddress = "127.0.0.1";
            host = "0.0.0.0".equals(bundleListenAddress) ? "127.0.0.1" : bundleListenAddress;
        } else if (bundleState.isDefaultServiceContainer(id)) {
            listenPort = Integer.toString(bundleState.getProperties().getListenPort());
            listenAddress = bundleListenAddress;
            host = "0.0.0.0".equals(bundleListenAddress) ? "127.0.0.1" : bundleListenAddress;
        } else if (bundleState.getBuildProperties().isBundledService(id)) {
            String serviceContainer = bundleState.getBuildProperties().getBundledServices().get(id);
            listenPort = Integer.toString(bundleState.getPortAllocator().allocateRange(serviceContainer));
            listenAddress = "127.0.0.1";
            host = "127.0.0.1";
        } else {
            listenPort = Integer.toString(bundleState.getPortAllocator().allocateRange(id));
            listenAddress = "127.0.0.1";
            host = "127.0.0.1";
        }
        properties.setProperty(propertyPrefix + "port", listenPort);
        properties.setProperty(propertyPrefix + "listen", listenAddress);
        properties.setProperty(propertyPrefix + "host", host);
    }

    private static void addInternalServiceProperties(Properties serviceProperties, String propertyPrefix, ServiceDescriptor anotherServiceDescriptor) {
        serviceProperties.setProperty(propertyPrefix + "is-parent-first-class-loading", String.valueOf((Object)anotherServiceDescriptor.isParentFirstClassLoading()));
        serviceProperties.setProperty(propertyPrefix + "is-internal-service", String.valueOf((Object)anotherServiceDescriptor.isInternal()));
        serviceProperties.setProperty(propertyPrefix + "presentation-service-name", anotherServiceDescriptor.getPresentableName());
        serviceProperties.setProperty(propertyPrefix + "manufacturer", anotherServiceDescriptor.getManufacturer());
        serviceProperties.setProperty(propertyPrefix + "is-annotation-based", String.valueOf(anotherServiceDescriptor.isAnnotationBased()));
        serviceProperties.setProperty(propertyPrefix + "is-web-app", String.valueOf(anotherServiceDescriptor.isWebApp()));
        ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "before-start-callback-class", anotherServiceDescriptor.getBeforeStartCallbackClass());
        ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "after-start-callback-class", anotherServiceDescriptor.getAfterStartCallbackClass());
        ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "status-page-context-path", anotherServiceDescriptor.getStatusPageContextPath());
        ServicesConfiguration.setGzipSettings(serviceProperties, propertyPrefix, anotherServiceDescriptor);
    }

    private static void setGzipSettings(Properties serviceProperties, String propertyPrefix, ServiceDescriptor anotherServiceDescriptor) {
        ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-enable", String.valueOf(anotherServiceDescriptor.getGzipSettings() != null));
        if (anotherServiceDescriptor.getGzipSettings() != null) {
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-included-mime-types", anotherServiceDescriptor.getGzipSettings().getIncludedMimeTypes());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-excluded-mime-types", anotherServiceDescriptor.getGzipSettings().getExcludedMimeTypes());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-included-methods", anotherServiceDescriptor.getGzipSettings().getIncludedMethods());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-excluded-methods", anotherServiceDescriptor.getGzipSettings().getExcludedMethods());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-included-paths", anotherServiceDescriptor.getGzipSettings().getIncludedPaths());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-excluded-paths", anotherServiceDescriptor.getGzipSettings().getExcludedPaths());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-included-agent-patterns", anotherServiceDescriptor.getGzipSettings().getIncludedAgentPatterns());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-excluded-agent-patterns", anotherServiceDescriptor.getGzipSettings().getExcludedAgentPatterns());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-check-exists", anotherServiceDescriptor.getGzipSettings().isCheckGzExists());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-min-size", anotherServiceDescriptor.getGzipSettings().getMinGzipSize());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-compression-level", anotherServiceDescriptor.getGzipSettings().getCompressionLevel());
            ServicesConfiguration.setIfNotNull(serviceProperties, propertyPrefix + "gzip-sync-flush", anotherServiceDescriptor.getGzipSettings().isSyncFlush());
        }
    }

    private static void setIfNotNull(Properties serviceProperties, String propertyName, String propertyValue) {
        if (propertyValue != null) {
            serviceProperties.setProperty(propertyName, propertyValue);
        }
    }

    @NotNull
    public String getServiceUrl(@NotNull ServiceDescriptor descriptor) {
        return this.myBundleState.getProperties().getServiceUrl(descriptor);
    }

    @NotNull
    public Properties getServiceConfiguration(@NotNull ServiceDescriptor descriptor) {
        Properties properties = new Properties();
        for (ServiceDescriptor service : this.myAllServices) {
            this.addServiceConfiguration(properties, descriptor, service);
        }
        for (PropertiesProvider propertiesProvider : this.getPropertiesProvider()) {
            propertiesProvider.addToServiceProperties(descriptor, properties);
        }
        return properties;
    }

    @NotNull
    public BundleState getBundleState() {
        return this.myBundleState;
    }

    public WizardConfiguredProperties getWizardConfiguredProperties() {
        return this.myWizardConfiguredProperties;
    }

    public BundleProperties getBundleProperties() {
        return this.myBundleState.getProperties();
    }

    public boolean isBundledService(String serviceId) {
        return this.myBundleState.getBuildProperties().isBundledService(serviceId);
    }

    private List<PropertiesProvider> getPropertiesProvider() {
        return Arrays.asList(new BundlePropertiesProvider(this.myBundleState.getEnvironment(), this.myBundleState.getProperties(), this.myAllServices), new UpgradePropertiesProvider(this.myBundleState.getUpgradeProperties(), this.myAllServices), new HubPropertiesProvider(this.myBundleState.getEnvironment(), this.myAllServices, this.myBundleState.getProperties()), new BundledBuildTimePropertyProvider(this.myBundleState.getBuildProperties(), this.myAllServices), new WizardPropertiesProvider(this.myWizardConfiguredProperties, this.myAllServices), new BundleEnvironmentPropertiesProvider(this.myBundleState.getEnvironment()), new BundleBackendService.BundleBackendPropertyProvider(this.myBundleState, this.myAllServices));
    }
}

