/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.api.internal.awc.ext.impl;

import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.api.internal.auth.AuthResult;
import com.jetbrains.bundle.api.internal.awc.ext.AdminConsoleExtension;
import com.jetbrains.bundle.api.internal.awc.ext.model.HubSettings;
import com.jetbrains.bundle.api.internal.awc.ext.model.KeyStoreSettings;
import com.jetbrains.bundle.api.internal.awc.ext.model.ProductState;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.Migration;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationStatus;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationStatusEnum;
import com.jetbrains.bundle.api.internal.services.ServicesInformationProvider;
import com.jetbrains.bundle.hub_client.util.BundleHubClient;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.PropertiesUtil;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminConsoleExtensionImpl
implements AdminConsoleExtension {
    public static final String MIGRATION_PROPERTIES_FILE_NAME = "migration.properties";
    private final File myMigrationStorageDir;
    private final File myMigrationStorageFile;
    private final BundleHubClient myBundleHubClient;
    private final BundleState myBundleState;
    private final String myPublicHubUrl;
    private final String myInternalHubUrl;
    protected Logger LOG = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final String myAwcToken;
    @NotNull
    private final File myAwcTokenStorage;
    @NotNull
    private final Properties myAdminConsoleProperties;
    private final boolean myInternalHubExistsFlag;
    @NotNull
    private final KeyStoreSettings myKeyStoreSettings;
    @NotNull
    private final ServicesInformationProvider myServicesInformationProvider;
    @NotNull
    private final String myUrlOfServiceForRedirectionAfterStart;

    public AdminConsoleExtensionImpl(@NotNull File migrationStorageDir, @Nullable BundleHubClient bundleHubClient, @Nullable String publicHubUrl, @Nullable String internalHubUrl, @NotNull BundleState bundleState, @NotNull String awcToken, @NotNull File awcTokenStorage, @NotNull Properties adminConsoleProperties, boolean internalHubExistsInBundleFlag, @NotNull KeyStoreSettings keyStoreSettings, @NotNull ServicesInformationProvider servicesInformationProvider, @NotNull String urlOfServiceForRedirectionAfterStart) {
        this.myMigrationStorageDir = migrationStorageDir;
        this.myMigrationStorageFile = new File(this.myMigrationStorageDir, MIGRATION_PROPERTIES_FILE_NAME);
        this.myBundleHubClient = bundleHubClient;
        this.myBundleState = bundleState;
        this.myAwcToken = awcToken;
        this.myAwcTokenStorage = awcTokenStorage;
        this.myAdminConsoleProperties = adminConsoleProperties;
        this.myInternalHubExistsFlag = internalHubExistsInBundleFlag;
        this.myKeyStoreSettings = keyStoreSettings;
        this.myServicesInformationProvider = servicesInformationProvider;
        this.myPublicHubUrl = publicHubUrl;
        this.myInternalHubUrl = internalHubUrl;
        this.myUrlOfServiceForRedirectionAfterStart = urlOfServiceForRedirectionAfterStart;
    }

    public void init() {
    }

    private void archiveOldMigrationData() {
        if (this.myMigrationStorageFile.exists()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy-HH-mm-ss");
            String suffix = "." + dateFormat.format(this.myMigrationStorageFile.lastModified()) + ".old";
            try {
                Files.copy(this.myMigrationStorageFile.toPath(), this.myMigrationStorageDir.toPath().resolve(this.myMigrationStorageFile.getName() + suffix), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot rename old " + this.myMigrationStorageFile.getAbsolutePath() + " file:" + e.getMessage(), e);
            }
        }
    }

    public Migration getMigration() {
        return this.myMigrationStorageFile.exists() ? this.convert(ConfiguratorUtils.loadPropertiesFile((File)this.myMigrationStorageFile)) : null;
    }

    public Migration storeMigration(@NotNull Migration migration) {
        ConfiguratorUtils.savePropertiesFile((File)this.myMigrationStorageFile, (Properties)this.convert(migration));
        return migration;
    }

    public void deleteMigration(boolean backup) {
        if (this.myMigrationStorageFile.exists()) {
            if (backup) {
                this.archiveOldMigrationData();
            }
            if (!this.myMigrationStorageFile.delete()) {
                throw new RuntimeException("Cannot delete migration file " + this.myMigrationStorageFile.getAbsolutePath());
            }
        }
    }

    public Collection<Migration> getBackedUpMigrations() {
        File[] backupFiles = this.myMigrationStorageDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".old");
            }
        });
        ArrayList<Migration> backups = new ArrayList<Migration>();
        for (File f : backupFiles) {
            try {
                backups.add(this.convert(ConfiguratorUtils.loadPropertiesFile((File)f)));
            }
            catch (Exception ignored) {
                this.LOG.debug(String.format("Exception while parsing backed up migration file %s", f));
            }
        }
        return backups;
    }

    @NotNull
    public HubSettings getHubSettings() {
        return new HubSettings(this.myPublicHubUrl, this.myInternalHubUrl, this.myBundleHubClient != null ? this.myBundleHubClient.getBundleServiceId() : null, this.myBundleHubClient != null ? this.myBundleHubClient.getBundleServiceSecret() : null, this.isInternalHubUsed(), this.isHubRunning(), this.isInternalHubExistsFlag(), this.isRelinkToExternalHubAllowed(), this.getHubServicesWithSecrets());
    }

    @NotNull
    public ProductState getProductState() {
        return new ProductState(this.myServicesInformationProvider.isBundleStarting(), this.myBundleState.getBuildProperties().getBundleProductName(), this.myBundleState.getBuildProperties().getBundlePresentationName(), this.myUrlOfServiceForRedirectionAfterStart, this.myBundleState.getRunId(), this.myBundleState.getBuildProperties().getBundleProductProxyHelpLink());
    }

    @NotNull
    private Map<String, String> getHubServicesWithSecrets() {
        Map serviceToHubServiceId = PropertiesBasedConfigurationHelper.getHelper().getServicesPropertyValue((Object)this.myAdminConsoleProperties, "hub-service-id");
        HashMap<String, String> hubServiceIdsAndSecrets = new HashMap<String, String>();
        for (Map.Entry hubService : serviceToHubServiceId.entrySet()) {
            hubServiceIdsAndSecrets.put((String)hubService.getValue(), PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)this.myAdminConsoleProperties, (String)hubService.getKey(), "hub-service-secret"));
        }
        return hubServiceIdsAndSecrets;
    }

    public boolean isRelinkToExternalHubAllowed() {
        return !"Hub".equals(this.myBundleState.getBuildProperties().getBundleProductName());
    }

    private boolean isInternalHubUsed() {
        return this.myBundleHubClient != null && this.myBundleHubClient.isInternalHub();
    }

    private boolean isHubRunning() {
        return this.isInternalHubUsed();
    }

    private boolean isInternalHubExistsFlag() {
        return this.myInternalHubExistsFlag;
    }

    public void applyExternalHub(@NotNull String hubUrl) {
        this.myBundleState.getProperties().switchToExternalHub(hubUrl);
        this.myBundleState.getContextHolder().requestRestart(Collections.singletonMap(ApplicationContextHolder.RestartParameters.openBrowserOnStartUp.name(), Boolean.FALSE.toString()));
    }

    public void switchToInternalHub() {
        if (!this.isInternalHubUsed() && this.isInternalHubExistsFlag()) {
            this.myBundleState.getProperties().switchToInternalHub();
            this.myBundleState.getContextHolder().requestRestart(Collections.singletonMap(ApplicationContextHolder.RestartParameters.openBrowserOnStartUp.name(), Boolean.FALSE.toString()));
        } else {
            this.LOG.warn("Skip switching to internal Hub. Product either has already used or doesn't include internal Hub.");
        }
    }

    @NotNull
    public AuthResult authenticate(@NotNull String awcToken) {
        return new AuthResult(this.myAwcToken.equals(awcToken) ? AuthResult.Code.SUCCESS : AuthResult.Code.FAILED, null, this.myAwcTokenStorage);
    }

    @NotNull
    public KeyStoreSettings getKeyStoreSettings() {
        return this.myKeyStoreSettings;
    }

    public void storeClientCertificatePassword(@NotNull String clientCertificateAlias, @NotNull String clientCertificatePassword) {
        throw new UnsupportedOperationException("Storing of client certificate info is not supported by product");
    }

    @NotNull
    private Properties convert(@NotNull Migration migration) {
        Properties properties = new Properties();
        PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"active", (String)Boolean.valueOf(migration.isActive()).toString());
        PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"external-hub-url", (String)migration.getExternalHubUrl());
        PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"external-hub-home-url", (String)migration.getExternalHubHomeUrl());
        PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"external-hub-home-url-available", (String)Boolean.valueOf(migration.isExternalHubHubHomeUrlAvailable()).toString());
        PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"external-hub-migration-id", (String)migration.getExternalHubMigrationId());
        PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"external-hub-service-id", (String)migration.getExternalHubServiceId());
        PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"external-hub-service-secret", (String)migration.getExternalHubServiceSecret());
        PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"external-hub-service-is-verified", (String)Boolean.valueOf(migration.isServiceVerified()).toString());
        PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"relink-after-import", (String)Boolean.valueOf(migration.isRelinkAfterImport()).toString());
        PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"backup-file", (String)migration.getBackupFilePath());
        if (migration.getStatus() != null) {
            PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"status", (String)migration.getStatus().getStatus().getValue());
            if (migration.getStatus().getProgress() != null) {
                PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"status.progress", (String)String.valueOf(migration.getStatus().getProgress()));
            }
            PropertiesUtil.setPropertyIfNotNull((Properties)properties, (String)"status.message", (String)String.valueOf(migration.getStatus().getMessage()));
        }
        return properties;
    }

    @Nullable
    private Migration convert(@Nullable Properties migrationProperties) {
        if (migrationProperties == null) {
            return null;
        }
        Migration migration = new Migration();
        migration.setIsActive(Boolean.valueOf(migrationProperties.getProperty("active")).booleanValue());
        migration.setExternalHubUrl(migrationProperties.getProperty("external-hub-url"));
        migration.setExternalHubHomeUrl(migrationProperties.getProperty("external-hub-home-url"));
        migration.setExternalHubHubHomeUrlAvailable(Boolean.valueOf(migrationProperties.getProperty("external-hub-home-url-available")).booleanValue());
        migration.setExternalHubMigrationId(migrationProperties.getProperty("external-hub-migration-id"));
        migration.setExternalHubServiceId(migrationProperties.getProperty("external-hub-service-id"));
        migration.setExternalHubServiceSecret(migrationProperties.getProperty("external-hub-service-secret"));
        migration.setIsServiceVerified(Boolean.valueOf(migrationProperties.getProperty("external-hub-service-is-verified")).booleanValue());
        migration.setIsRelinkAfterImport(Boolean.valueOf(migrationProperties.getProperty("relink-after-import")).booleanValue());
        migration.setBackupFilePath(migrationProperties.getProperty("backup-file"));
        if (migrationProperties.containsKey("status")) {
            MigrationStatus status = new MigrationStatus();
            status.setStatus(MigrationStatusEnum.fromValue((String)migrationProperties.getProperty("status")));
            if (migrationProperties.containsKey("status.progress")) {
                status.setProgress(Integer.valueOf(Integer.parseInt(migrationProperties.getProperty("status.progress"))));
            }
            status.setMessage(migrationProperties.getProperty("status.message"));
            migration.setStatus(status);
        }
        return migration;
    }
}

