/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RedirectingFilter
implements Filter {
    public static final String REDIRECT_URL_PARAMETER = "redirectAfterStartUrl";
    private String myRedirectUrl;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.myRedirectUrl = filterConfig.getInitParameter(REDIRECT_URL_PARAMETER);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String redirectionUrl = this.myRedirectUrl;
        String queryString = ((HttpServletRequest)servletRequest).getQueryString();
        if (queryString != null) {
            redirectionUrl = redirectionUrl.concat("?").concat(queryString);
        }
        ((HttpServletResponse)servletResponse).sendRedirect(((HttpServletResponse)servletResponse).encodeRedirectURL(redirectionUrl));
    }

    public void destroy() {
    }
}

