/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.proxy.jetty;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.Services;
import com.jetbrains.bundle.api.clientcert.ClientCertificateAuthSettingsService;
import com.jetbrains.bundle.api.clientcert.model.ClientCertAuthSettings;
import com.jetbrains.bundle.filters.DefaultContextRedirectionFilter;
import com.jetbrains.bundle.filters.RedirectingFilter;
import com.jetbrains.bundle.hub_client.util.validation.AdditionalKeystore;
import com.jetbrains.bundle.hub_client.util.validation.CertificateInfo;
import com.jetbrains.bundle.listener.OnePerClassListener;
import com.jetbrains.bundle.listener.event.ServiceStartedEvent;
import com.jetbrains.bundle.listener.event.StartFinishedEvent;
import com.jetbrains.bundle.proxy.jetty.AllowOriginOneTimeFilter;
import com.jetbrains.bundle.proxy.jetty.ErrorPagesServlet;
import com.jetbrains.bundle.proxy.jetty.ProxyServlet;
import com.jetbrains.bundle.services.Service;
import com.jetbrains.bundle.services.ServicesHolder;
import com.jetbrains.bundle.services.impl.ServiceBase;
import com.jetbrains.bundle.services.impl.jetty.BundleJettyServicesContainer;
import com.jetbrains.bundle.util.BundleJvmOption;
import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.jetty.BundleSecurityResponseHeadersFilter;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.SecureMode;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.cmd.ExecuteServiceCommandException;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import com.jetbrains.service.util.ssl.KeystoreUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleProxy
extends BundleJettyServicesContainer
implements ClientCertificateAuthSettingsService {
    private static final String CLIENT_CERT_AUTH_ENABLED_PROPERTY = "client.auth.enabled";
    private static final String CLIENT_AUTH_CERT_NAME_PREFIX = "clientauthcert";
    @NotNull
    private final BundleState myBundleState;
    private Server redirectingContainer;
    private ServletContextHandler myBundleBaseStartupContextHandler;
    @Nullable
    private ClientCertAuthSettings clientCertAuthSettings;

    public BundleProxy(@NotNull ServicesHolder servicesHolder, @NotNull BundleState bundleState) {
        super(servicesHolder, bundleState.getContextHolder());
        this.myBundleState = bundleState;
    }

    @Override
    @NotNull
    protected HandlerCollection getHandlerCollection(@NotNull Properties allProperties, @NotNull Server server) throws StartupException, IOException {
        HandlerCollection handlerCollection = super.getHandlerCollection(allProperties, server);
        this.addInstallationTimeServletContainerIfNeeded(this.myBundleState.getProperties(), this.myBundleState.getEnvironment(), handlerCollection);
        this.addFilterFromStartingPageContextIfNeeded(allProperties, handlerCollection);
        this.addHandlerForRedirectionFromRootContextIfNeeded(allProperties, handlerCollection);
        this.addBundleBaseContextStartupHandler(allProperties, this.myBundleState, this.myBundleState.getEnvironment(), handlerCollection);
        return handlerCollection;
    }

    @NotNull
    protected Server createServer(Properties allProperties) throws Exception {
        Server server = super.createServer(allProperties);
        if (BundleProxy.resolveVirtualHosts(allProperties).length > 0) {
            ((HandlerCollection)server.getHandler()).addHandler((Handler)new VirtualHostsFallbackHandler());
        }
        return server;
    }

    protected void addSecureHandler(@NotNull HandlerCollection handlerCollection, @NotNull Properties allProperties) {
        String secureMode = this.getMandatoryProperty(BundleProperty.SECURE_MODE.getPrefixedName(), allProperties);
        if (secureMode.equals(SecureMode.TLS.getName()) && Boolean.valueOf(allProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getPrefixedName())).booleanValue()) {
            handlerCollection.addHandler((Handler)new SecuredRedirectHandler());
        }
    }

    private void addHandlerForRedirectionFromRootContextIfNeeded(@NotNull Properties allProperties, HandlerCollection handlerCollection) {
        String serviceToRedirectFromRootContext;
        String string = serviceToRedirectFromRootContext = this.getServicesHolder().getSortedServicesIds().contains("configurationWizard") ? "configurationWizard" : PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, "default.service");
        if (serviceToRedirectFromRootContext != null && this.getServicesHolder().getSortedServicesIds().contains(serviceToRedirectFromRootContext)) {
            final String contextPath = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, serviceToRedirectFromRootContext, "context");
            String bundleBaseServletContext = this.myBundleState.getProperties().getContext();
            Map servicesContexts = PropertiesBasedConfigurationHelper.getHelper().getServicesPropertyValue((Object)allProperties, "context");
            if (!servicesContexts.values().contains(bundleBaseServletContext)) {
                ServletContextHandler defaultContextRedirector = new ServletContextHandler(){

                    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                        if (baseRequest.isHandled()) {
                            return;
                        }
                        if (request.getServletPath() != null && UrlUtil.trimSlashes((String)request.getServletPath()).isEmpty()) {
                            String redirectToContext = contextPath;
                            String queryString = request.getQueryString();
                            if (queryString != null) {
                                redirectToContext = redirectToContext.concat("?").concat(queryString);
                            }
                            response.sendRedirect(response.encodeRedirectURL(redirectToContext));
                        }
                    }
                };
                defaultContextRedirector.setContextPath(bundleBaseServletContext);
                handlerCollection.addHandler((Handler)defaultContextRedirector);
            }
        }
    }

    private void addFilterFromStartingPageContextIfNeeded(@NotNull Properties allProperties, HandlerCollection handlerCollection) {
        if (!PropertiesBasedConfigurationHelper.getHelper().isServiceEnabled((Object)allProperties, "startingPage") || null == PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, "startingPage", "id")) {
            ServiceDescriptor serviceForRedirectionFromStartingPageContext = Services.getAfterStartService(allProperties, BundleProxy.getServiceDescriptorsMap(this.getServicesHolder().getSortedServiceDescriptors()));
            String serviceContext = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, serviceForRedirectionFromStartingPageContext.getId(), "context");
            FilterHolder filterHolder = new FilterHolder(RedirectingFilter.class);
            filterHolder.setInitParameter("redirectAfterStartUrl", UrlUtil.ensureEndsWithSlash((String)serviceContext));
            ServletContextHandler bundledStartingPageRedirector = new ServletContextHandler();
            bundledStartingPageRedirector.setContextPath(this.myBundleState.getProperties().getFullServiceUrlPath("/bundle/starting"));
            bundledStartingPageRedirector.addFilter(filterHolder, "", null);
            handlerCollection.addHandler((Handler)bundledStartingPageRedirector);
        }
    }

    @NotNull
    private Collection<String> getAllProxiedServices(@NotNull Properties properties) {
        Collection bundledInDefaultServiceContainer = PropertiesBasedConfigurationHelper.getHelper().getBundledInProcessServices((Object)properties, properties.getProperty("id"));
        Set bundleServiceContainers = PropertiesBasedConfigurationHelper.getHelper().getAllBundleServiceContainers((Object)properties);
        Collection allProxiedServices = PropertiesBasedConfigurationHelper.getHelper().getServices((Object)properties);
        allProxiedServices.removeAll(bundledInDefaultServiceContainer);
        allProxiedServices.removeAll(bundleServiceContainers);
        return allProxiedServices;
    }

    @Override
    protected WebAppContext addServiceToBundleProcess(Properties allProperties, String serviceId, Server server) throws StartupException, IOException {
        WebAppContext bundledServiceWebContext = super.addServiceToBundleProcess(allProperties, serviceId, server);
        this.addCorsFilter((ServletContextHandler)bundledServiceWebContext, allProperties);
        return bundledServiceWebContext;
    }

    public void beforeStart(@NotNull Properties properties) {
        super.beforeStart(properties);
        this.applyJvmOptionsOfBundledServices(properties);
    }

    private void applyJvmOptionsOfBundledServices(Properties allProperties) {
        Set allBundledServices = PropertiesBasedConfigurationHelper.getHelper().getAllBundledServices((Object)allProperties).keySet();
        HashMap<String, HashMap<String, String>> systemProperties = new HashMap<String, HashMap<String, String>>();
        for (String bundledService : allBundledServices) {
            ServiceBase service = this.getServicesHolder().getService(bundledService);
            if (service == null) continue;
            Map<String, String> serviceSystemProperties = this.getServiceSystemProperties(service);
            for (String serviceProperty : serviceSystemProperties.keySet()) {
                HashMap<String, String> propertyValuesByServices = (HashMap<String, String>)systemProperties.get(serviceProperty);
                if (propertyValuesByServices == null) {
                    propertyValuesByServices = new HashMap<String, String>();
                    systemProperties.put(serviceProperty, propertyValuesByServices);
                }
                propertyValuesByServices.put(bundledService, serviceSystemProperties.get(serviceProperty));
            }
        }
        for (String systemProperty : systemProperties.keySet()) {
            Map propertyValuesByServices = (Map)systemProperties.get(systemProperty);
            String alreadySetValue = System.getProperty(systemProperty);
            if (alreadySetValue != null) {
                for (String serviceId : propertyValuesByServices.keySet()) {
                    String servicePropertyValue = (String)propertyValuesByServices.get(serviceId);
                    if (alreadySetValue.equals(servicePropertyValue)) continue;
                    this.getLogger().warn(String.format("Ignoring JVM option [%s=%s] of bundled service [%s], this property has already been set in Bundle to value [%s]", systemProperty, servicePropertyValue, serviceId, alreadySetValue));
                }
                continue;
            }
            if (new HashSet(propertyValuesByServices.values()).size() == 1) {
                String servicePropertyValue = (String)propertyValuesByServices.values().iterator().next();
                System.setProperty(systemProperty, servicePropertyValue);
                this.getLogger().debug(String.format("JVM option [%s=%s] defined for bundled service%s %s is set", systemProperty, servicePropertyValue, propertyValuesByServices.size() > 1 ? "s" : "", new HashSet(propertyValuesByServices.keySet()).toString()));
                continue;
            }
            this.getLogger().warn(String.format("Ignoring JVM option [%s]. It has got different values in different bundled services: %s%s", systemProperty, System.lineSeparator(), propertyValuesByServices.toString()));
        }
    }

    private Map<String, String> getServiceSystemProperties(Service service) {
        try {
            return service.listSystemProperties();
        }
        catch (StatusException | ExecuteServiceCommandException e) {
            this.getLogger().error(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            this.getLogger().debug(String.format("Either service %s doesn't support command [list jvm-options] or it failed to execute", service.getDescriptor().getId()), (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private ServletContextHandler addProxyRule(@NotNull String proxiedServiceId, Properties allProperties) {
        String serviceContext = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, proxiedServiceId, "context");
        String servicePortString = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, proxiedServiceId, "port");
        String serviceHostString = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, proxiedServiceId, "host");
        if (serviceContext != null && servicePortString != null) {
            ServletContextHandler context = new ServletContextHandler(null, serviceContext);
            BundleProxy.setVirtualHosts(context, allProperties);
            this.addCorsFilter(context, allProperties);
            Integer servicePort = Integer.valueOf(servicePortString);
            String to = "http://" + serviceHostString + ":" + servicePort + serviceContext;
            this.getLogger().debug(String.format("Adding proxy route from '%s' to '%s'", serviceContext, to));
            ServletHolder servletHolder = new ServletHolder((Servlet)new ProxyServlet(proxiedServiceId));
            servletHolder.setInitParameter("proxyTo", to);
            servletHolder.setInitParameter("maxThreads", "1024");
            servletHolder.setInitParameter("idleTimeout", BundleProxy.getIdleTimeout().toString());
            servletHolder.setInitParameter("timeout", String.valueOf(10800000));
            servletHolder.setInitParameter("requestBufferSize", BundleProxy.getRequestHeaderBufferSize().toString());
            servletHolder.setInitParameter("responseBufferSize", BundleProxy.getResponseHeaderBufferSize().toString());
            context.addServlet(servletHolder, "/*");
            return context;
        }
        return null;
    }

    private void addCorsFilter(ServletContextHandler context, Properties properties) {
        String allowedOrigins;
        if (!properties.getProperty(BundleProperty.SECURE_MODE.getPrefixedName()).equals(SecureMode.DISABLE.getName())) {
            FilterHolder secureFilter = new FilterHolder(BundleSecurityResponseHeadersFilter.class);
            context.addFilter(secureFilter, "*", EnumSet.allOf(DispatcherType.class));
        }
        if (this.getServicesHolder().getService("configurationWizard") != null) {
            allowedOrigins = "*";
        } else {
            allowedOrigins = this.getConfigWizardCorsAllowedOrigins(properties);
            if (allowedOrigins.trim().isEmpty()) {
                return;
            }
        }
        FilterHolder corsFilterHolder = new FilterHolder(CrossOriginFilter.class);
        corsFilterHolder.setInitParameter("allowedOrigins", allowedOrigins);
        corsFilterHolder.setInitParameter("exposedHeaders", "X-Cache-Date, X-Atmosphere-tracking-id");
        corsFilterHolder.setInitParameter("allowedHeaders", "X-Requested-With, Content-Type, Accept, Origin, cache-control, expires, pragma");
        context.addFilter(corsFilterHolder, "*", EnumSet.allOf(DispatcherType.class));
        FilterHolder allowOriginOneTimeHolder = new FilterHolder(AllowOriginOneTimeFilter.class);
        context.addFilter(allowOriginOneTimeHolder, "*", EnumSet.allOf(DispatcherType.class));
    }

    @NotNull
    private String getConfigWizardCorsAllowedOrigins(Properties properties) {
        URL url;
        String wizardBaseUrl = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, "configurationWizard", "wizard-url");
        StringBuilder configWizardUrls = new StringBuilder();
        if (wizardBaseUrl == null) {
            this.addAdditionalCorsAllowedOrigins(configWizardUrls);
            return configWizardUrls.toString();
        }
        configWizardUrls.append(wizardBaseUrl);
        this.addAdditionalCorsAllowedOrigins(configWizardUrls);
        String wizardActualClientUrl = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, "configurationWizard", "wizard-actual-client-url");
        if (wizardActualClientUrl != null) {
            try {
                url = new URL(wizardActualClientUrl);
                this.addNewAllowedOrigin(url, configWizardUrls, url.getHost());
            }
            catch (MalformedURLException e) {
                this.getLogger().debug(String.format("Malformed URL [%s] was stored by Wizard in property '%s'", wizardActualClientUrl, "wizard-actual-client-url"));
            }
        }
        try {
            url = new URL(wizardBaseUrl);
        }
        catch (MalformedURLException e) {
            return configWizardUrls.toString();
        }
        this.addNewAllowedOrigin(url, configWizardUrls, url.getHost());
        URL internalUrl = null;
        try {
            String internalUrlAsString = UrlUtil.constructUrl((String)"http", (String)"127.0.0.1", (int)Integer.parseInt(properties.getProperty(BundleProperty.LISTEN_PORT.getPrefixedName())), (String)url.getPath());
            internalUrl = new URL(internalUrlAsString);
        }
        catch (NumberFormatException | MalformedURLException e) {
            this.getLogger().debug("Can not construct internal URL of Configuration Wizard service: " + e.getMessage(), (Throwable)e);
        }
        try {
            String canonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
            this.addNewAllowedOrigin(url, configWizardUrls, canonicalHostName);
            this.addNewAllowedOrigin(internalUrl, configWizardUrls, canonicalHostName);
        }
        catch (UnknownHostException e) {
            this.getLogger().debug("Can not get fully qualified domain name address of Configuration Wizard server: " + e.getMessage(), (Throwable)e);
        }
        try {
            InetAddress hostAddress = InetAddress.getLocalHost();
            this.addNewAllowedOrigin(url, configWizardUrls, hostAddress.getHostAddress());
            this.addNewAllowedOrigin(url, configWizardUrls, hostAddress.getHostName());
            this.addNewAllowedOrigin(internalUrl, configWizardUrls, hostAddress.getHostAddress());
            this.addNewAllowedOrigin(internalUrl, configWizardUrls, hostAddress.getHostName());
        }
        catch (UnknownHostException e) {
            this.getLogger().debug("Can not get local host name address of Configuration Wizard server: " + e.getMessage(), (Throwable)e);
        }
        InetAddress loopBackAddress = InetAddress.getLoopbackAddress();
        this.addNewAllowedOrigin(url, configWizardUrls, loopBackAddress.getHostAddress());
        this.addNewAllowedOrigin(url, configWizardUrls, loopBackAddress.getHostName());
        this.addNewAllowedOrigin(internalUrl, configWizardUrls, loopBackAddress.getHostAddress());
        this.addNewAllowedOrigin(internalUrl, configWizardUrls, loopBackAddress.getHostName());
        return configWizardUrls.toString();
    }

    private void addAdditionalCorsAllowedOrigins(StringBuilder configWizardUrls) {
        String additionalCors = BundleJvmOption.ADDITIONAL_CORS.get();
        if (additionalCors != null) {
            String[] additionalUrls;
            for (String additionalUrl : additionalUrls = additionalCors.split(" ")) {
                if (additionalUrl.trim().isEmpty()) continue;
                try {
                    URL url = new URL(additionalUrl);
                    this.addNewAllowedOrigin(url, configWizardUrls, url.getHost());
                }
                catch (MalformedURLException e) {
                    this.getLogger().error(String.format("Malformed URL [%s]", additionalUrl));
                }
            }
        }
    }

    private void addNewAllowedOrigin(URL url, StringBuilder configWizardUrls, String newHost) {
        if (url == null) {
            return;
        }
        try {
            String domainNameUrl = new URL(url.getProtocol(), newHost, url.getPort(), "").toString();
            configWizardUrls.append(",").append(domainNameUrl.toLowerCase());
        }
        catch (MalformedURLException e) {
            this.getLogger().debug("Can not compose URL: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private static Map<String, ServiceDescriptor> getServiceDescriptorsMap(@NotNull List<ServiceDescriptor> descriptorList) {
        HashMap<String, ServiceDescriptor> descriptors = new HashMap<String, ServiceDescriptor>();
        for (ServiceDescriptor descriptor : descriptorList) {
            descriptors.put(descriptor.getId(), descriptor);
        }
        return descriptors;
    }

    public AppExitCode shutdown(boolean force, AppExitCode suggestedExitCode) {
        super.shutdown(force, suggestedExitCode);
        if (this.redirectingContainer != null) {
            try {
                this.redirectingContainer.stop();
            }
            catch (Throwable e) {
                this.getLogger().debug("Could not stop redirecting servlet container", e);
            }
        }
        return suggestedExitCode;
    }

    private void addInstallationTimeServletContainerIfNeeded(BundleProperties bundleProperties, BundleEnvironment environment, HandlerCollection handlerCollection) {
        Date installationConfigLastModifiedDate = environment.getInstallationConfig().getFileLastModifiedDate();
        String installationListenAddress = environment.getInstallationConfig().getListenAddress();
        Integer installationListenPort = environment.getInstallationConfig().getInstallationPort();
        if (installationListenAddress != null && installationListenPort != null && (installationConfigLastModifiedDate == null || System.currentTimeMillis() - installationConfigLastModifiedDate.getTime() < 3600000L)) {
            if (!bundleProperties.getListenAddress().equalsIgnoreCase(installationListenAddress)) {
                if (bundleProperties.getListenPort() == installationListenPort.intValue()) {
                    if (bundleProperties.getListenAddress().equals("0.0.0.0")) {
                        String bundleBaseContext = bundleProperties.getContext();
                        if (!bundleBaseContext.isEmpty() && !bundleBaseContext.equals("/")) {
                            this.addFilterForRedirectionToBundleServletContainer(handlerCollection, bundleProperties);
                        }
                    } else if (installationListenAddress.equals("0.0.0.0")) {
                        this.getLogger().warn(String.format("Can't start listening on {%s:%s}, because product has already occupied {%s:%s}", installationListenAddress, installationListenPort, bundleProperties.getListenAddress(), bundleProperties.getListenPort()));
                    } else {
                        this.redirectingContainer = this.createRedirectingServiceContainer(installationListenAddress, installationListenPort, bundleProperties);
                    }
                } else {
                    this.redirectingContainer = this.createRedirectingServiceContainer(installationListenAddress, installationListenPort, bundleProperties);
                }
            } else if (bundleProperties.getListenPort() != installationListenPort.intValue()) {
                this.redirectingContainer = this.createRedirectingServiceContainer(installationListenAddress, installationListenPort, bundleProperties);
            } else {
                String bundleBaseContext = bundleProperties.getContext();
                if (!bundleBaseContext.isEmpty() && !bundleBaseContext.equals("/")) {
                    this.addFilterForRedirectionToBundleServletContainer(handlerCollection, bundleProperties);
                }
            }
        }
    }

    public Server createJettyServer(int listenPort, @NotNull String listenAddress, @NotNull Properties allProperties) {
        Server server = new Server();
        server.setStopTimeout(5000L);
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        String secureMode = this.getMandatoryProperty(BundleProperty.SECURE_MODE.getPrefixedName(), allProperties);
        if (secureMode.equals(SecureMode.DISABLE.getName())) {
            connectors.add(this.buildHttpServerConnector(listenPort, listenAddress, server));
        } else {
            ServerConnector sslConnector = this.buildSslConnector(listenPort, listenAddress, allProperties, server);
            connectors.add(sslConnector);
            boolean isRedirectionFromHttpEnabled = Boolean.valueOf(allProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getPrefixedName()));
            if (isRedirectionFromHttpEnabled) {
                ServerConnector nonSecureRedirectConnector = this.buildHttpServerConnector(Integer.parseInt(this.getMandatoryProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT.getPrefixedName(), allProperties)), listenAddress, server, listenPort);
                connectors.add(nonSecureRedirectConnector);
            }
        }
        server.setConnectors(connectors.toArray(new Connector[0]));
        return server;
    }

    @NotNull
    private ServerConnector buildSslConnector(int listenPort, @NotNull String listenAddress, @NotNull Properties allProperties, Server server) {
        HttpConfiguration http = new HttpConfiguration();
        http.setSecurePort(listenPort);
        http.setSecureScheme("https");
        http.setSendXPoweredBy(false);
        http.setSendServerVersion(false);
        Integer blockingTimeout = BundleProxy.getBlockingTimeout();
        if (blockingTimeout != null) {
            http.setBlockingTimeout((long)blockingTimeout.intValue());
        }
        http.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        http.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        TrustAllClientsSslContextFactory sslContextFactory = new TrustAllClientsSslContextFactory();
        String keyStorePassword = this.getMandatoryProperty(BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getPrefixedName(), allProperties);
        KeyStore keyStore = this.loadAdditionalKeystoreWithServerCertificateOnly(allProperties);
        sslContextFactory.setKeyStore(keyStore);
        sslContextFactory.setTrustStore(keyStore);
        sslContextFactory.setCertAlias("secureKeyStoreAlias".toLowerCase());
        sslContextFactory.setKeyManagerPassword(keyStorePassword);
        String[] protocols = this.getListProperty(allProperties, BundleProperty.TLS_PROTOCOLS);
        String[] excludeProtocols = this.getListProperty(allProperties, BundleProperty.TLS_EXCLUDE_PROTOCOLS);
        String[] cipherSuites = this.getListProperty(allProperties, BundleProperty.TLS_CIPHER_SUITE);
        String[] excludeCipherSuites = this.getListProperty(allProperties, BundleProperty.TLS_EXCLUDE_CIPHER_SUITE);
        if (protocols != null) {
            sslContextFactory.setIncludeProtocols(protocols);
        }
        if (excludeProtocols != null) {
            sslContextFactory.setExcludeProtocols(excludeProtocols);
        }
        if (cipherSuites != null) {
            sslContextFactory.setIncludeCipherSuites(cipherSuites);
        }
        if (excludeCipherSuites != null) {
            sslContextFactory.setExcludeCipherSuites(excludeCipherSuites);
        }
        sslContextFactory.setRenegotiationAllowed(false);
        sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        sslContextFactory.setUseCipherSuitesOrder(true);
        sslContextFactory.addExcludeProtocols(new String[]{"TLSv1.3"});
        this.setClientCertificateAuthSettings(sslContextFactory);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(http);
        HTTP2ServerConnectionFactory http2Factory = new HTTP2ServerConnectionFactory(http);
        ALPNServerConnectionFactory alpn = this.createAlpnProtocolFactory(httpFactory);
        SslConnectionFactory ssl = new SslConnectionFactory((SslContextFactory)sslContextFactory, alpn.getProtocol());
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{ssl, alpn, http2Factory, httpFactory});
        sslConnector.setHost(listenAddress);
        sslConnector.setPort(listenPort);
        sslConnector.setIdleTimeout((long)BundleProxy.getIdleTimeout().intValue());
        return sslConnector;
    }

    @NotNull
    private KeyStore loadAdditionalKeystoreWithServerCertificateOnly(@NotNull Properties allProperties) {
        KeyStore keyStore;
        try {
            keyStore = AdditionalKeystore.loadAsKeystore((Properties)allProperties);
            for (String alias : Collections.list(keyStore.aliases())) {
                if (alias == null || alias.equalsIgnoreCase("secureKeyStoreAlias")) continue;
                keyStore.deleteEntry(alias);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading internal keystore", e);
        }
        return keyStore;
    }

    public void changeClientCertificateAuthSettings(boolean enableCertificateAuth, List<String> certPemEncoded) {
        for (Connector sc : this.getServer().getConnectors()) {
            for (ConnectionFactory f : sc.getConnectionFactories()) {
                if (!(f instanceof SslConnectionFactory)) continue;
                try {
                    SslConnectionFactory sslConnectionFactory = (SslConnectionFactory)f;
                    List certificates = certPemEncoded != null ? CertificateInfo.parseCertificates(certPemEncoded) : Collections.emptyList();
                    this.setClientCertificateAuthSettings(sslConnectionFactory.getSslContextFactory(), enableCertificateAuth, certificates);
                    sslConnectionFactory.getSslContextFactory().reload(sslContextFactory -> this.getLogger().debug(String.format("Start reloading SSLContextFactory [enableCertificateAuth=%s]", enableCertificateAuth)));
                    this.persistClientCertAuthSettings(enableCertificateAuth, certificates);
                }
                catch (Exception e) {
                    this.getLogger().error("Failed to reload SSLContextFactory", (Throwable)e);
                    throw new RuntimeException("Failed to reload SSLContextFactory", e);
                }
                return;
            }
        }
    }

    private void persistClientCertAuthSettings(boolean enableCertificateAuth, List<Certificate> certificates) {
        try {
            this.storeClientCertificateAuthEnabledFlag(enableCertificateAuth);
            if (enableCertificateAuth) {
                this.storeClientAuthCertificatesInAdditionalKeystore(certificates);
            }
        }
        catch (Exception e) {
            this.getLogger().debug("Failed to update client certificates in bundle keystore", (Throwable)e);
        }
    }

    private boolean isClientCertificatesAuthEnabled() {
        Properties properties = this.loadClientAuthProperties();
        return Boolean.valueOf(properties.getProperty(CLIENT_CERT_AUTH_ENABLED_PROPERTY));
    }

    private Properties loadClientAuthProperties() {
        File configFilePath = this.getClientAuthConfig();
        return Files.exists(configFilePath.toPath(), new LinkOption[0]) ? ConfiguratorUtils.loadPropertiesFile((File)configFilePath) : new Properties();
    }

    private void storeClientCertificateAuthEnabledFlag(boolean enabled) {
        Properties properties = this.loadClientAuthProperties();
        properties.setProperty(CLIENT_CERT_AUTH_ENABLED_PROPERTY, String.valueOf(enabled));
        ConfiguratorUtils.savePropertiesFile((File)this.getClientAuthConfig(), (Properties)properties);
    }

    @NotNull
    private File getClientAuthConfig() {
        File confDir = this.myBundleState.getEnvironment().getInternalServiceConfDir("bundleProcess");
        return confDir.toPath().resolve("client_auth.properties").toFile();
    }

    private void storeClientAuthCertificatesInAdditionalKeystore(@NotNull List<Certificate> certificates) throws KeyStoreException {
        Properties allProperties = this.getAllProperties();
        KeyStore keystore = this.loadAdditionalKeystore(allProperties);
        if (keystore == null) {
            return;
        }
        this.iterateThroughClientAuthCertificates(keystore, KeyStore::deleteEntry);
        this.addClientAuthCertificates(keystore, certificates);
        this.saveAdditionalKeystore(keystore, this.getAllProperties());
    }

    private void addClientAuthCertificates(@NotNull KeyStore keyStore, @NotNull List<Certificate> certificates) throws KeyStoreException {
        for (int i = 0; i < certificates.size(); ++i) {
            keyStore.setCertificateEntry(CLIENT_AUTH_CERT_NAME_PREFIX + i, certificates.get(i));
        }
    }

    private void iterateThroughClientAuthCertificates(@NotNull KeyStore k, @NotNull KeyStoreFunction<KeyStore, String> f) throws KeyStoreException {
        for (String alias : Collections.list(k.aliases())) {
            if (alias == null || !alias.toLowerCase().startsWith(CLIENT_AUTH_CERT_NAME_PREFIX)) continue;
            f.apply(k, alias);
        }
    }

    private KeyStore loadAdditionalKeystore(@NotNull Properties allProperties) {
        try {
            return AdditionalKeystore.loadAsKeystore((Properties)allProperties);
        }
        catch (Exception e) {
            String errorMessage = "Failed to load keystore from " + PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, BundleProperty.ADDITIONAL_KEYSTORE_PATH.getPrefixedName());
            this.getLogger().error(errorMessage, (Throwable)e);
            return null;
        }
    }

    private void saveAdditionalKeystore(KeyStore keyStore, Properties allProperties) {
        Path additionalKeystorePath = Paths.get(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, BundleProperty.ADDITIONAL_KEYSTORE_PATH.getPrefixedName()), new String[0]);
        String additionalKeystorePassword = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getPrefixedName());
        try {
            KeystoreUtil.saveKeyStore((KeyStore)keyStore, (Path)additionalKeystorePath, (String)additionalKeystorePassword);
        }
        catch (Exception e) {
            String errorMessage = "Failed to store keystore at " + additionalKeystorePath.toString();
            this.getLogger().error(errorMessage, (Throwable)e);
        }
    }

    private void setClientCertificateAuthSettings(SslContextFactory sslContextFactory) {
        boolean isClientCertificatesAuthEnabled = this.isClientCertificatesAuthEnabled();
        try {
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            if (isClientCertificatesAuthEnabled) {
                certificates.addAll(this.loadClientAuthCertificates());
                if (certificates.isEmpty()) {
                    this.getLogger().warn("No certificate used for client authentication was found. Client authentication has not been enabled");
                    return;
                }
            }
            this.setClientCertificateAuthSettings(sslContextFactory, isClientCertificatesAuthEnabled, certificates);
        }
        catch (Exception e) {
            this.getLogger().error(String.format("Failed to configure client auth settings [isEnabled=%s] on SSLContextFactory", isClientCertificatesAuthEnabled), (Throwable)e);
        }
    }

    @NotNull
    private List<Certificate> loadClientAuthCertificates() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keystore = AdditionalKeystore.loadAsKeystore((Properties)this.getAllProperties());
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        this.iterateThroughClientAuthCertificates(keystore, (k, alias) -> certificates.add(k.getCertificate((String)alias)));
        return certificates;
    }

    private void setClientCertificateAuthSettings(@NotNull SslContextFactory sslContextFactory, boolean enableCertificateAuth, @NotNull List<Certificate> certificates) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (enableCertificateAuth) {
            if (certificates.isEmpty()) {
                throw new IllegalArgumentException("At least one certificate should be passed if client certificate authentication is enabled");
            }
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            this.addClientAuthCertificates(keyStore, certificates);
            sslContextFactory.setTrustStore(keyStore);
        }
        sslContextFactory.setWantClientAuth(enableCertificateAuth);
        this.clientCertAuthSettings = new ClientCertAuthSettings(enableCertificateAuth, this.getEncodedClientAuthCertificates(certificates));
    }

    private List<String> getEncodedClientAuthCertificates(@NotNull List<Certificate> certificates) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (Certificate cert : certificates) {
                list.add(CertificateInfo.toPemFormat((byte[])cert.getEncoded()));
            }
            return Collections.unmodifiableList(list);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to convert certificates in string representation", (Throwable)e);
            return null;
        }
    }

    public ClientCertAuthSettings getClientCertificateAuthSettings() {
        return this.clientCertAuthSettings;
    }

    private ALPNServerConnectionFactory createAlpnProtocolFactory(HttpConnectionFactory httpConnectionFactory) {
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol(httpConnectionFactory.getProtocol());
        return alpn;
    }

    private Server createRedirectingServiceContainer(@NotNull String installationListenAddress, int installationPort, @NotNull BundleProperties bundleProperties) {
        Server server = super.createJettyServer(installationPort, installationListenAddress, this.getAllProperties());
        ContextHandlerCollection contextHandler = new ContextHandlerCollection();
        this.addFilterForRedirectionToBundleServletContainer((HandlerCollection)contextHandler, bundleProperties, false);
        HandlerCollection rootHandler = new HandlerCollection();
        rootHandler.addHandler((Handler)contextHandler);
        server.setHandler((Handler)rootHandler);
        try {
            server.start();
        }
        catch (Exception e) {
            this.getLogger().debug(String.format("Error while starting server on {%s:%s}", installationListenAddress, installationPort), (Throwable)e);
        }
        return server;
    }

    private void addFilterForRedirectionToBundleServletContainer(@NotNull HandlerCollection handlerCollection, @NotNull BundleProperties bundleProperties) {
        this.addFilterForRedirectionToBundleServletContainer(handlerCollection, bundleProperties, true);
    }

    private void addFilterForRedirectionToBundleServletContainer(@NotNull HandlerCollection handlerCollection, @NotNull BundleProperties bundleProperties, boolean preventRedirectionFromBundleBaseContext) {
        FilterHolder filterHolder = new FilterHolder(InstallerRedirectingFilter.class);
        filterHolder.setInitParameter("bundleBaseUrl", bundleProperties.getBaseUrl());
        filterHolder.setInitParameter("bundleBaseContext", bundleProperties.getContext());
        filterHolder.setInitParameter("bundleListenPort", Integer.toString(bundleProperties.getListenPort()));
        filterHolder.setInitParameter("bundleListenAddress", bundleProperties.getListenAddress());
        filterHolder.setInitParameter("bundleSecureMode", bundleProperties.getSecureMode());
        filterHolder.setInitParameter("preventRedirectionFromBundleBaseContext", String.valueOf(preventRedirectionFromBundleBaseContext));
        ServletContextHandler ctx = new ServletContextHandler();
        ctx.setContextPath("/");
        ctx.addFilter(filterHolder, "*", null);
        handlerCollection.addHandler((Handler)ctx);
    }

    private void addBundleBaseContextStartupHandler(@NotNull Properties allProperties, final @NotNull BundleState bundleState, @NotNull BundleEnvironment environment, @NotNull HandlerCollection handlerCollection) {
        final Map<String, ServiceDescriptor> bundledServicesContexts = bundleState.getServices().getServiceDescriptorsMap();
        final String bundleBaseContext = bundleState.getProperties().getContext();
        ServletContextHandler bundleBaseContextHandler = new ServletContextHandler(){

            public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (baseRequest.isHandled()) {
                    return;
                }
                if (request.getServletPath().equals("/bundle/error_pages")) {
                    super.doHandle(target, baseRequest, request, response);
                }
                if (bundleState.getServices().isBundleStarting() && !bundleState.getServices().isBundleShutdownInProgress()) {
                    String fullServletPathFromRequest = UrlUtil.combineContexts((String)request.getContextPath(), (String)request.getServletPath());
                    String rootContextServiceId = null;
                    String requestedServiceId = null;
                    for (ServiceDescriptor service : bundledServicesContexts.values()) {
                        if (service.isBundleServiceContainer()) continue;
                        String serviceContext = bundleState.getProperties().getFullServiceUrlPath(service);
                        if (serviceContext.equals(bundleBaseContext)) {
                            rootContextServiceId = service.getId();
                            continue;
                        }
                        if (!fullServletPathFromRequest.equals(serviceContext) && !fullServletPathFromRequest.startsWith(UrlUtil.ensureEndsWithSlash((String)serviceContext))) continue;
                        requestedServiceId = service.getId();
                        break;
                    }
                    if (requestedServiceId == null) {
                        requestedServiceId = rootContextServiceId;
                    }
                    if (requestedServiceId != null && !Status.RUNNING.name().equalsIgnoreCase(bundleState.getServices().getServiceStatus(requestedServiceId).getStatus())) {
                        super.doHandle(target, baseRequest, request, response);
                    }
                }
            }
        };
        bundleBaseContextHandler.setContextPath(this.myBundleState.getProperties().getContext());
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(404, UrlUtil.combineContexts((String)"/bundle/error_pages", (String)"/404.html"));
        bundleBaseContextHandler.setErrorHandler((ErrorHandler)errorHandler);
        ServletHolder errorPageServicesHolder = new ServletHolder(ErrorPagesServlet.class);
        this.prepareErrorPagesServletInitParameters(allProperties, errorPageServicesHolder);
        bundleBaseContextHandler.setResourceBase(environment.getBundleHomeInternal().resolve("error_pages").toString());
        bundleBaseContextHandler.addServlet(errorPageServicesHolder, "/bundle/error_pages/*");
        this.myBundleBaseStartupContextHandler = bundleBaseContextHandler;
        handlerCollection.addHandler((Handler)this.myBundleBaseStartupContextHandler);
        bundleState.addStartFinishedListener(new BaseContextStartupDestroyer());
    }

    private void prepareErrorPagesServletInitParameters(@NotNull Properties allProperties, @NotNull ServletHolder errorPageServicesHolder) {
        errorPageServicesHolder.setInitParameter("product.presentation.name", PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, "bundle.product.presentation_name"));
        errorPageServicesHolder.setInitParameter("product.short.name", PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, "bundle.product.name"));
        errorPageServicesHolder.setInitParameter("bundle.backend.context", PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, "bundleBackend", "context"));
        this.setInitParameterIfNotNull(errorPageServicesHolder, "product.whats.new.link", this.myBundleState.getBuildProperties().getBundleProductWhatsNewLink());
    }

    private void setInitParameterIfNotNull(@NotNull ServletHolder errorPageServicesHolder, @NotNull String initParamName, String value) {
        if (value != null) {
            errorPageServicesHolder.setInitParameter(initParamName, value);
        }
    }

    private void addDefaultContextRedirectionFilter(@NotNull ServletContextHandler ctx, String contextPath) {
        FilterHolder filterHolder = new FilterHolder(DefaultContextRedirectionFilter.class);
        filterHolder.setInitParameter("redirectAfterStartUrl", contextPath);
        ctx.addFilter(filterHolder, "", null);
    }

    @Nullable
    private String[] getListProperty(@NotNull Properties allProperties, BundleProperty bundleProperty) {
        String tlsCipherSuite = allProperties.getProperty(bundleProperty.getPrefixedName());
        String[] cipherSuites = !StringUtils.isEmpty((CharSequence)tlsCipherSuite) ? tlsCipherSuite.replace(" ", "").split(",") : null;
        return cipherSuites;
    }

    private class VirtualHostsFallbackHandler
    extends ServletContextHandler {
        VirtualHostsFallbackHandler() {
            this.setContextPath(BundleProxy.this.myBundleState.getProperties().getContext());
            this.setDisplayName("Error handler");
            this.setErrorHandler((ErrorHandler)new ErrorPageErrorHandler());
        }

        public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.sendError(403, "Passed value of header \"Host\" is not allowed. Please contact your server administrator.");
        }
    }

    @FunctionalInterface
    static interface KeyStoreFunction<One, Two> {
        public void apply(One var1, Two var2) throws KeyStoreException;
    }

    public class AddProxyOnServiceStartedListener
    extends OnePerClassListener<ServiceStartedEvent> {
        @Override
        public void onSuccess(@NotNull ServiceStartedEvent event) {
            ServletContextHandler contextHandler;
            String serviceId;
            Properties allProperties = BundleProxy.this.getAllProperties();
            Collection allProxiedServices = BundleProxy.this.getAllProxiedServices(allProperties);
            if (allProxiedServices.contains(serviceId = event.getServiceDescriptor().getId()) && (contextHandler = BundleProxy.this.addProxyRule(serviceId, allProperties)) != null) {
                try {
                    BundleProxy.this.startContextInContainer(contextHandler, serviceId);
                }
                catch (Exception e) {
                    BundleProxy.this.getLogger().debug("Failed to start proxying servlet context for service " + serviceId);
                }
            }
        }

        @Override
        public void onFailure(@NotNull ServiceStartedEvent event, @NotNull Throwable t) {
        }
    }

    private class BaseContextStartupDestroyer
    extends OnePerClassListener<StartFinishedEvent> {
        private BaseContextStartupDestroyer() {
        }

        @Override
        public void onSuccess(@NotNull StartFinishedEvent event) {
            try {
                BundleProxy.this.stopServletContext(BundleProxy.this.myBundleBaseStartupContextHandler, null);
            }
            catch (Exception e) {
                BundleProxy.this.getLogger().debug("Failed to stop bundle startup servlet context", (Throwable)e);
            }
        }

        @Override
        public void onFailure(@NotNull StartFinishedEvent event, @NotNull Throwable t) {
        }
    }

    private static class TrustAllClientsSslContextFactory
    extends SslContextFactory {
        private TrustAllClientsSslContextFactory() {
        }

        protected TrustManager[] getTrustManagers(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
            TrustManager[] trustManagers = super.getTrustManagers(trustStore, crls);
            if (trustManagers == null) {
                return null;
            }
            ArrayList<X509TrustManager> x509TrustManagers = new ArrayList<X509TrustManager>();
            for (TrustManager trustManager : trustManagers) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                x509TrustManagers.add((X509TrustManager)trustManager);
            }
            if (x509TrustManagers.isEmpty()) {
                return trustManagers;
            }
            return new TrustManager[]{new CompositeX509TrustAllClientsManager(x509TrustManagers)};
        }

        private static class CompositeX509TrustAllClientsManager
        extends X509ExtendedTrustManager {
            @NotNull
            private final List<X509TrustManager> x509TrustManagers;

            CompositeX509TrustAllClientsManager(@NotNull List<X509TrustManager> x509TrustManagers) {
                this.x509TrustManagers = x509TrustManagers;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
                for (X509TrustManager trustManager : this.x509TrustManagers) {
                    try {
                        if (trustManager instanceof X509ExtendedTrustManager) {
                            ((X509ExtendedTrustManager)trustManager).checkServerTrusted(x509Certificates, s, socket);
                        } else {
                            trustManager.checkServerTrusted(x509Certificates, s);
                        }
                        return;
                    }
                    catch (CertificateException e) {
                        if (this.x509TrustManagers.size() != 1) continue;
                        throw e;
                    }
                }
                throw new CertificateException("Cannot build trusted certificates chain");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
                for (X509TrustManager trustManager : this.x509TrustManagers) {
                    try {
                        if (trustManager instanceof X509ExtendedTrustManager) {
                            ((X509ExtendedTrustManager)trustManager).checkServerTrusted(x509Certificates, s, sslEngine);
                        } else {
                            trustManager.checkServerTrusted(x509Certificates, s);
                        }
                        return;
                    }
                    catch (CertificateException e) {
                        if (this.x509TrustManagers.size() != 1) continue;
                        throw e;
                    }
                }
                throw new CertificateException("Cannot build trusted certificates chain");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                for (X509TrustManager trustManager : this.x509TrustManagers) {
                    try {
                        trustManager.checkServerTrusted(x509Certificates, s);
                        return;
                    }
                    catch (CertificateException e) {
                        if (this.x509TrustManagers.size() != 1) continue;
                        throw e;
                    }
                }
                throw new CertificateException("Cannot build trusted certificates chain");
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
                for (X509TrustManager trustManager : this.x509TrustManagers) {
                    certificates.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
                }
                return certificates.isEmpty() ? null : certificates.toArray(new X509Certificate[0]);
            }
        }
    }

    public static class InstallerRedirectingFilter
    implements Filter {
        static final String BUNDLE_BASE_URL_PARAMETER = "bundleBaseUrl";
        static final String BUNDLE_BASE_CONTEXT_PARAMETER = "bundleBaseContext";
        static final String BUNDLE_BASE_LISTEN_PORT_PARAMETER = "bundleListenPort";
        static final String BUNDLE_BASE_LISTEN_ADDRESS_PARAMETER = "bundleListenAddress";
        static final String BUNDLE_SECURE_MODE_PARAMETER = "bundleSecureMode";
        static final String PREVENT_REDIRECTION_FROM_BUNDLE_BASE_CONTEXT_PARAMETER = "preventRedirectionFromBundleBaseContext";
        private String bundleBaseUrl;
        private String bundleBaseContext;
        private int bundleListenPort;
        private String bundleSecureMode;
        private String bundleListenAddress;
        private boolean preventRedirectionFromBundleBaseContext;

        public void init(FilterConfig filterConfig) {
            this.bundleBaseUrl = filterConfig.getInitParameter(BUNDLE_BASE_URL_PARAMETER);
            this.bundleBaseContext = filterConfig.getInitParameter(BUNDLE_BASE_CONTEXT_PARAMETER);
            this.bundleListenPort = Integer.parseInt(filterConfig.getInitParameter(BUNDLE_BASE_LISTEN_PORT_PARAMETER));
            this.bundleListenAddress = filterConfig.getInitParameter(BUNDLE_BASE_LISTEN_ADDRESS_PARAMETER);
            this.bundleSecureMode = filterConfig.getInitParameter(BUNDLE_SECURE_MODE_PARAMETER);
            this.preventRedirectionFromBundleBaseContext = Boolean.valueOf(filterConfig.getInitParameter(PREVENT_REDIRECTION_FROM_BUNDLE_BASE_CONTEXT_PARAMETER));
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            String redirectUri;
            String requestHost = servletRequest.getServerName();
            String queryString = ((HttpServletRequest)servletRequest).getQueryString();
            String requestURI = ((HttpServletRequest)servletRequest).getRequestURI();
            String requestPathAndQuery = (requestURI != null ? requestURI : "") + (queryString != null ? "?" + queryString : "");
            if (this.preventRedirectionFromBundleBaseContext && (this.bundleBaseContext.isEmpty() || this.bundleBaseContext.equals("/") || requestURI != null && requestURI.startsWith(this.bundleBaseContext))) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            String bundleBaseUrlAsString = this.bundleBaseUrl;
            URL baseUrl = new URL(bundleBaseUrlAsString);
            if (requestHost.equalsIgnoreCase(baseUrl.getHost()) || this.bundleSecureMode != null && !SecureMode.DISABLE.getName().equals(this.bundleSecureMode)) {
                redirectUri = UrlUtil.combineUrls((String)bundleBaseUrlAsString, (String)requestPathAndQuery);
            } else {
                String redirectToHost = "0.0.0.0".equals(this.bundleListenAddress) ? requestHost : this.bundleListenAddress;
                redirectUri = UrlUtil.combineUrls((String)UrlUtil.constructUrl((String)servletRequest.getScheme(), (String)redirectToHost, (int)this.bundleListenPort, (String)this.bundleBaseContext), (String)requestPathAndQuery);
            }
            ((HttpServletResponse)servletResponse).sendRedirect(redirectUri);
        }

        public void destroy() {
        }
    }
}

