/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.proxy.jetty;

import com.jetbrains.service.util.UrlUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.ring.servlet.util.ServletUtil;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ErrorPagesServlet
extends HttpServlet {
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Charset UTF_CHARSET = Charset.forName("UTF-8");
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    static final String PRODUCT_PRESENTATION_NAME_PARAMETER = "product.presentation.name";
    static final String PRODUCT_SHORT_NAME_PARAMETER = "product.short.name";
    static final String BUNDLE_BACKEND_SERVICE_CONTEXT_PARAMETER = "bundle.backend.context";
    static final String PRODUCT_WHATS_NEW_LINK = "product.whats.new.link";
    private String logoPath;

    public void init() throws ServletException {
        super.init();
        this.logoPath = this.resolveLogoPath();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (UrlUtil.ensureStartsWithoutSlash((String)req.getPathInfo()).equals("404.html")) {
            if (this.shouldShowStubPage(req)) {
                this.respondWithPage(req, resp, "/503-starting.html", 503);
                return;
            }
            this.respondWithDefaultErrorPage(req, resp, 404);
            return;
        }
        String path = req.getPathInfo();
        this.respondWithPage(req, resp, path);
    }

    private boolean shouldShowStubPage(HttpServletRequest request) throws IOException {
        String forwardedRequestUri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (forwardedRequestUri == null) {
            return false;
        }
        return !forwardedRequestUri.startsWith(ServletUtil.getServletPath((HttpServletRequest)request));
    }

    private void respondWithPage(HttpServletRequest request, HttpServletResponse resp, String path) throws IOException {
        this.respondWithPage(request, resp, path, 200);
    }

    private void respondWithPage(HttpServletRequest request, HttpServletResponse resp, String path, int responseStatus) throws IOException {
        URL url;
        if (ServletUtil.isForbidden((String)path)) {
            resp.sendError(403);
            return;
        }
        if (path.endsWith("/") || !this.isFile(path)) {
            resp.sendError(404);
            return;
        }
        try {
            url = this.getServletContext().getResource(path);
        }
        catch (MalformedURLException e) {
            resp.sendError(400);
            return;
        }
        if (url == null) {
            resp.sendError(404);
            return;
        }
        File f = this.getFile(path, request.getServletContext());
        if (f != null) {
            if (!f.isFile()) {
                resp.sendError(403);
                return;
            }
            String mimeType = this.getMimeType(path, request.getServletContext());
            if (f.getName().endsWith(".html") || f.getName().endsWith(".js")) {
                byte[] content = this.loadFileAndPreprocess(url, request).getBytes(UTF_CHARSET);
                this.setHeaders(resp, mimeType, content.length, responseStatus);
                if (!request.getMethod().equalsIgnoreCase("HEAD")) {
                    this.writeResponse(resp, content);
                }
            } else {
                this.setHeaders(resp, mimeType, (int)f.length(), responseStatus);
                if (!request.getMethod().equalsIgnoreCase("HEAD")) {
                    this.respondSimpleResourceGet(url, resp);
                }
            }
        } else {
            resp.sendError(404);
            return;
        }
    }

    private void writeResponse(HttpServletResponse resp, byte[] content) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream((OutputStream)resp.getOutputStream(), 4096);){
            ((OutputStream)out).write(content);
        }
    }

    private String loadFileAndPreprocess(URL url, HttpServletRequest req) throws IOException {
        String indexPageContent;
        try (StringWriter writer = new StringWriter(4096);
             InputStreamReader iReader = new InputStreamReader(url.openStream(), UTF_CHARSET);){
            ErrorPagesServlet.copy(writer, iReader);
            indexPageContent = writer.toString();
        }
        String productPresentationName = this.getInitParameter(PRODUCT_PRESENTATION_NAME_PARAMETER);
        String productShortName = this.getInitParameter(PRODUCT_SHORT_NAME_PARAMETER);
        String bundleBackendContext = this.getInitParameter(BUNDLE_BACKEND_SERVICE_CONTEXT_PARAMETER);
        String productWhatsNewPageLink = this.getInitParameter(PRODUCT_WHATS_NEW_LINK);
        indexPageContent = indexPageContent.replace("@@error.pages.context@@", this.replaceBreakingSymbols(ServletUtil.getServletPath((HttpServletRequest)req)));
        indexPageContent = indexPageContent.replace("@@bundle.backend.context@@", this.replaceBreakingSymbols(bundleBackendContext));
        indexPageContent = indexPageContent.replace("@@product.presentation.name@@", this.replaceBreakingSymbols(productPresentationName));
        indexPageContent = indexPageContent.replace("@@product.short.name@@", this.replaceBreakingSymbols(productShortName));
        indexPageContent = indexPageContent.replace("@@logo.path@@", this.logoPath);
        indexPageContent = indexPageContent.replace("@@whats.new.page@@", this.replaceBreakingSymbols(productWhatsNewPageLink != null ? productWhatsNewPageLink : "undefined"));
        return indexPageContent;
    }

    private static void copy(Writer writer, Reader reader) throws IOException {
        int n;
        char[] buffer = new char[4096];
        while (-1 != (n = reader.read(buffer))) {
            writer.write(buffer, 0, n);
        }
    }

    private void respondSimpleResourceGet(URL url, HttpServletResponse resp) throws IOException {
        try (ServletOutputStream out = resp.getOutputStream();
             InputStream is = url.openStream();){
            ErrorPagesServlet.copy((OutputStream)out, is);
        }
    }

    private static void copy(OutputStream os, InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = is.read(buffer))) {
            os.write(buffer, 0, n);
        }
    }

    private boolean isFile(String path) {
        int dotIndex = path.lastIndexOf(".");
        if (dotIndex <= 0) {
            return false;
        }
        int p = path.lastIndexOf("/");
        return dotIndex > p;
    }

    private File getFile(String path, ServletContext context) {
        String realpath = context.getRealPath(path);
        return realpath != null ? new File(realpath) : null;
    }

    private String getMimeType(String path, ServletContext context) {
        String mimeType = context.getMimeType(path);
        return mimeType == null ? DEFAULT_MIME_TYPE : mimeType;
    }

    private void setHeaders(HttpServletResponse resp, String mimeType, int contentLength, int responseStatus) throws IOException {
        resp.setStatus(responseStatus);
        resp.setContentType(mimeType);
        resp.setHeader(CACHE_CONTROL_HEADER, "must-revalidate, no-cache, no-store");
        if (contentLength >= 0) {
            resp.setContentLength(contentLength);
        }
    }

    private void respondWithDefaultErrorPage(HttpServletRequest request, HttpServletResponse resp, int status) throws IOException {
        String message = HttpStatus.getMessage((int)status);
        resp.setStatus(status);
        resp.setHeader(CACHE_CONTROL_HEADER, "must-revalidate,no-cache,no-store");
        resp.setContentType(MimeTypes.Type.TEXT_HTML_8859_1.toString());
        try (ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(2048);){
            String uri;
            if (message != null) {
                message = this.replaceBreakingSymbols(message);
            }
            if ((uri = (String)request.getAttribute("javax.servlet.forward.request_uri")) != null) {
                uri = this.replaceBreakingSymbols(uri);
            } else {
                uri = request.getRequestURI();
                if (uri != null) {
                    uri = this.replaceBreakingSymbols(uri);
                }
            }
            writer.write("<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=ISO-8859-1\"/>\n");
            writer.write("<title>Error ");
            writer.write(Integer.toString(status));
            writer.write(' ');
            if (message == null) {
                writer.write(message);
            }
            writer.write("</title>\n</head>\n<body>\n<h2>HTTP ERROR: ");
            writer.write(Integer.toString(status));
            writer.write("</h2>\n<p>Problem accessing ");
            writer.write(uri);
            writer.write(". Reason:\n<pre>    ");
            writer.write(message);
            writer.write("</pre>");
            writer.write("</p>\n<hr /><i><small>Powered by Jetty://</small></i>");
            writer.write("\n</body>\n</html>\n");
            writer.flush();
            resp.setContentLength(writer.size());
            try (ServletOutputStream outputStream = resp.getOutputStream();){
                writer.writeTo((OutputStream)outputStream);
                writer.destroy();
            }
        }
    }

    @NotNull
    private String replaceBreakingSymbols(String uri) {
        uri = StringUtil.replace((String)uri, (String)"&", (String)"&amp;");
        uri = StringUtil.replace((String)uri, (String)"<", (String)"&lt;");
        uri = StringUtil.replace((String)uri, (String)">", (String)"&gt;");
        return uri;
    }

    @NotNull
    private String resolveLogoPath() throws ServletException {
        String shortProductNameLowerCased = this.getInitParameter(PRODUCT_SHORT_NAME_PARAMETER).toLowerCase();
        String logoPath = ErrorPagesServlet.getProductLogoPath(this.getServletConfig().getServletContext(), shortProductNameLowerCased);
        if (logoPath == null && (logoPath = ErrorPagesServlet.getProductLogoPath(this.getServletConfig().getServletContext(), "jetbrains")) == null) {
            throw new ServletException(String.format("Product logos were not found for: [%s, %s]", shortProductNameLowerCased, "jetbrains"));
        }
        return logoPath;
    }

    private static String getProductLogoPath(ServletContext servletContext, String shortProductName) throws ServletException {
        String logoPath = String.format("/logos/%s/%s.svg", shortProductName, shortProductName);
        try {
            URL url = servletContext.getResource(logoPath);
            if (url != null) {
                return UrlUtil.ensureStartsWithoutSlash((String)logoPath);
            }
        }
        catch (MalformedURLException e) {
            throw new ServletException("Unexpected: Invalid path: [" + logoPath + "]");
        }
        return null;
    }
}

