/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.Services;
import com.jetbrains.bundle.api.internal.awc.ext.impl.AdminConsoleExtensionImpl;
import com.jetbrains.bundle.api.internal.awc.ext.impl.DelegatingAdminConsoleExtension;
import com.jetbrains.bundle.api.internal.awc.ext.model.KeyStoreSettings;
import com.jetbrains.bundle.api.internal.services.ServicesInformationProvider;
import com.jetbrains.bundle.hub_client.util.BundleHubClient;
import com.jetbrains.bundle.services.ServicesContainer;
import com.jetbrains.bundle.services.impl.BundledInternalService;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.nio.file.Paths;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class AdminConsoleService
extends BundledInternalService {
    private static final String AWC_TOKEN_PROPERTY_NAME = "token";
    @NotNull
    private final BundleState myBundleState;
    @NotNull
    private final ServicesInformationProvider myServicesInformationProvider;
    @NotNull
    private final ServiceDescriptor myServiceForRedirectionAfterStart;

    public AdminConsoleService(@NotNull ServiceDescriptor serviceDescriptor, String serviceStatusURL, @NotNull BundleEnvironment environment, @NotNull BundleState bundleState, @NotNull ServicesContainer hostingServletContainer, @NotNull ServicesInformationProvider servicesInformationProvider, @NotNull ServiceDescriptor serviceForRedirectionAfterStart) {
        super(serviceDescriptor, serviceStatusURL, environment, hostingServletContainer, bundleState.getContextHolder());
        this.myBundleState = bundleState;
        this.myServicesInformationProvider = servicesInformationProvider;
        this.myServiceForRedirectionAfterStart = serviceForRedirectionAfterStart;
    }

    @Override
    public void doStart() throws StartupException {
        Properties properties = this.getProperties();
        File dataDir = Paths.get(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, ServiceProperties.DATA_DIR_PROPERTY), new String[0]).toFile();
        File awcStorageFile = AdminConsoleService.getAwcTokenStorage(dataDir);
        String publicHubUrl = null;
        String internalHubUrl = null;
        BundleHubClient bundleHubClient = BundleHubClient.getBundleHubClient((Properties)properties);
        if (bundleHubClient != null) {
            if (bundleHubClient.isInternalHub()) {
                publicHubUrl = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, "hub", "base-url");
                internalHubUrl = bundleHubClient.getHubUrl();
            } else {
                internalHubUrl = publicHubUrl = bundleHubClient.getHubUrl();
            }
        }
        boolean doesHubServiceExistsInBundle = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, "hub", "id") != null || Services.getBundleServices(this.myBundleState, false).keySet().contains("hub");
        String keyStorePassword = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getPrefixedName());
        KeyStoreSettings keyStoreSettings = new KeyStoreSettings(Paths.get(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, BundleProperty.ADDITIONAL_KEYSTORE_PATH.getPrefixedName()), new String[0]).toFile(), keyStorePassword, keyStorePassword);
        AdminConsoleExtensionImpl adminConsoleExtension = new AdminConsoleExtensionImpl(dataDir, bundleHubClient, publicHubUrl, internalHubUrl, this.myBundleState, this.getAwcToken(dataDir), awcStorageFile, properties, doesHubServiceExistsInBundle, keyStoreSettings, this.myServicesInformationProvider, UrlUtil.ensureEndsWithSlash((String)this.myBundleState.getProperties().getServiceUrl(this.myServiceForRedirectionAfterStart)));
        DelegatingAdminConsoleExtension.setProvider(adminConsoleExtension);
        super.doStart();
    }

    @NotNull
    private String getAwcToken(@NotNull File dataDir) {
        return AdminConsoleService.getToken(this.regenerateTokenIfNeeded(AdminConsoleService.getAwcTokenStorage(dataDir)));
    }

    @NotNull
    private Properties regenerateTokenIfNeeded(@NotNull File awcStorageFile) {
        Properties properties = awcStorageFile.exists() ? ConfiguratorUtils.loadPropertiesFile((File)awcStorageFile) : new Properties();
        String oldToken = AdminConsoleService.getToken(properties);
        if (oldToken == null || !this.myBundleState.getContextHolder().isRestart()) {
            AdminConsoleService.createAndStoreNewToken(awcStorageFile, properties);
        }
        return properties;
    }

    @NotNull
    private static File getAwcTokenStorage(@NotNull File dataDir) {
        return new File(dataDir, "awcToken.properties");
    }

    private static String getToken(@NotNull Properties properties) {
        return properties.getProperty(AWC_TOKEN_PROPERTY_NAME);
    }

    @NotNull
    private static String createAndStoreNewToken(@NotNull File awcStorageFile, @NotNull Properties properties) {
        String awcToken = ConfiguratorUtils.randomAlphanumeric((int)200);
        properties.setProperty(AWC_TOKEN_PROPERTY_NAME, awcToken);
        ConfiguratorUtils.savePropertiesFile((File)awcStorageFile, (Properties)properties, (String)"Property token contains a key that could be used to login into administration console");
        return awcToken;
    }
}

