/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl;

import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.api.internal.backend.impl.BundleFacadeDelegate;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.services.ServicesContainer;
import com.jetbrains.bundle.services.impl.BundledService;
import com.jetbrains.service.util.contract.BundleContractViolationException;
import com.jetbrains.service.util.contract.ServiceConfLocationResolver;
import com.jetbrains.service.util.logging.JavaUtilLoggingToSlf4jBridge;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BundledExternalService
extends BundledService {
    BundledExternalService(@NotNull ServiceDescriptor serviceDescriptor, String serviceStatusURL, @NotNull ServicesContainer hostingContainer, @NotNull ApplicationContextHolder applicationContextHolder) {
        super(serviceDescriptor, serviceStatusURL, hostingContainer, applicationContextHolder);
    }

    @Override
    protected void afterStart() {
        super.afterStart();
        JavaUtilLoggingToSlf4jBridge.install();
    }

    @Override
    @NotNull
    protected Map<String, Object> getAfterStartCallbackParameters() throws IOException {
        Map<String, Object> params = super.getAfterStartCallbackParameters();
        params.put("jetbrains.bundle.service", BundleFacadeDelegate.getBundleFacade());
        params.put("jetbrains.bundle.properties.service", BundleFacadeDelegate.getBundleFacade());
        return params;
    }

    @Override
    @Nullable
    ClassLoader getParentClassLoaderForAfterStartCallback() {
        return this.getWebAppClassloader();
    }

    @Override
    @NotNull
    public File getServiceConfLocation() {
        try {
            return ServiceConfLocationResolver.resolve((File)this.getServiceHome().toFile());
        }
        catch (BundleContractViolationException e) {
            throw new RuntimeException("Can not resolve service conf location", e);
        }
    }
}

