/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util;

import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserUtil.class);
    private static Pattern LINK_PATTERN = Pattern.compile("Link: (.*)");

    public static boolean tryOpenInBrowser(String url) {
        if (!GraphicsEnvironment.isHeadless() && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                LOG.debug("Opening url " + url + " in browser");
                Desktop.getDesktop().browse(URI.create(url));
                return true;
            }
            catch (IOException e) {
                LOG.debug("Unable to open url in browser with help of Desktop.getDesktop(): " + e.getMessage());
                return BrowserUtil.launchBrowser(url);
            }
        }
        return BrowserUtil.launchBrowser(url);
    }

    public static boolean launchBrowser(String url) {
        return BrowserUtil.launchBrowser(url, null);
    }

    public static boolean launchBrowser(String url, String preferredBrowser) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Runtime.getRuntime().exec(new String[]{"open", url});
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String selectedBrowser = null;
                if (Runtime.getRuntime().exec(new String[]{"which", "update-alternatives"}).waitFor() == 0) {
                    LOG.debug("Has update-alternatives command");
                    Process process = Runtime.getRuntime().exec(new String[]{"update-alternatives", "--query", "x-www-browser"});
                    try (InputStream inputStream = process.getInputStream();){
                        Scanner s = new Scanner(inputStream);
                        while (s.hasNextLine()) {
                            String line = s.nextLine();
                            Matcher matcher = LINK_PATTERN.matcher(line);
                            if (!matcher.matches()) continue;
                            selectedBrowser = matcher.group(1);
                            LOG.debug("update-alternatives points to {} for x-www-browser ", (Object)selectedBrowser);
                            break;
                        }
                    }
                }
                if (selectedBrowser == null) {
                    String[] browsers;
                    for (String browser : browsers = new String[]{preferredBrowser, "google-chrome", "firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"}) {
                        if (browser == null || Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() != 0) continue;
                        selectedBrowser = browser;
                        break;
                    }
                }
                if (selectedBrowser == null) {
                    throw new Exception("Couldn't find web browser");
                }
                Runtime.getRuntime().exec(new String[]{selectedBrowser, url});
            }
            return true;
        }
        catch (Exception e) {
            LOG.debug("Unable to open url in browser: {}", (Object)e.getMessage());
            return false;
        }
    }
}

