/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TopoSort {
    public static <T> List<T> sort(Collection<T> items, Map<T, Collection<T>> predecessors) {
        ArrayList result = new ArrayList();
        HashSet visited = new HashSet();
        for (T item : items) {
            TopoSort.visit(item, visited, result, predecessors);
        }
        return result;
    }

    private static <T> void visit(T node, Set<T> visited, List<T> result, Map<T, Collection<T>> predecessors) {
        if (visited.contains(node)) {
            if (result.contains(node)) {
                return;
            }
            throw new IllegalArgumentException("Cycle detected");
        }
        visited.add(node);
        Collection<T> p = predecessors.get(node);
        if (p != null) {
            for (T t : p) {
                TopoSort.visit(t, visited, result, predecessors);
            }
        }
        result.add(node);
    }
}

