/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.persistent.AbstractPersistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.LongMapEntry;
import jetbrains.exodus.core.dataStructures.persistent.Persistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import jetbrains.exodus.core.dataStructures.persistent.RootHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentLong23TreeMap<V>
implements PersistentLongMap<V> {
    private final Persistent23Tree<PersistentLongMap.Entry<V>> set;

    public PersistentLong23TreeMap() {
        this(null);
    }

    private PersistentLong23TreeMap(@Nullable AbstractPersistent23Tree.RootNode<PersistentLongMap.Entry<V>> root) {
        this.set = new Persistent23Tree<PersistentLongMap.Entry<V>>(root);
    }

    @Override
    public PersistentLongMap.ImmutableMap<V> beginRead() {
        return new ImmutableMap<V>(this.set.getRoot());
    }

    @Override
    public PersistentLong23TreeMap<V> getClone() {
        return new PersistentLong23TreeMap<V>(this.set.getRoot());
    }

    @Override
    public PersistentLongMap.MutableMap<V> beginWrite() {
        return new MutableMap<V>(this.set);
    }

    @Deprecated
    public boolean endWrite(MutableMap<V> tree) {
        return this.set.endWrite(tree);
    }

    protected static class MutableMap<V>
    extends Persistent23Tree.MutableTree<PersistentLongMap.Entry<V>>
    implements PersistentLongMap.MutableMap<V>,
    RootHolder {
        MutableMap(Persistent23Tree<PersistentLongMap.Entry<V>> set) {
            super(set);
        }

        @Override
        public V get(long key) {
            Object root = this.getRoot();
            if (root == null) {
                return null;
            }
            PersistentLongMap.Entry entry = (PersistentLongMap.Entry)root.getByWeight(key);
            return entry == null ? null : (V)entry.getValue();
        }

        @Override
        public boolean containsKey(long key) {
            return this.get(key) != null;
        }

        @Override
        public Iterator<PersistentLongMap.Entry<V>> tailEntryIterator(long staringKey) {
            return this.tailIterator(new LongMapEntry(staringKey));
        }

        @Override
        public Iterator<PersistentLongMap.Entry<V>> tailReverseEntryIterator(long staringKey) {
            return this.tailReverseIterator(new LongMapEntry(staringKey));
        }

        @Override
        public void put(long key, @NotNull V value) {
            this.add(new LongMapEntry<V>(key, value));
        }

        @Override
        public V remove(long key) {
            Object root = this.getRoot();
            if (root == null) {
                return null;
            }
            Pair removeResult = root.remove(new LongMapEntry(key), true);
            if (removeResult == null) {
                return null;
            }
            AbstractPersistent23Tree.Node res = removeResult.getFirst();
            if (res instanceof AbstractPersistent23Tree.RemovedNode) {
                res = res.getFirstChild();
            }
            root = res == null ? null : res.asRoot(root.getSize() - 1);
            this.setRoot(root);
            return ((PersistentLongMap.Entry)removeResult.getSecond()).getValue();
        }

        @Override
        public void clear() {
            this.setRoot(null);
        }
    }

    protected static class ImmutableMap<V>
    extends Persistent23Tree.ImmutableTree<PersistentLongMap.Entry<V>>
    implements PersistentLongMap.ImmutableMap<V> {
        ImmutableMap(AbstractPersistent23Tree.RootNode<PersistentLongMap.Entry<V>> root) {
            super(root);
        }

        @Override
        public V get(long key) {
            AbstractPersistent23Tree.RootNode root = this.getRoot();
            if (root == null) {
                return null;
            }
            PersistentLongMap.Entry entry = (PersistentLongMap.Entry)root.getByWeight(key);
            return entry == null ? null : (V)entry.getValue();
        }

        @Override
        public boolean containsKey(long key) {
            AbstractPersistent23Tree.RootNode root = this.getRoot();
            return root != null && root.getByWeight(key) != null;
        }

        @Override
        public Iterator<PersistentLongMap.Entry<V>> tailEntryIterator(long staringKey) {
            return this.tailIterator(new LongMapEntry(staringKey));
        }

        @Override
        public Iterator<PersistentLongMap.Entry<V>> tailReverseEntryIterator(long staringKey) {
            return this.tailReverseIterator(new LongMapEntry(staringKey));
        }
    }
}

