/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.jira.dnq.client;

import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Ljetbrains/jetpass/auth/module/jira/dnq/client/JiraAuthenticationException;", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException;", "code", "", "message", "cause", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "Companion", "jetbrains.jetpass.auth.module.jira.dnq"})
public final class JiraAuthenticationException
extends AuthenticationException {
    @NotNull
    private static final String AUTH_FAILED = "jira-auth-failed";
    @NotNull
    private static final String USER_FETCH_FAILED = "jira-user-fetch";
    public static final Companion Companion = new Companion(null);

    private JiraAuthenticationException(String code, String message, Throwable cause) {
        super(code, message, cause, null, 8, null);
    }

    static {
        AUTH_FAILED = AUTH_FAILED;
        USER_FETCH_FAILED = USER_FETCH_FAILED;
    }

    public /* synthetic */ JiraAuthenticationException(@NotNull String code, @NotNull String message, @NotNull Throwable cause, DefaultConstructorMarker $constructor_marker) {
        this(code, message, cause);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u000fj\u0002`\u0010J\u0012\u0010\u0011\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u000fj\u0002`\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Ljetbrains/jetpass/auth/module/jira/dnq/client/JiraAuthenticationException$Companion;", "", "()V", "AUTH_FAILED", "", "getAUTH_FAILED", "()Ljava/lang/String;", "USER_FETCH_FAILED", "getUSER_FETCH_FAILED", "cantGetUser", "Ljetbrains/jetpass/auth/module/jira/dnq/client/JiraAuthenticationException;", "ex", "Ljavax/ws/rs/ProcessingException;", "Ljavax/ws/rs/WebApplicationException;", "invalidRequest", "Ljava/lang/Exception;", "Lkotlin/Exception;", "requestFailed", "jetbrains.jetpass.auth.module.jira.dnq"})
    public static final class Companion {
        @NotNull
        public final String getAUTH_FAILED() {
            return AUTH_FAILED;
        }

        @NotNull
        public final String getUSER_FETCH_FAILED() {
            return USER_FETCH_FAILED;
        }

        @NotNull
        public final JiraAuthenticationException invalidRequest(@NotNull Exception ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            return new JiraAuthenticationException(this.getAUTH_FAILED(), "Invalid JIRA request", ex, null);
        }

        @NotNull
        public final JiraAuthenticationException requestFailed(@NotNull Exception ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            return new JiraAuthenticationException(this.getAUTH_FAILED(), "Error while requesting JIRA: " + ex.getMessage(), ex, null);
        }

        @NotNull
        public final JiraAuthenticationException cantGetUser(@NotNull WebApplicationException ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            return new JiraAuthenticationException(this.getUSER_FETCH_FAILED(), "Cannot get JIRA user data: " + ex.getMessage(), (Throwable)ex, null);
        }

        @NotNull
        public final JiraAuthenticationException cantGetUser(@NotNull ProcessingException ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            return new JiraAuthenticationException(this.getUSER_FETCH_FAILED(), "Cannot get JIRA user data due to JIRA server processing problem: " + ex.getMessage(), (Throwable)ex, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

