/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.jira.dnq.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.request.Header;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.auth.module.jira.api.user.details.JiraUserDetailsImpl;
import jetbrains.jetpass.auth.module.jira.dnq.client.JiraAuthenticationException;
import jetbrains.jetpass.auth.module.jira.dnq.client.JiraClient;
import jetbrains.jetpass.auth.module.jira.dnq.client.JiraUserResponseJSON;
import jetbrains.jetpass.auth.module.jira.dnq.xd.XdJiraAuthModule;
import jetbrains.jetpass.auth.module.jira.rest.client.api.JiraUserDetails;
import jetbrains.jetpass.dao.dnq.api.authority.module.JetPassAuthModuleDAO;
import jetbrains.jetpass.pojo.api.authority.profile.EmailContactImpl;
import jetbrains.jetpass.userManagement.persistence.authmodule.WebTargetCache;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdExternalAuthModule;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/auth/module/jira/dnq/client/JiraClientImpl;", "Ljetbrains/jetpass/auth/module/jira/dnq/client/JiraClient;", "xdModule", "Ljetbrains/jetpass/auth/module/jira/dnq/xd/XdJiraAuthModule;", "webTargetCache", "Ljetbrains/jetpass/userManagement/persistence/authmodule/WebTargetCache;", "authModuleDAO", "Ljetbrains/jetpass/dao/dnq/api/authority/module/JetPassAuthModuleDAO;", "(Ljetbrains/jetpass/auth/module/jira/dnq/xd/XdJiraAuthModule;Ljetbrains/jetpass/userManagement/persistence/authmodule/WebTargetCache;Ljetbrains/jetpass/dao/dnq/api/authority/module/JetPassAuthModuleDAO;)V", "requestJSON", "Ljetbrains/jetpass/auth/module/jira/dnq/client/JiraUserResponseJSON;", "username", "", "password", "requestJira", "Ljetbrains/jetpass/auth/module/jira/rest/client/api/JiraUserDetails;", "jetbrains.jetpass.auth.module.jira.dnq"})
public final class JiraClientImpl
implements JiraClient {
    private final XdJiraAuthModule xdModule;
    private final WebTargetCache webTargetCache;
    private final JetPassAuthModuleDAO authModuleDAO;

    @Override
    @Nullable
    public JiraUserDetails requestJira(@NotNull String username, @NotNull String password) {
        JiraUserDetailsImpl jiraUserDetailsImpl;
        JiraUserResponseJSON userJson;
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        JiraUserResponseJSON jiraUserResponseJSON = userJson = this.requestJSON(username, password);
        if (jiraUserResponseJSON != null) {
            JiraUserDetailsImpl jiraUserDetailsImpl2;
            JiraUserResponseJSON jiraUserResponseJSON2;
            JiraUserResponseJSON it = jiraUserResponseJSON2 = jiraUserResponseJSON;
            JiraUserDetailsImpl impl = jiraUserDetailsImpl2 = new JiraUserDetailsImpl();
            impl.setAuthModule(this.authModuleDAO.wrapEntity((XdAuthModule)this.xdModule));
            impl.setLogin(it.getName());
            impl.setFullName(it.getDisplayName());
            impl.setEmail((EmailContact)new EmailContactImpl(it.getEmailAddress(), false));
            jiraUserDetailsImpl = jiraUserDetailsImpl2;
        } else {
            jiraUserDetailsImpl = null;
        }
        return (JiraUserDetails)jiraUserDetailsImpl;
    }

    private final JiraUserResponseJSON requestJSON(String username, String password) {
        try {
            ObjectMapper objectMapper;
            Map jiraSessionJson;
            Header authHeader = Header.Companion.authorization((AuthToken)new BasicAuthToken(username, password));
            WebTarget jiraRest = this.webTargetCache.getOrCreate((XdExternalAuthModule)this.xdModule).path("rest");
            Map map = jiraSessionJson = (Map)jiraRest.path("auth").path("1").path("session").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header(authHeader.getName(), (Object)authHeader.getValue()).get(Map.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"jiraSessionJson");
            Map map2 = map;
            String string = "self";
            Object v = map2.get(string);
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String self = (String)v;
            String jiraUserJson = (String)this.webTargetCache.getOrCreateClient((XdExternalAuthModule)this.xdModule).target(self).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header(authHeader.getName(), (Object)authHeader.getValue()).get(String.class);
            ObjectMapper $receiver = objectMapper = new ObjectMapper();
            $receiver.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            ObjectMapper mapper = objectMapper;
            return (JiraUserResponseJSON)mapper.readValue(jiraUserJson, JiraUserResponseJSON.class);
        }
        catch (IllegalStateException ex) {
            throw (Throwable)((Object)JiraAuthenticationException.Companion.invalidRequest(ex));
        }
        catch (WebApplicationException ex) {
            Response response = ex.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ex.response");
            int n = response.getStatus();
            if (n == Response.Status.UNAUTHORIZED.getStatusCode() || n == Response.Status.FORBIDDEN.getStatusCode()) {
                return null;
            }
            throw (Throwable)((Object)JiraAuthenticationException.Companion.cantGetUser(ex));
        }
        catch (ProcessingException ex) {
            throw (Throwable)((Object)JiraAuthenticationException.Companion.cantGetUser(ex));
        }
        catch (Exception ex) {
            throw (Throwable)((Object)JiraAuthenticationException.Companion.requestFailed(ex));
        }
    }

    public JiraClientImpl(@NotNull XdJiraAuthModule xdModule, @NotNull WebTargetCache webTargetCache, @NotNull JetPassAuthModuleDAO authModuleDAO) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdModule), (String)"xdModule");
        Intrinsics.checkParameterIsNotNull((Object)webTargetCache, (String)"webTargetCache");
        Intrinsics.checkParameterIsNotNull((Object)authModuleDAO, (String)"authModuleDAO");
        this.xdModule = xdModule;
        this.webTargetCache = webTargetCache;
        this.authModuleDAO = authModuleDAO;
    }
}

