/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.date;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.keyword.OpenRangeFieldValue;
import jetbrains.charisma.parser.date.ExtendedDateFieldService;
import jetbrains.charisma.persistent.NamedRangeImpl;
import jetbrains.charisma.smartui.parser.date.DatePeriod;
import jetbrains.charisma.smartui.parser.date.RangeDatePeriod;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.parser.DateGrouping;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.core.dates.DateGroupingOptionImpl;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.search.date.DateFieldServiceImpl;
import jetbrains.youtrack.search.date.DateGroupingImpl;
import jetbrains.youtrack.search.date.DatePeriodFieldValue;
import jetbrains.youtrack.search.date.NamedDatePeriodFieldValue;
import jetbrains.youtrack.search.date.period.DatePeriodsConfiguration;
import jetbrains.youtrack.search.date.period.NamedDatePeriod;
import jetbrains.youtrack.search.date.period.NamedPeriodsContainerKt;
import jetbrains.youtrack.search.keyword.predefined.DatePredefinedField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\t2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016JF\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172$\u0010\u0019\u001a \u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u001aH\u0016J\u0012\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u001f\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u0014\u0010%\u001a\u00020&2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ljetbrains/youtrack/search/date/DateFieldServiceImpl;", "Ljetbrains/charisma/parser/date/ExtendedDateFieldService;", "()V", "formatToKey", "", "", "createDatePeriodFieldValue", "Ljetbrains/youtrack/api/parser/IFieldValue;", "period", "Ljetbrains/charisma/smartui/parser/date/DatePeriod;", "createFutureDateGrouping", "Ljetbrains/youtrack/api/parser/DateGrouping;", "createGrouping", "option", "Ljetbrains/exodus/entitystore/Entity;", "createRangeDatePeriod", "left", "right", "findDatePeriod", "range", "findDatePeriodFieldValues", "", "issues", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/persistent/XdIssue;", "filterBy", "Lkotlin/Function2;", "getDateRangeComparator", "Ljava/util/Comparator;", "getLocalizedFormatPresentation", "format", "getValue", "", "issue", "field", "Ljetbrains/youtrack/api/parser/IField;", "(Ljetbrains/youtrack/persistent/XdIssue;Ljetbrains/youtrack/api/parser/IField;)Ljava/lang/Long;", "isDatePeriodFieldValue", "", "value", "Companion", "youtrack-search"})
public final class DateFieldServiceImpl
implements ExtendedDateFieldService {
    private final Map<String, String> formatToKey = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)BeansKt.getLocalizer().getDefaultMsg("hours-minutes", new Object[0]), (Object)"hours-minutes"), TuplesKt.to((Object)BeansKt.getLocalizer().getDefaultMsg("hours-minutes-seconds", new Object[0]), (Object)"hours-minutes-seconds"), TuplesKt.to((Object)BeansKt.getLocalizer().getDefaultMsg("year-month", new Object[0]), (Object)"year-month"), TuplesKt.to((Object)BeansKt.getLocalizer().getDefaultMsg("year-month-day", new Object[0]), (Object)"year-month-day"), TuplesKt.to((Object)BeansKt.getLocalizer().getDefaultMsg("month-day", new Object[0]), (Object)"month-day")});
    private static final DateTimeFormatter DAY;
    private static final DateTimeFormatter WEEK;
    private static final DateTimeFormatter MONTH;
    private static final DateTimeFormatter YEAR;
    @NotNull
    private static final DateGrouping DEFAULT_GROUPING;
    private static final Comparator<IFieldValue<?>> DATE_COMPARATOR;
    public static final Companion Companion;

    @NotNull
    public String getLocalizedFormatPresentation(@NotNull String format) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        String string = this.formatToKey.get(format);
        if (string == null) {
            return format;
        }
        String key = string;
        return BeansKt.getLocalizer().localizedMsgInServerLocale(key, new Object[0]);
    }

    @NotNull
    public DateGrouping createGrouping(@Nullable Entity option) {
        if (Intrinsics.areEqual((Object)option, (Object)DateGroupingOptionImpl.DAY.get())) {
            return Companion.day();
        }
        if (Intrinsics.areEqual((Object)option, (Object)DateGroupingOptionImpl.WEEK.get())) {
            return Companion.week();
        }
        if (Intrinsics.areEqual((Object)option, (Object)DateGroupingOptionImpl.MONTH.get())) {
            return Companion.month();
        }
        if (Intrinsics.areEqual((Object)option, (Object)DateGroupingOptionImpl.YEAR.get())) {
            return Companion.year();
        }
        return DEFAULT_GROUPING;
    }

    @NotNull
    public DateGrouping createFutureDateGrouping() {
        return createFutureDateGrouping.1.INSTANCE;
    }

    @NotNull
    public Comparator<IFieldValue<?>> getDateRangeComparator() {
        return DATE_COMPARATOR;
    }

    @NotNull
    public Iterable<IFieldValue<?>> findDatePeriodFieldValues(@NotNull XdQuery<? extends XdIssue> issues, @NotNull Function2<? super DatePeriod, ? super XdQuery<? extends XdIssue>, ? extends XdQuery<? extends XdIssue>> filterBy) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(issues, (String)"issues");
        Intrinsics.checkParameterIsNotNull(filterBy, (String)"filterBy");
        Iterable iterable = $receiver$iv = NamedPeriodsContainerKt.getNamedPeriodsContainer().getFilterPeriods();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            NamedDatePeriod it = (NamedDatePeriod)element$iv$iv;
            boolean bl = false;
            if (!XdQueryKt.isNotEmpty((XdQuery)((XdQuery)filterBy.invoke((Object)it, issues)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IFieldValue<?> iFieldValue;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            NamedDatePeriod it = (NamedDatePeriod)element$iv$iv;
            boolean bl = false;
            if (NamedDatePeriodFieldValue.Companion.findKeyWord(it) == null) continue;
            IFieldValue<?> it$iv$iv = iFieldValue;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public boolean isDatePeriodFieldValue(@NotNull IFieldValue<?> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return value instanceof DatePeriodFieldValue;
    }

    @Nullable
    public DatePeriod createRangeDatePeriod(@NotNull IFieldValue<?> left, @NotNull IFieldValue<?> right) {
        Intrinsics.checkParameterIsNotNull(left, (String)"left");
        Intrinsics.checkParameterIsNotNull(right, (String)"right");
        DatePeriod result = null;
        if ((left instanceof DatePeriodFieldValue || left instanceof OpenRangeFieldValue) && (right instanceof DatePeriodFieldValue || right instanceof OpenRangeFieldValue)) {
            DatePeriodFieldValue datePeriodFieldValue;
            IFieldValue<?> iFieldValue;
            DatePeriodFieldValue leftValue;
            DatePeriodFieldValue datePeriodFieldValue2;
            IFieldValue<?> iFieldValue2 = left;
            if (!(iFieldValue2 instanceof DatePeriodFieldValue)) {
                iFieldValue2 = null;
            }
            if ((datePeriodFieldValue2 = (DatePeriodFieldValue)iFieldValue2) == null || (datePeriodFieldValue2 = (DatePeriod)datePeriodFieldValue2.getFieldValue()) == null) {
                datePeriodFieldValue2 = leftValue = (DatePeriod)new RangeDatePeriod(Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MIN_VALUE));
            }
            if (!((iFieldValue = right) instanceof DatePeriodFieldValue)) {
                iFieldValue = null;
            }
            if ((datePeriodFieldValue = (DatePeriodFieldValue)iFieldValue) == null || (datePeriodFieldValue = (DatePeriod)datePeriodFieldValue.getFieldValue()) == null) {
                datePeriodFieldValue = (DatePeriod)new RangeDatePeriod(Long.valueOf(Long.MAX_VALUE), Long.valueOf(Long.MAX_VALUE));
            }
            DatePeriodFieldValue rightValue = datePeriodFieldValue;
            result = (DatePeriod)new RangeDatePeriod((DatePeriod)leftValue, (DatePeriod)rightValue);
        }
        return result;
    }

    @NotNull
    public IFieldValue<?> createDatePeriodFieldValue(@NotNull DatePeriod period) {
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        return (IFieldValue)new DatePeriodFieldValue<DatePeriod>(period, period){
            final /* synthetic */ DatePeriod $period;
            {
                this.$period = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    @Nullable
    public DatePeriod findDatePeriod(@NotNull Entity range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        DatePeriodsConfiguration container = NamedPeriodsContainerKt.getNamedPeriodsContainer().getConf();
        Entity entity = range;
        return Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.TODAY.get()) ? (DatePeriod)container.getToday() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.TOMORROW.get()) ? (DatePeriod)container.getTomorrow() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.YESTERDAY.get()) ? (DatePeriod)container.getYesterday() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.THIS_WEEK.get()) ? (DatePeriod)container.getThisWeek() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.THIS_MONTH.get()) ? (DatePeriod)container.getThisMonth() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.THIS_YEAR.get()) ? (DatePeriod)container.getThisYear() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.LAST_WEEK.get()) ? (DatePeriod)container.getLastWeek() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.LAST_MONTH.get()) ? (DatePeriod)container.getLastMonth() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.LAST_YEAR.get()) ? (DatePeriod)container.getLastYear() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.LAST_WORKING_DAY.get()) ? (DatePeriod)container.getLastWorkingDay() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.NEXT_WEEK.get()) ? (DatePeriod)container.getNextWeek() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.NEXT_MONTH.get()) ? (DatePeriod)container.getNextMonth() : (Intrinsics.areEqual((Object)entity, (Object)NamedRangeImpl.NEXT_YEAR.get()) ? (DatePeriod)container.getNextYear() : null))))))))))));
    }

    @Nullable
    public Long getValue(@NotNull XdIssue issue, @NotNull IField field) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        IField iField = field;
        if (!(iField instanceof DatePredefinedField)) {
            iField = null;
        }
        DatePredefinedField datePredefinedField = (DatePredefinedField)iField;
        if (datePredefinedField == null) {
            return null;
        }
        DatePredefinedField dateField = datePredefinedField;
        return dateField.getValue(issue);
    }

    static {
        Companion = new Companion(null);
        DAY = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        WEEK = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        MONTH = DateTimeFormat.forPattern((String)"yyyy-MM");
        YEAR = DateTimeFormat.forPattern((String)"yyyy-MM");
        DEFAULT_GROUPING = Companion.DEFAULT_GROUPING.1.INSTANCE;
        DATE_COMPARATOR = Companion.DATE_COMPARATOR.1.INSTANCE;
    }

    public static final /* synthetic */ DateTimeFormatter access$getDAY$cp() {
        return DAY;
    }

    public static final /* synthetic */ DateTimeFormatter access$getWEEK$cp() {
        return WEEK;
    }

    public static final /* synthetic */ DateTimeFormatter access$getMONTH$cp() {
        return MONTH;
    }

    public static final /* synthetic */ DateTimeFormatter access$getYEAR$cp() {
        return YEAR;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u0013\u001a\u00020\nR\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/search/date/DateFieldServiceImpl$Companion;", "", "()V", "DATE_COMPARATOR", "Ljava/util/Comparator;", "Ljetbrains/youtrack/api/parser/IFieldValue;", "DAY", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "DEFAULT_GROUPING", "Ljetbrains/youtrack/api/parser/DateGrouping;", "getDEFAULT_GROUPING", "()Ljetbrains/youtrack/api/parser/DateGrouping;", "MONTH", "WEEK", "YEAR", "day", "month", "week", "year", "youtrack-search"})
    public static final class Companion {
        @NotNull
        public final DateGrouping getDEFAULT_GROUPING() {
            return DEFAULT_GROUPING;
        }

        @NotNull
        public final DateGrouping day() {
            return new DateGroupingImpl(this){
                private final DateTimeFormatter fmt;
                private final boolean useMaxValue = false;
                final /* synthetic */ Companion this$0;

                @NotNull
                public DateTime.Property select(@NotNull DateTime time) {
                    Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
                    DateTime.Property property = time.millisOfDay();
                    Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"time.millisOfDay()");
                    return property;
                }

                public DateTimeFormatter getFmt() {
                    return this.fmt;
                }

                public boolean getUseMaxValue() {
                    return this.useMaxValue;
                }
                {
                    this.this$0 = $outer;
                    this.fmt = DateFieldServiceImpl.access$getDAY$cp();
                }
            };
        }

        @NotNull
        public final DateGrouping week() {
            return new DateGroupingImpl(this){
                private final DateTimeFormatter fmt;
                final /* synthetic */ Companion this$0;

                @NotNull
                public DateTime.Property select(@NotNull DateTime time) {
                    Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
                    DateTime.Property property = time.withMillisOfDay(0).dayOfWeek();
                    Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"time.withMillisOfDay(0).dayOfWeek()");
                    return property;
                }

                public DateTimeFormatter getFmt() {
                    return this.fmt;
                }
                {
                    this.this$0 = $outer;
                    this.fmt = DateFieldServiceImpl.access$getWEEK$cp();
                }
            };
        }

        @NotNull
        public final DateGrouping month() {
            return new DateGroupingImpl(this){
                private final DateTimeFormatter fmt;
                private final boolean useMaxValue = false;
                final /* synthetic */ Companion this$0;

                @NotNull
                public DateTime.Property select(@NotNull DateTime time) {
                    Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
                    DateTime.Property property = time.withMillisOfDay(0).dayOfMonth();
                    Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"time.withMillisOfDay(0).dayOfMonth()");
                    return property;
                }

                public DateTimeFormatter getFmt() {
                    return this.fmt;
                }

                public boolean getUseMaxValue() {
                    return this.useMaxValue;
                }
                {
                    this.this$0 = $outer;
                    this.fmt = DateFieldServiceImpl.access$getMONTH$cp();
                }
            };
        }

        @NotNull
        public final DateGrouping year() {
            return new DateGroupingImpl(this){
                private final DateTimeFormatter fmt;
                final /* synthetic */ Companion this$0;

                @NotNull
                public DateTime.Property select(@NotNull DateTime time) {
                    Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
                    DateTime.Property property = time.withMillisOfDay(0).dayOfYear();
                    Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"time.withMillisOfDay(0).dayOfYear()");
                    return property;
                }

                public DateTimeFormatter getFmt() {
                    return this.fmt;
                }
                {
                    this.this$0 = $outer;
                    this.fmt = DateFieldServiceImpl.access$getYEAR$cp();
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

