/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.date.period;

import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.dates.DateFormats;
import jetbrains.youtrack.search.date.period.NamedDatePeriod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u000f\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\bH\u0016J\u000f\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/search/date/period/DayPeriod;", "Ljetbrains/youtrack/search/date/period/NamedDatePeriod;", "name", "", "ordinal", "", "(Ljava/lang/String;I)V", "day", "Lorg/joda/time/DateTime;", "getDay", "()Lorg/joda/time/DateTime;", "getDescription", "getFrom", "", "()Ljava/lang/Long;", "getReferenceDate", "getTo", "youtrack-search"})
public abstract class DayPeriod
extends NamedDatePeriod {
    @NotNull
    protected abstract DateTime getDay();

    @Nullable
    public Long getFrom() {
        DateTime dateTime = this.getDay().millisOfDay().withMinimumValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"day.millisOfDay().withMinimumValue()");
        return dateTime.getMillis();
    }

    @Nullable
    public Long getTo() {
        DateTime dateTime = this.getDay().millisOfDay().withMaximumValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"day.millisOfDay().withMaximumValue()");
        return dateTime.getMillis();
    }

    @NotNull
    public DateTime getReferenceDate() {
        return this.getDay();
    }

    @NotNull
    public String getDescription() {
        String string = BeansKt.getLocalizer().localizedMsg("NamedDatePeriod.{0}_from_00_00_to_23_59", new Object[]{DateFormats.INSTANCE.getFormatter("humanDate").withLocale(BeansKt.getLocalizer().getLocale()).print((ReadableInstant)this.getDay())});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\n\u2026ale).print(day)\n        )");
        return string;
    }

    public DayPeriod(@NotNull String name, int ordinal) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(name, ordinal);
    }
}

