/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.date.period;

import jetbrains.charisma.smartui.parser.date.AbstractDatePeriod;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.search.date.period.NamedDatePeriod;
import jetbrains.youtrack.search.date.period.NamedDatePeriodKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016J\u000f\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\tH\u0016J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/search/date/period/WeekPeriod;", "Ljetbrains/youtrack/search/date/period/NamedDatePeriod;", "name", "", "ordinal", "", "ago", "(Ljava/lang/String;II)V", "week", "Lorg/joda/time/DateTime;", "getWeek", "()Lorg/joda/time/DateTime;", "getDescription", "getFrom", "", "()Ljava/lang/Long;", "getReferenceDate", "getTo", "youtrack-search"})
public class WeekPeriod
extends NamedDatePeriod {
    private final int ago;

    private final DateTime getWeek() {
        DateTime dateTime = WeekPeriod.access$getNowInCurrentUserTimeZone$s-866673423().minusWeeks(this.ago);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"AbstractDatePeriod.getNo\u2026imeZone().minusWeeks(ago)");
        return dateTime;
    }

    @Nullable
    public Long getFrom() {
        DateTime dateTime = this.getWeek().dayOfWeek().withMinimumValue().millisOfDay().withMinimumValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"week.dayOfWeek().withMin\u2026fDay().withMinimumValue()");
        return dateTime.getMillis();
    }

    @Nullable
    public Long getTo() {
        DateTime dateTime = this.getWeek().dayOfWeek().withMaximumValue().millisOfDay().withMaximumValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"week.dayOfWeek().withMax\u2026fDay().withMaximumValue()");
        return dateTime.getMillis();
    }

    @NotNull
    public DateTime getReferenceDate() {
        DateTime dateTime = this.getWeek().withDayOfWeek(1).withTimeAtStartOfDay();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"week.withDayOfWeek(1).withTimeAtStartOfDay()");
        return dateTime;
    }

    @NotNull
    public String getDescription() {
        String string = BeansKt.getLocalizer().localizedMsg("NamedDatePeriod.Period_from_{0}_to_{1}_for_week_period", new Object[]{NamedDatePeriodKt.printHumanDate(this.getFrom()), NamedDatePeriodKt.printHumanDate(this.getTo())});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\n\u2026ntHumanDate(to)\n        )");
        return string;
    }

    public WeekPeriod(@NotNull String name, int ordinal, int ago) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(name, ordinal);
        this.ago = ago;
    }

    public static final /* synthetic */ DateTime access$getNowInCurrentUserTimeZone$s-866673423() {
        return AbstractDatePeriod.getNowInCurrentUserTimeZone();
    }
}

