/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.prefixTree;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import jetbrains.youtrack.search.prefixTree.Node;
import jetbrains.youtrack.search.prefixTree.PrefixTree;
import jetbrains.youtrack.search.prefixTree.PrefixTreeSequence$LazyPrefixTreeIterator$WhenMappings;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\n\u000b\fB!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0096\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/search/prefixTree/PrefixTreeSequence;", "T", "Lkotlin/sequences/Sequence;", "subTreeRoot", "Ljetbrains/youtrack/search/prefixTree/Node;", "tree", "Ljetbrains/youtrack/search/prefixTree/PrefixTree;", "(Ljetbrains/youtrack/search/prefixTree/Node;Ljetbrains/youtrack/search/prefixTree/PrefixTree;)V", "iterator", "", "LazyPrefixTreeIterator", "NodeIterator", "States", "youtrack-search"})
public final class PrefixTreeSequence<T>
implements Sequence<T> {
    private final Node<T> subTreeRoot;
    private final PrefixTree<T> tree;

    @NotNull
    public Iterator<T> iterator() {
        return new LazyPrefixTreeIterator(this.subTreeRoot, this.tree);
    }

    public PrefixTreeSequence(@NotNull Node<T> subTreeRoot, @NotNull PrefixTree<T> tree) {
        Intrinsics.checkParameterIsNotNull(subTreeRoot, (String)"subTreeRoot");
        Intrinsics.checkParameterIsNotNull(tree, (String)"tree");
        this.subTreeRoot = subTreeRoot;
        this.tree = tree;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B#\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\t\u0010\u0011\u001a\u00020\u000fH\u0096\u0002J\u000e\u0010\u0012\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/search/prefixTree/PrefixTreeSequence$LazyPrefixTreeIterator;", "", "subTreeRoot", "Ljetbrains/youtrack/search/prefixTree/Node;", "tree", "Ljetbrains/youtrack/search/prefixTree/PrefixTree;", "(Ljetbrains/youtrack/search/prefixTree/PrefixTreeSequence;Ljetbrains/youtrack/search/prefixTree/Node;Ljetbrains/youtrack/search/prefixTree/PrefixTree;)V", "currentValues", "nextElement", "Ljava/lang/Object;", "stack", "Ljava/util/ArrayDeque;", "state", "Ljetbrains/youtrack/search/prefixTree/PrefixTreeSequence$States;", "advance", "", "advanceSafe", "hasNext", "next", "()Ljava/lang/Object;", "youtrack-search"})
    private final class LazyPrefixTreeIterator
    implements Iterator<T>,
    KMappedMarker {
        private final ArrayDeque<Iterator<Node<T>>> stack;
        private Iterator<? extends T> currentValues;
        private T nextElement;
        private States state;
        private final PrefixTree<T> tree;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            States states = this.state;
            if (states == null) return false;
            switch (PrefixTreeSequence$LazyPrefixTreeIterator$WhenMappings.$EnumSwitchMapping$0[states.ordinal()]) {
                case 1: {
                    boolean bl = this.advanceSafe();
                    return bl;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                this.state = States.UNKNOWN_NEXT;
                Object t2 = this.nextElement;
                if (t2 == null) {
                    Intrinsics.throwNpe();
                }
                return t2;
            }
            throw (Throwable)new NoSuchElementException();
        }

        private final boolean advanceSafe() {
            try {
                return this.advance();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return false;
            }
        }

        private final boolean advance() {
            Iterator iterator;
            Iterator $receiver = iterator = this.currentValues;
            boolean bl = false;
            if ($receiver.hasNext()) {
                this.nextElement = $receiver.next();
                this.state = States.HAS_NEXT;
                return true;
            }
            while (!this.stack.isEmpty()) {
                Iterator it = this.stack.peek();
                if (!it.hasNext()) {
                    this.stack.pop();
                    continue;
                }
                Node currentNode = it.next();
                Iterable children = this.tree.getChildren$youtrack_search(currentNode);
                if (children != PrefixTree.Companion.emptyChildren()) {
                    this.stack.push(new NodeIterator(children.iterator()));
                }
                if (!currentNode.hasValues()) continue;
                Iterable iterable = currentNode.getValues();
                if (iterable == null) {
                    Intrinsics.throwNpe();
                }
                this.currentValues = iterable.iterator();
                this.nextElement = this.currentValues.next();
                this.state = States.HAS_NEXT;
                return true;
            }
            this.state = States.NO_NEXT;
            return false;
        }

        public LazyPrefixTreeIterator(@NotNull Node<T> subTreeRoot, PrefixTree<T> tree) {
            Intrinsics.checkParameterIsNotNull(subTreeRoot, (String)"subTreeRoot");
            Intrinsics.checkParameterIsNotNull(tree, (String)"tree");
            this.tree = tree;
            this.stack = new ArrayDeque();
            Iterator iterator = Collections.emptyIterator();
            Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"Collections.emptyIterator()");
            this.currentValues = iterator;
            this.state = States.UNKNOWN_NEXT;
            this.stack.push(CollectionsKt.listOf(subTreeRoot).iterator());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/search/prefixTree/PrefixTreeSequence$States;", "", "(Ljava/lang/String;I)V", "UNKNOWN_NEXT", "HAS_NEXT", "NO_NEXT", "youtrack-search"})
    private static final class States
    extends Enum<States> {
        public static final /* enum */ States UNKNOWN_NEXT;
        public static final /* enum */ States HAS_NEXT;
        public static final /* enum */ States NO_NEXT;
        private static final /* synthetic */ States[] $VALUES;

        static {
            States[] statesArray = new States[3];
            States[] statesArray2 = statesArray;
            statesArray[0] = UNKNOWN_NEXT = new States();
            statesArray[1] = HAS_NEXT = new States();
            statesArray[2] = NO_NEXT = new States();
            $VALUES = statesArray;
        }

        public static States[] values() {
            return (States[])$VALUES.clone();
        }

        public static States valueOf(String string) {
            return Enum.valueOf(States.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B%\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\u00050\u0002\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u000bH\u0096\u0002J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0096\u0002R)\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\u00050\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/search/prefixTree/PrefixTreeSequence$NodeIterator;", "T", "", "Ljetbrains/youtrack/search/prefixTree/Node;", "it", "", "", "(Ljava/util/Iterator;)V", "getIt", "()Ljava/util/Iterator;", "hasNext", "", "next", "youtrack-search"})
    private static final class NodeIterator<T>
    implements Iterator<Node<T>>,
    KMappedMarker {
        @NotNull
        private final Iterator<Map.Entry<Long, Node<T>>> it;

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        @NotNull
        public Node<T> next() {
            return this.it.next().getValue();
        }

        @NotNull
        public final Iterator<Map.Entry<Long, Node<T>>> getIt() {
            return this.it;
        }

        public NodeIterator(@NotNull Iterator<? extends Map.Entry<Long, Node<T>>> it) {
            Intrinsics.checkParameterIsNotNull(it, (String)"it");
            this.it = it;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

