/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import jetbrains.mps.baseLanguage.closures.runtime.AdapterClass;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.IQueueSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.impl.NullQueueSequence;

public class QueueSequence<T>
extends CollectionSequence<T>
implements Queue<T>,
IQueueSequence<T>,
Serializable {
    private static final long serialVersionUID = -7304432472048720900L;
    private Queue<T> queue;

    protected QueueSequence(Queue<T> queue) {
        this.setQueue(queue);
    }

    @Override
    public T element() {
        return this.getQueue().element();
    }

    @Override
    public boolean offer(T o) {
        return this.getQueue().offer(o);
    }

    @Override
    public T peek() {
        return this.getQueue().peek();
    }

    @Override
    public T poll() {
        return this.getQueue().poll();
    }

    @Override
    public T remove() {
        return this.getQueue().remove();
    }

    @Override
    public T addLastElement(T t) {
        this.getQueue().add(t);
        return t;
    }

    @Override
    public T first() {
        return this.getQueue().peek();
    }

    @Override
    public T removeFirstElement() {
        return this.getQueue().poll();
    }

    @Override
    public IQueueSequence<T> addSequence(ISequence<? extends T> seq) {
        return (IQueueSequence)super.addSequence(seq);
    }

    @Override
    public IQueueSequence<T> removeSequence(ISequence<? extends T> seq) {
        return (IQueueSequence)super.removeSequence(seq);
    }

    @Override
    public IQueueSequence<T> removeWhere(@AdapterClass(value="IWhereFilter") _FunctionTypes._return_P1_E0<? extends Boolean, ? super T> filter) {
        return (IQueueSequence)super.removeWhere(filter);
    }

    @Override
    public IQueueSequence<T> asUnmodifiable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IQueueSequence<T> asSynchronized() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Queue<T> toQueue() {
        return this;
    }

    @Override
    protected Collection<T> getCollection() {
        return this.queue;
    }

    protected Queue<T> getQueue() {
        return this.queue;
    }

    private void setQueue(Queue<T> queue) {
        this.queue = queue;
    }

    public static <U> IQueueSequence<U> fromQueue(Queue<U> queue) {
        if (queue == null) {
            return NullQueueSequence.instance();
        }
        if (queue instanceof IQueueSequence) {
            return (IQueueSequence)queue;
        }
        return new QueueSequence<U>(queue);
    }

    public static <U> IQueueSequence<U> fromIterable(Iterable<U> it) {
        if (it == null) {
            return NullQueueSequence.instance();
        }
        if (it instanceof IQueueSequence) {
            return (IQueueSequence)it;
        }
        LinkedList<U> queue = new LinkedList<U>();
        if (it instanceof Collection) {
            queue.addAll((Collection)it);
        } else {
            for (U u : it) {
                queue.add(u);
            }
        }
        return new QueueSequence(queue);
    }

    public static <U> IQueueSequence<U> fromQueueAndArray(Queue<U> queue, U ... array) {
        if (array == null) {
            array = Sequence.nullSingletonArray();
        }
        if (queue == null && array == null) {
            return NullQueueSequence.instance();
        }
        if (queue == null) {
            queue = new LinkedList<U>();
        } else if (array == null) {
            if (queue instanceof IQueueSequence) {
                return (IQueueSequence)queue;
            }
            return new QueueSequence<U>(queue);
        }
        List<U> input = Arrays.asList(array);
        queue.addAll(input);
        if (queue instanceof IQueueSequence) {
            return (IQueueSequence)queue;
        }
        return new QueueSequence<U>(queue);
    }

    public static <U> IQueueSequence<U> fromQueueWithValues(Queue<U> queue, Iterable<? extends U> it) {
        Queue<U> tmp = queue;
        if (queue == null && it == null) {
            return NullQueueSequence.instance();
        }
        if (queue == null) {
            tmp = new LinkedList<U>();
        } else if (it == null) {
            return QueueSequence.fromQueue(queue);
        }
        if (it instanceof Collection) {
            tmp.addAll((Collection)it);
        } else {
            for (U u : it) {
                tmp.add(u);
            }
        }
        if (tmp instanceof IQueueSequence) {
            return (IQueueSequence)tmp;
        }
        return new QueueSequence<U>(tmp);
    }
}

