/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.StopIteratingException;
import jetbrains.mps.internal.collections.runtime.impl.AbstractChainedSequence;
import jetbrains.mps.internal.collections.runtime.impl.HasNextState;
import jetbrains.mps.internal.collections.runtime.impl.NullSequence;

public class TranslatingSequence<U, V>
extends AbstractChainedSequence<U, V>
implements Iterable<V> {
    private final _FunctionTypes._return_P1_E0<? extends Iterable<V>, ? super U> translator;

    public TranslatingSequence(Iterable<U> input, _FunctionTypes._return_P1_E0<? extends Iterable<V>, ? super U> translator) {
        super(input);
        if (translator == null) {
            throw new NullPointerException();
        }
        this.translator = translator;
    }

    @Override
    public Iterator<V> iterator() {
        return new TranslatingIterator();
    }

    private class TranslatingIterator
    implements Iterator<V> {
        private Iterator<U> inputIt;
        private Iterator<V> transIt;
        private HasNextState hasNext = HasNextState.UNKNOWN;
        private V next;

        private TranslatingIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.inputIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            return this.hasNext.hasNext();
        }

        @Override
        public V next() {
            if (this.inputIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            if (!this.hasNext.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.clearNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            this.inputIt = TranslatingSequence.this.getInput().iterator();
        }

        private void moveToNext() {
            this.hasNext = HasNextState.AT_END;
            this.next = null;
            while (true) {
                try {
                    if (this.transIt != null && this.transIt.hasNext()) {
                        Object tmp = this.transIt.next();
                        this.next = tmp;
                        this.hasNext = HasNextState.HAS_NEXT;
                    }
                }
                catch (StopIteratingException stop) {}
                break;
                if (!this.inputIt.hasNext()) break;
                try {
                    NullSequence transSeq = (NullSequence)TranslatingSequence.this.translator.invoke(this.inputIt.next());
                    if (transSeq == null) {
                        transSeq = NullSequence.instance();
                    }
                    this.transIt = transSeq.iterator();
                }
                catch (StopIteratingException illegal) {
                    throw new IllegalStateException((Throwable)((Object)illegal));
                }
            }
        }

        private V clearNext() {
            Object tmp = this.next;
            this.next = null;
            this.hasNext = HasNextState.UNKNOWN;
            return tmp;
        }
    }
}

