/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.dates.runtime;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.Constants;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.MutableDateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritableInstant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;

public class DateTimeOperations {
    @Deprecated
    private static InheritableThreadLocal<DateTimeZone> currentZone = new InheritableThreadLocal<DateTimeZone>(){

        @Override
        protected DateTimeZone initialValue() {
            return DateTimeZone.getDefault();
        }
    };

    private DateTimeOperations() {
    }

    @Deprecated
    public static String print(Long datetime, DateTimeFormatter formatter) {
        return formatter.print((ReadableInstant)(datetime != null ? new DateTime((Object)datetime, (DateTimeZone)currentZone.get()) : Constants.NULL_DATE_TIME));
    }

    @Deprecated
    public static String print(Long datetime, DateTimeFormatter formatter, Locale locale) {
        return DateTimeOperations.print(datetime, formatter.withLocale(locale));
    }

    @Deprecated
    public static String print(Long value, DateTimeFormatter formatter, Locale locale, DateTimeZone zone) {
        DateTime dateTime = value != null ? (zone != null ? new DateTime((Object)value, zone) : new DateTime((Object)value, (DateTimeZone)currentZone.get())) : Constants.NULL_DATE_TIME;
        DateTimeFormatter dateTimeFormatter = locale == null ? formatter : formatter.withLocale(locale);
        return dateTimeFormatter.print((ReadableInstant)dateTime);
    }

    public static String print(DateTime value, DateTimeFormatter formatter, Locale locale) {
        DateTime dateTime = value != null ? value : Constants.NULL_DATE_TIME;
        DateTimeFormatter dateTimeFormatter = locale == null ? formatter : formatter.withLocale(locale);
        return dateTimeFormatter.print((ReadableInstant)dateTime);
    }

    public static String print(Period value, PeriodFormatter formatter, Locale locale) {
        Period period = value != null ? value : new Period();
        PeriodFormatter dateTimeFormatter = locale == null ? formatter : formatter.withLocale(locale);
        return dateTimeFormatter.print((ReadablePeriod)period);
    }

    @Deprecated
    public static String print(Period period, DateTimeFormatter formatter, Locale locale, DateTimeZone zone) {
        return DateTimeOperations.print(DateTimeOperations.convert(period), formatter, locale, zone);
    }

    public static DateTime convert(Long l, DateTimeZone zone) {
        return l != null ? new DateTime((Object)l, zone) : null;
    }

    public static Long convert(DateTime dateTime) {
        return dateTime != null ? Long.valueOf(dateTime.getMillis()) : null;
    }

    public static Long convert(Date date) {
        return date != null ? Long.valueOf(date.getTime()) : null;
    }

    public static Long convert(Calendar calendar) {
        return calendar != null ? Long.valueOf(calendar.getTimeInMillis()) : null;
    }

    public static Long convert(Period period) {
        return period != null ? Long.valueOf(period.toStandardDuration().getMillis()) : null;
    }

    public static Long convert(Duration period) {
        return period != null ? Long.valueOf(period.getMillis()) : null;
    }

    public static Duration toDuration(Period p) {
        return p != null ? p.toStandardDuration() : null;
    }

    @Deprecated
    public static Long parse(String datetimeString, DateTimeFormatter formatter, Locale locale, DateTimeZone zone, Long defValues) {
        if (zone == null) {
            zone = (DateTimeZone)currentZone.get();
        }
        if (locale != null) {
            formatter = formatter.withLocale(locale);
        }
        if (zone != null) {
            formatter = formatter.withZone(zone);
        }
        try {
            if (defValues != null) {
                MutableDateTime mdt = new MutableDateTime(defValues != null ? defValues : 0L);
                int res = (formatter = formatter.withDefaultYear(mdt.getYear())).parseInto((ReadWritableInstant)mdt, datetimeString, 0);
                if (res <= 0) {
                    throw new IllegalArgumentException(datetimeString);
                }
                return DateTimeOperations.convert(mdt.toDateTime());
            }
            DateTime dt = formatter.parseDateTime(datetimeString);
            return DateTimeOperations.convert(dt);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Error parsing date/time (" + iae.getMessage() + ")");
        }
        catch (UnsupportedOperationException uoe) {
            throw new IllegalArgumentException("Error parsing date/time (" + uoe.getMessage() + ")");
        }
    }

    public static DateTime parseDateTime(String datetimeString, DateTimeFormatter formatter, DateTimeZone zone, Locale locale, DateTime defValue) {
        if (locale != null) {
            formatter = formatter.withLocale(locale);
        }
        formatter = formatter.withZone(zone);
        try {
            if (defValue != null) {
                MutableDateTime mdt = new MutableDateTime((Object)defValue);
                int res = (formatter = formatter.withDefaultYear(mdt.getYear())).parseInto((ReadWritableInstant)mdt, datetimeString, 0);
                if (res <= 0) {
                    throw new IllegalArgumentException(datetimeString);
                }
                return mdt.toDateTime();
            }
            return formatter.parseDateTime(datetimeString);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Error parsing date/time (" + iae.getMessage() + ")");
        }
        catch (UnsupportedOperationException uoe) {
            throw new IllegalArgumentException("Error parsing date/time (" + uoe.getMessage() + ")");
        }
    }

    @Deprecated
    public static boolean compare(Long op1, CompareType cmp, Long op2, DateTimeFieldType type) {
        op1 = DateTimeOperations.roundFloor(op1, type);
        op2 = DateTimeOperations.roundFloor(op2, type);
        if (op1 == null) {
            op1 = Long.MIN_VALUE;
        }
        if (op2 == null) {
            op2 = Long.MIN_VALUE;
        }
        return DateTimeOperations.compareResult(op1.compareTo(op2), cmp);
    }

    public static boolean compare(DateTime op1, CompareType cmp, DateTime op2, DateTimeFieldType type) {
        DateTimeComparator dtc;
        DateTimeComparator dateTimeComparator = dtc = type != null ? DateTimeComparator.getInstance((DateTimeFieldType)type) : DateTimeComparator.getInstance();
        int compareValue = op1 == null ? (op2 != null ? -1 : 0) : (op2 != null ? dtc.compare((Object)op1, (Object)op2) : 1);
        return DateTimeOperations.compareResult(compareValue, cmp);
    }

    @Deprecated
    public static Long roundFloor(Long datetime, DateTimeFieldType type) {
        return datetime != null ? Long.valueOf(new DateTime((Object)datetime, (DateTimeZone)currentZone.get()).property(type).roundFloorCopy().getMillis()) : null;
    }

    public static DateTime roundFloor(DateTime datetime, DateTimeFieldType type) {
        return datetime != null ? datetime.property(type).roundFloorCopy() : null;
    }

    @Deprecated
    public static Long roundCeiling(Long datetime, DateTimeFieldType type) {
        return datetime != null ? Long.valueOf(new DateTime((Object)datetime, (DateTimeZone)currentZone.get()).property(type).roundCeilingCopy().getMillis()) : null;
    }

    public static DateTime roundCeiling(DateTime datetime, DateTimeFieldType type) {
        return datetime != null ? datetime.property(type).roundCeilingCopy() : null;
    }

    @Deprecated
    public static Long round(Long datetime, DateTimeFieldType type) {
        return datetime != null ? Long.valueOf(new DateTime((Object)datetime, (DateTimeZone)currentZone.get()).property(type).roundHalfCeilingCopy().getMillis()) : null;
    }

    public static DateTime round(DateTime datetime, DateTimeFieldType type) {
        return datetime != null ? datetime.property(type).roundHalfCeilingCopy() : null;
    }

    @Deprecated
    public static Integer get(Long datetime, DateTimeFieldType type) {
        return datetime != null ? Integer.valueOf(new DateTime((Object)datetime, (DateTimeZone)currentZone.get()).property(type).get()) : null;
    }

    public static Integer get(DateTime datetime, DateTimeFieldType type) {
        return datetime != null ? Integer.valueOf(datetime.property(type).get()) : null;
    }

    @Deprecated
    public static Long with(Long datetime, DateTimeFieldType type, int value) {
        return datetime != null ? Long.valueOf(new DateTime((Object)datetime, (DateTimeZone)currentZone.get()).property(type).setCopy(value).getMillis()) : null;
    }

    public static DateTime with(DateTime datetime, DateTimeFieldType type, int value) {
        return datetime != null ? datetime.property(type).setCopy(value) : null;
    }

    @Deprecated
    public static Period plus(Period leftExpression, Period rightExpression) {
        if (leftExpression == null) {
            leftExpression = Period.ZERO;
        }
        if (rightExpression == null) {
            rightExpression = Period.ZERO;
        }
        return new Period(leftExpression.getYears() + rightExpression.getYears(), leftExpression.getMonths() + rightExpression.getMonths(), leftExpression.getWeeks() + rightExpression.getWeeks(), leftExpression.getDays() + rightExpression.getDays(), leftExpression.getHours() + rightExpression.getHours(), leftExpression.getMinutes() + rightExpression.getMinutes(), leftExpression.getSeconds() + rightExpression.getSeconds(), leftExpression.getMillis() + rightExpression.getMillis());
    }

    @Deprecated
    public static Period minus(Period leftExpression, Period rightExpression) {
        if (leftExpression == null) {
            leftExpression = Period.ZERO;
        }
        if (rightExpression == null) {
            rightExpression = Period.ZERO;
        }
        return new Period(leftExpression.getYears() - rightExpression.getYears(), leftExpression.getMonths() - rightExpression.getMonths(), leftExpression.getWeeks() - rightExpression.getWeeks(), leftExpression.getDays() - rightExpression.getDays(), leftExpression.getHours() - rightExpression.getHours(), leftExpression.getMinutes() - rightExpression.getMinutes(), leftExpression.getSeconds() - rightExpression.getSeconds(), leftExpression.getMillis() - rightExpression.getMillis());
    }

    @Deprecated
    public static Long plus(Long leftExpression, Period rightExpression) {
        Long result = leftExpression == null ? null : Long.valueOf(new DateTime((Object)leftExpression, (DateTimeZone)currentZone.get()).plus((ReadablePeriod)rightExpression).getMillis());
        return result;
    }

    @Deprecated
    public static Long plus(Period left, Long right) {
        return DateTimeOperations.plus(right, left);
    }

    @Deprecated
    public static Long plus(Long left, Long right) {
        return left + right;
    }

    @Deprecated
    public static Period minus(Long left, Long right) {
        return new Period(right.longValue(), left.longValue());
    }

    @Deprecated
    public static Long minus(Long leftExpression, Period rightExpression) {
        Long result = leftExpression == null ? null : Long.valueOf(new DateTime((Object)leftExpression, (DateTimeZone)currentZone.get()).minus((ReadablePeriod)rightExpression).getMillis());
        return result;
    }

    @Deprecated
    public static Period minus(Long leftExpression, Long rightExpression, PeriodType periodType) {
        Period result = leftExpression == null || rightExpression == null ? null : new Period(rightExpression.longValue(), leftExpression.longValue(), periodType);
        return result;
    }

    @Deprecated
    public static Period absMinus(Long leftExpression, Long rightExpression, PeriodType periodType) {
        Period result = leftExpression == null || rightExpression == null ? null : new Period(Math.min(leftExpression, rightExpression), Math.max(leftExpression, rightExpression), periodType);
        return result;
    }

    public static Long never() {
        return null;
    }

    public static boolean compare(Duration op1, CompareType cmp, Period op2) {
        return DateTimeOperations.compare(op1, cmp, op2 != null ? op2.toStandardDuration() : null);
    }

    public static boolean compare(Period op1, CompareType cmp, Duration op2) {
        return DateTimeOperations.compare(op1 != null ? op1.toStandardDuration() : null, cmp, op2);
    }

    public static boolean compare(Long op1, CompareType cmp, Period op2) {
        return DateTimeOperations.compare(op1 != null ? new Duration((Object)op1) : null, cmp, op2 != null ? op2.toStandardDuration() : null);
    }

    public static boolean compare(Period op1, CompareType cmp, Long op2) {
        return DateTimeOperations.compare(op1 != null ? op1.toStandardDuration() : null, cmp, op2 != null ? new Duration((Object)op2) : null);
    }

    public static boolean compare(Long op1, CompareType cmp, Duration op2) {
        return DateTimeOperations.compare(op1 != null ? new Duration((Object)op1) : null, cmp, op2);
    }

    public static boolean compare(Duration op1, CompareType cmp, Long op2) {
        return DateTimeOperations.compare(op1, cmp, op2 != null ? new Duration((Object)op2) : null);
    }

    public static boolean compare(Period op1, CompareType cmp, Period op2) {
        DateTime now = new DateTime((DateTimeZone)currentZone.get());
        int compareValue = op1 == null ? (op2 != null ? -1 : 0) : (op2 != null ? op1.toDurationFrom((ReadableInstant)now).compareTo((ReadableDuration)op2.toDurationFrom((ReadableInstant)now)) : 1);
        return DateTimeOperations.compareResult(compareValue, cmp);
    }

    public static boolean compare(Duration op1, CompareType cmp, Duration op2) {
        int compareValue = op1 == null ? (op2 != null ? -1 : 0) : (op2 != null ? op1.compareTo((ReadableDuration)op2) : 1);
        return DateTimeOperations.compareResult(compareValue, cmp);
    }

    private static boolean compareResult(int compareValue, CompareType kind) {
        boolean result;
        switch (kind) {
            case EQ: {
                result = compareValue == 0;
                break;
            }
            case NE: {
                result = compareValue != 0;
                break;
            }
            case LT: {
                result = compareValue < 0;
                break;
            }
            case GT: {
                result = compareValue > 0;
                break;
            }
            case LE: {
                result = compareValue <= 0;
                break;
            }
            case GE: {
                result = compareValue >= 0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported compare type: " + (Object)((Object)kind));
            }
        }
        return result;
    }

    @Deprecated
    public static boolean equals(Period leftExpression, Period rightExpression) {
        boolean result;
        if (leftExpression == null || rightExpression == null) {
            result = leftExpression == rightExpression;
        } else {
            DateTime now = new DateTime((DateTimeZone)currentZone.get());
            result = leftExpression.toDurationFrom((ReadableInstant)now).equals((Object)rightExpression.toDurationFrom((ReadableInstant)now));
        }
        return result;
    }

    @Deprecated
    public static boolean less(Period leftExpression, Period rightExpression) {
        if (leftExpression == null || rightExpression == null) {
            throw new NullPointerException("Operands shouldn't be null");
        }
        DateTime now = new DateTime((DateTimeZone)currentZone.get());
        boolean result = leftExpression.toDurationFrom((ReadableInstant)now).compareTo((ReadableDuration)rightExpression.toDurationFrom((ReadableInstant)now)) < 0;
        return result;
    }

    public static boolean isNull(Long datetime) {
        return datetime == null;
    }

    public static boolean isNotNull(Long datetime) {
        return datetime != null;
    }

    public static boolean isNull(DateTime datetime) {
        return datetime == null;
    }

    public static boolean isNotNull(DateTime datetime) {
        return datetime != null;
    }

    public static boolean isNull(long datetime) {
        return false;
    }

    public static boolean isNotNull(long datetime) {
        return true;
    }

    @Deprecated
    public static void withTimeZone(DateTimeZone tz) {
        currentZone.set(tz);
    }

    @Deprecated
    public static DateTimeZone getCurrentTimeZone() {
        return (DateTimeZone)currentZone.get();
    }
}

