/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.dates.runtime.printer;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import jetbrains.mps.baseLanguage.dates.runtime.printer.Printer;
import org.joda.time.DateTime;

public class CompositePrinter
implements Printer {
    private List<Printer> myPrinters = new LinkedList<Printer>();
    private int myEstimatedPrintLength = -1;

    @Override
    public int estimatePrintedLength() {
        if (this.myEstimatedPrintLength < 0) {
            this.myEstimatedPrintLength = 0;
            for (Printer printer : this.myPrinters) {
                this.myEstimatedPrintLength += printer.estimatePrintedLength();
            }
        }
        return this.myEstimatedPrintLength;
    }

    public void add(Printer printer) {
        this.myEstimatedPrintLength = -1;
        this.myPrinters.add(printer);
    }

    @Override
    public void printTo(Appendable out, DateTime dateTime, Locale locale) throws IOException {
        for (Printer printer : this.myPrinters) {
            printer.printTo(out, dateTime, locale);
        }
    }
}

