/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.dates.runtime.printer;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import jetbrains.mps.baseLanguage.dates.runtime.printer.Printer;
import org.joda.time.DateTime;

public abstract class ConditionalPrinter
implements Printer {
    private int myEstimatedPrintLength = -1;

    @Override
    public int estimatePrintedLength() {
        if (this.myEstimatedPrintLength < 0) {
            this.myEstimatedPrintLength = 0;
            for (Printer printer : this.getAllPrinters()) {
                this.myEstimatedPrintLength = Math.max(this.myEstimatedPrintLength, printer.estimatePrintedLength());
            }
            return this.myEstimatedPrintLength;
        }
        return this.myEstimatedPrintLength;
    }

    @Override
    public void printTo(Appendable out, DateTime dateTime, Locale locale) throws IOException {
        Printer printer = this.getAllPrinters().get(this.getPrinterIndex(dateTime, locale));
        printer.printTo(out, dateTime, locale);
    }

    protected abstract int getPrinterIndex(DateTime var1, Locale var2);

    protected abstract List<Printer> getAllPrinters();
}

