/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import com.jetbrains.service.util.SystemUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum VirtualHostsDefault {
    NONE("none"){

        @Override
        public Set<String> getVirtualHosts(@NotNull String listenAddress) {
            return Collections.emptySet();
        }
    }
    ,
    LOCAL("local"){

        @Override
        public Set<String> getVirtualHosts(@NotNull String listenAddress) {
            HashSet<String> vHosts = new HashSet<String>();
            vHosts.add("127.0.0.1");
            vHosts.add("localhost");
            vHosts.add(listenAddress);
            vHosts.addAll(SystemUtil.getLocalHostNames(true, true));
            try {
                Map<NetworkInterface, List<InetAddress>> resolvedNetworkInterfaces = SystemUtil.resolveKnownNetInterfaces();
                for (NetworkInterface ifc : resolvedNetworkInterfaces.keySet()) {
                    if (!ifc.isLoopback()) continue;
                    for (InetAddress address : resolvedNetworkInterfaces.get(ifc)) {
                        VirtualHostsDefault.addFromAddress(vHosts, address);
                    }
                }
            }
            catch (IOException e) {
                VirtualHostsDefault.getLogger().debug("Failed adding loopback network interfaces to the list of virtual hosts", (Throwable)e);
            }
            return vHosts;
        }
    }
    ,
    ALL_KNOWN("all-known"){

        @Override
        public Set<String> getVirtualHosts(@NotNull String listenAddress) {
            HashSet<String> vHosts = new HashSet<String>();
            vHosts.addAll(LOCAL.getVirtualHosts(listenAddress));
            try {
                Map<NetworkInterface, List<InetAddress>> resolvedNetworkInterfaces = SystemUtil.resolveKnownNetInterfaces();
                for (NetworkInterface ifc : resolvedNetworkInterfaces.keySet()) {
                    if (!ifc.isUp()) continue;
                    for (InetAddress address : resolvedNetworkInterfaces.get(ifc)) {
                        VirtualHostsDefault.addFromAddress(vHosts, address);
                    }
                }
            }
            catch (IOException e) {
                VirtualHostsDefault.getLogger().debug("Failed adding network interfaces to the list of virtual hosts", (Throwable)e);
            }
            return vHosts;
        }
    };

    @NotNull
    private final String name;

    private VirtualHostsDefault(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public abstract Set<String> getVirtualHosts(@NotNull String var1);

    public static VirtualHostsDefault fromName(String name) {
        for (VirtualHostsDefault vhd : VirtualHostsDefault.values()) {
            if (!vhd.getName().equals(name)) continue;
            return vhd;
        }
        return null;
    }

    public static Collection<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (VirtualHostsDefault vhd : VirtualHostsDefault.values()) {
            names.add(vhd.getName());
        }
        return names;
    }

    private static void addFromAddress(Set<String> hosts, InetAddress address) {
        hosts.add(address.getHostName());
        hosts.add(address.getHostAddress());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VirtualHostsDefault.class);
    }
}

