/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;

public class CompositeX509TrustManager
implements X509TrustManager {
    private final List<X509TrustManager> trustManagers;
    private X509Certificate[] lastCheckedChain;

    public CompositeX509TrustManager(@NotNull X509TrustManager[] trustManagers) {
        this.trustManagers = new ArrayList<X509TrustManager>(trustManagers.length);
        this.trustManagers.addAll(Arrays.asList(trustManagers));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.lastCheckedChain = chain;
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                if (this.trustManagers.size() != 1) continue;
                throw e;
            }
        }
        throw new CertificateException("Cannot build trusted certificates chain");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.lastCheckedChain = chain;
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                if (this.trustManagers.size() != 1) continue;
                throw e;
            }
        }
        throw new CertificateException("Cannot build trusted certificates chain");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (X509TrustManager trustManager : this.trustManagers) {
            certificates.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
        }
        return certificates.isEmpty() ? null : certificates.toArray(new X509Certificate[0]);
    }

    public X509Certificate[] getLastCheckedChain() {
        return this.lastCheckedChain;
    }

    public void resetLastCheckedChain() {
        this.lastCheckedChain = null;
    }

    public List<X509TrustManager> getTrustManagers() {
        return Collections.unmodifiableList(this.trustManagers);
    }
}

