/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.update;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jetbrains.jetpass.api.settings.UpdateStatus;
import jetbrains.jetpass.update.Build;
import jetbrains.jetpass.update.Channel;
import jetbrains.jetpass.update.Product;
import jetbrains.jetpass.update.Update;
import jetbrains.jetpass.update.UpdateCheckException;
import jetbrains.jetpass.update.UpdateChecker;
import jetbrains.jetpass.update.UpdateJsonLoader;
import jetbrains.jetpass.update.UpdateJsonParser;
import jetbrains.ring.license.License;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0011J\u0006\u0010!\u001a\u00020\u0011J\n\u0010\"\u001a\u00020\u0014*\u00020\u0003R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Ljetbrains/jetpass/update/UpdateChecker;", "", "code", "", "loader", "Ljetbrains/jetpass/update/UpdateJsonLoader;", "parser", "Ljetbrains/jetpass/update/UpdateJsonParser;", "(Ljava/lang/String;Ljetbrains/jetpass/update/UpdateJsonLoader;Ljetbrains/jetpass/update/UpdateJsonParser;)V", "buildDateFormatPattern", "getCode", "()Ljava/lang/String;", "getLoader", "()Ljetbrains/jetpass/update/UpdateJsonLoader;", "getParser", "()Ljetbrains/jetpass/update/UpdateJsonParser;", "available", "Ljetbrains/jetpass/api/settings/UpdateStatus;", "message", "date", "Ljava/util/Calendar;", "downloadUrl", "free", "", "check", "uuid", "currentChannel", "Ljetbrains/jetpass/update/Channel;", "currentBuild", "Ljetbrains/jetpass/update/Build;", "license", "Ljetbrains/ring/license/License;", "fail", "nothingFoundToUpdate", "parseDate", "Companion", "jetbrains.jetpass.update"})
public final class UpdateChecker {
    private String buildDateFormatPattern;
    @NotNull
    private final String code;
    @NotNull
    private final UpdateJsonLoader loader;
    @NotNull
    private final UpdateJsonParser parser;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final UpdateStatus check(@NotNull String uuid, @NotNull Channel currentChannel, @NotNull Build currentBuild, @NotNull License license) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        Intrinsics.checkParameterIsNotNull((Object)((Object)currentChannel), (String)"currentChannel");
        Intrinsics.checkParameterIsNotNull((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        try {
            Update update;
            Product product;
            Object v0;
            block8: {
                byte[] responseBytes = this.loader.load(uuid, currentBuild, license);
                List<Product> products = this.parser.parse(responseBytes);
                Iterable $receiver$iv = products;
                for (Object element$iv : $receiver$iv) {
                    Product it = (Product)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getCode(), (Object)this.code)) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            Product product2 = product = (Product)v0;
            Update update2 = update = product2 != null ? product2.findNewerUpdate(currentChannel, currentBuild) : null;
            if (update != null) {
                String string = update.getMessage();
                if (string == null) {
                    throw (Throwable)new UpdateCheckException("Cannot parser information about update build. Message is missing from update " + update, null, 2, null);
                }
                String message = string;
                String string2 = update.getDate();
                if (string2 == null) {
                    throw (Throwable)new UpdateCheckException("Cannot parser information about update build. Date is missing from update " + update, null, 2, null);
                }
                String date = string2;
                String string3 = update.getUrl();
                if (string3 == null) {
                    throw (Throwable)new UpdateCheckException("Cannot parser information about update build. URL is missing from update " + update, null, 2, null);
                }
                String url = string3;
                Calendar calendar = this.parseDate(date);
                return this.available(message, calendar, url, license.getUpgradeExpirationTime() > calendar.getTimeInMillis());
            }
            return this.nothingFoundToUpdate();
        }
        catch (UpdateCheckException e) {
            if (Companion.getLogger().isWarnEnabled()) {
                Companion.getLogger().warn(e.getMessage(), (Throwable)e);
            }
            UpdateStatus updateStatus = this.fail();
            return updateStatus;
        }
    }

    @NotNull
    public final UpdateStatus nothingFoundToUpdate() {
        return new UpdateStatus(){

            public boolean isSucceed() {
                return true;
            }

            @Nullable
            public Void getUpdate() {
                return null;
            }
        };
    }

    @NotNull
    public final UpdateStatus available(@NotNull String message, @NotNull Calendar date, @NotNull String downloadUrl, boolean free) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)downloadUrl, (String)"downloadUrl");
        return new UpdateStatus(message, downloadUrl, date, free){
            final /* synthetic */ String $message;
            final /* synthetic */ String $downloadUrl;
            final /* synthetic */ Calendar $date;
            final /* synthetic */ boolean $free;

            public boolean isSucceed() {
                return true;
            }

            @NotNull
            public available.getUpdate.1 getUpdate() {
                return new UpdateStatus.Update(this){
                    final /* synthetic */ available.1 this$0;

                    @NotNull
                    public String getMessage() {
                        return this.this$0.$message;
                    }

                    @NotNull
                    public String getDownloadUrl() {
                        return this.this$0.$downloadUrl;
                    }

                    @NotNull
                    public Calendar getDate() {
                        return this.this$0.$date;
                    }

                    public boolean isFree() {
                        return this.this$0.$free;
                    }
                    {
                        this.this$0 = $outer;
                    }
                };
            }
            {
                this.$message = $captured_local_variable$0;
                this.$downloadUrl = $captured_local_variable$1;
                this.$date = $captured_local_variable$2;
                this.$free = $captured_local_variable$3;
            }
        };
    }

    @NotNull
    public final UpdateStatus fail() {
        return new UpdateStatus(){

            public boolean isSucceed() {
                return false;
            }

            @Nullable
            public Void getUpdate() {
                return null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Calendar parseDate(@NotNull String $receiver) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            Calendar calendar;
            Calendar calendar2 = calendar = Calendar.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
            Date date = new SimpleDateFormat(this.buildDateFormatPattern).parse($receiver);
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"SimpleDateFormat(buildDa\u2026ormatPattern).parse(this)");
            calendar2.setTimeInMillis(date.getTime());
        }
        catch (Exception e) {
            throw (Throwable)new UpdateCheckException("Cannot parse information about update build date. Was trying to parse " + $receiver + " against format " + this.buildDateFormatPattern, e);
        }
        return var2_2;
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @NotNull
    public final UpdateJsonLoader getLoader() {
        return this.loader;
    }

    @NotNull
    public final UpdateJsonParser getParser() {
        return this.parser;
    }

    public UpdateChecker(@NotNull String code, @NotNull UpdateJsonLoader loader, @NotNull UpdateJsonParser parser) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)loader, (String)"loader");
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        this.code = code;
        this.loader = loader;
        this.parser = parser;
        this.buildDateFormatPattern = "dd-MM-yyyy";
    }

    public /* synthetic */ UpdateChecker(String string, UpdateJsonLoader updateJsonLoader, UpdateJsonParser updateJsonParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            updateJsonLoader = new UpdateJsonLoader(null, 1, null);
        }
        if ((n & 4) != 0) {
            updateJsonParser = new UpdateJsonParser();
        }
        this(string, updateJsonLoader, updateJsonParser);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/update/UpdateChecker$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.update"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

