/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.cache;

import java.util.Map;
import jetbrains.charisma.persistence.user.BaseUserPermissionsCacheData;
import jetbrains.charisma.persistence.user.ProjectCustomFieldsSnapshot;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.dao.api.permissionCache.Handler;
import jetbrains.jetpass.dao.api.permissionCache.StringInterner;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.persistent.XdSuperUser;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.cache.HubPermissionsData;
import jetbrains.youtrack.ring.cache.SuperUserHubPermissionsData;
import jetbrains.youtrack.ring.client.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/ring/cache/HubPermissionsCacheData;", "Ljetbrains/charisma/persistence/user/BaseUserPermissionsCacheData;", "interner", "Ljetbrains/jetpass/dao/api/permissionCache/StringInterner;", "(Ljetbrains/jetpass/dao/api/permissionCache/StringInterner;)V", "Companion", "youtrack-ring-integration"})
public final class HubPermissionsCacheData
extends BaseUserPermissionsCacheData {
    public static final Companion Companion = new Companion(null);

    public HubPermissionsCacheData(@NotNull StringInterner interner) {
        SuperUserHubPermissionsData superUserHubPermissionsData;
        Intrinsics.checkParameterIsNotNull((Object)interner, (String)"interner");
        Companion.getLogger().debug("Rebuilding Hub-based custom field permission cache...");
        long time = System.currentTimeMillis();
        ProjectCustomFieldsSnapshot pcfSnapshot = new ProjectCustomFieldsSnapshot();
        int counter = 0;
        for (XdUser user2 : HelpersKt.asIterable((XdQuery)XdUser.Companion.all())) {
            try {
                Object v;
                String ringUserId = EntityExtensionsKt.getHubUuid((XdEntity)user2);
                if (ringUserId == null) {
                    if (user2.isService() || user2.isSystem()) continue;
                    Companion.getLogger().error("User " + user2.getLogin() + " is not associated with hub.");
                    continue;
                }
                ++counter;
                User ringUser = (User)BeansKt.getRingApi().getUserDAO().get(ringUserId);
                if (ringUser == null) {
                    Companion.getLogger().error("User " + user2.getLogin() + " has ring id " + ringUserId + " unknown to Hub");
                    continue;
                }
                Handler handle = new Handler(ringUser, interner);
                if (this.permissions.containsKey(handle)) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)this.userPermissions, (String)"userPermissions");
                    v = this.permissions.get(handle);
                    superUserHubPermissionsData.put(ringUserId, v);
                    continue;
                }
                HubPermissionsData data = new HubPermissionsData(ringUserId, pcfSnapshot);
                Intrinsics.checkExpressionValueIsNotNull((Object)this.userPermissions, (String)"userPermissions");
                HubPermissionsData hubPermissionsData = data;
                v.put((String)ringUserId, (HubPermissionsData)hubPermissionsData);
                this.permissions.put(handle, data);
            }
            catch (Exception e) {
                Companion.getLogger().warn("Failed to build permission cache record for user " + EntityExtensionsKt.getHubUuid((XdEntity)user2), (Throwable)e);
            }
        }
        SuperUserHubPermissionsData superUserData = new SuperUserHubPermissionsData(pcfSnapshot);
        for (XdSuperUser superUser : XdQueryKt.toList((XdQuery)XdSuperUser.Companion.all())) {
            Map map;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.userPermissions, (String)"userPermissions");
            String string = this.getUserKey(superUser.getEntity());
            superUserHubPermissionsData = superUserData;
            map.put(string, superUserHubPermissionsData);
        }
        Companion.getLogger().info("Custom field permission cache for " + counter + " users built in " + (System.currentTimeMillis() - time) + " ms");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/cache/HubPermissionsCacheData$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

