/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.VCSUserName;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.dao.remote.api.authority.RemoteUserDetailsDAO;
import jetbrains.jetpass.importing.client.ImportClient;
import jetbrains.jetpass.importing.client.UsersImportClient;
import jetbrains.jetpass.importing.dto.json.ItemJSON;
import jetbrains.jetpass.importing.dto.json.UserBundleJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.VcsUserNameJSON;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.export.BeansKt;
import jetbrains.youtrack.ring.export.adapter.UserHubSyncAdapter;
import jetbrains.youtrack.ring.export.dto.HubDtoBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018J\u0016\u0010\u0019\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/ring/export/HubUserExporter;", "", "adapter", "Ljetbrains/youtrack/ring/export/adapter/UserHubSyncAdapter;", "dtoBuilder", "Ljetbrains/youtrack/ring/export/dto/HubDtoBuilder;", "Ljetbrains/youtrack/persistent/XdUser;", "Ljetbrains/jetpass/rest/dto/UserJSON;", "(Ljetbrains/youtrack/ring/export/adapter/UserHubSyncAdapter;Ljetbrains/youtrack/ring/export/dto/HubDtoBuilder;)V", "getAdapter", "()Ljetbrains/youtrack/ring/export/adapter/UserHubSyncAdapter;", "importClient", "Ljetbrains/jetpass/importing/client/UsersImportClient;", "ringUsers", "Ljava/util/HashMap;", "", "userClient", "Ljetbrains/jetpass/client/accounts/UserClient;", "cleanupVcsUserNames", "", "mergedUser", "Ljetbrains/jetpass/api/authority/User;", "export", "items", "", "exportBatch", "", "getDefaultHubAdmin", "mergeYouTrackRootWithHubAdmin", "preloadRingUsers", "Companion", "youtrack-ring-integration"})
public final class HubUserExporter {
    private final UsersImportClient importClient;
    private final UserClient userClient;
    private final HashMap<String, String> ringUsers;
    @NotNull
    private final UserHubSyncAdapter adapter;
    private final HubDtoBuilder<XdUser, UserJSON> dtoBuilder;
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    public final void export(@NotNull Iterable<? extends XdUser> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        var4_4 = $receiver$iv = items;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (XdUser)element$iv$iv;
            $i$a$-filter-HubUserExporter$export$users$1 = false;
            if (!(this.adapter.isExported((XdEntity)it) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        users = (List)destination$iv$iv;
        $receiver$iv = users;
        if ($receiver$iv.isEmpty() == false) {
            this.preloadRingUsers();
        }
        try {
            defaultAdmin = this.getDefaultHubAdmin();
            if (defaultAdmin == null) ** GOTO lbl-1000
            v0 = jetbrains.youtrack.ring.impl.BeansKt.getHubSecurity().getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"hubSecurity.root");
            if (!this.adapter.isExported(XdExtensionsKt.toXd((Entity)v0))) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            firstExport = v1;
            batch = new ArrayList<XdUser>(250);
            $receiver$iv = users;
            for (T element$iv : $receiver$iv) {
                it = (XdUser)element$iv;
                $i$a$-forEach-HubUserExporter$export$1 = false;
                if (this.ringUsers.containsKey(it.getLogin())) {
                    v2 = this.ringUsers.get(it.getLogin());
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"ringUsers[it.login]!!");
                    this.adapter.linkUserWithHub(it, v2);
                    continue;
                }
                if (batch.size() == 250) {
                    this.exportBatch((List<? extends XdUser>)batch);
                    batch.clear();
                }
                batch.add(it);
            }
            if (batch.size() > 0) {
                this.exportBatch((List<? extends XdUser>)batch);
            }
            if (firstExport) {
                this.mergeYouTrackRootWithHubAdmin();
            }
        }
        catch (Exception e) {
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Unable to export users into hub", e);
        }
    }

    private final void exportBatch(List<? extends XdUser> items) {
        UserBundleJSON bundle = new UserBundleJSON();
        ArrayList<UserJSON> jsonList = new ArrayList<UserJSON>(items.size());
        ArrayList<XdUser> forExport = new ArrayList<XdUser>(items.size());
        for (XdUser xdUser : items) {
            UserJSON userDto = this.dtoBuilder.build(xdUser);
            userDto.setDetails(BeansKt.getUserDetailJsonBuilder().getUserDetails(xdUser));
            jsonList.add(userDto);
            forExport.add(xdUser);
        }
        bundle.setUsers((List)jsonList);
        try {
            List list = this.importClient.post(bundle).getItems();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            Iterator iterator2 = list.iterator();
            boolean $i$f$transactional = false;
            TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(forExport, iterator2){
                final /* synthetic */ ArrayList $forExport$inlined;
                final /* synthetic */ Iterator $ids$inlined;
                {
                    this.$forExport$inlined = arrayList;
                    this.$ids$inlined = iterator2;
                    super(1);
                }

                public final Unit invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    boolean bl = false;
                    Iterable $receiver$iv = this.$forExport$inlined;
                    for (T element$iv : $receiver$iv) {
                        XdUser user2 = (XdUser)element$iv;
                        boolean bl2 = false;
                        ItemJSON result = (ItemJSON)this.$ids$inlined.next();
                        if (result.getId() == null) {
                            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Can't export user " + user2.getLogin() + " to Hub. Error message: " + result.getMessage());
                            continue;
                        }
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("Exported user " + user2.getLogin() + " with UUID " + result.getId());
                        EntityExtensionsKt.setHubUuid((XdEntity)user2, result.getId());
                    }
                    LegacySupportKt.flush();
                    return Unit.INSTANCE;
                }
            }), (int)7, null);
        }
        catch (WebApplicationException webApplicationException) {
            Companion.getLogger().warn("Batch user export failed: " + (String)webApplicationException.getResponse().readEntity(String.class), (Throwable)webApplicationException);
        }
    }

    private final void preloadRingUsers() {
        Collection collection;
        Partial partial = Partial.user((Partial.User[])new Partial.User[]{Partial.User.ID, Partial.User.LOGIN});
        Filter filter = new Filter(null, 1, null);
        int top = 1000;
        int skip = 0;
        filter.top(top);
        List users = null;
        do {
            filter.skip(skip);
            users = this.userClient.getUserPage((BaseFilter)filter, (FieldPartial)partial).getItems();
            skip += top;
            for (UserJSON ringUser : users) {
                String string;
                String string2;
                Map map = this.ringUsers;
                if (ringUser.getLogin() == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ringUser.login!!");
                if (ringUser.getId() == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ringUser.id!!");
                map.put(string2, string);
            }
        } while (!(collection = (Collection)users).isEmpty());
    }

    private final void mergeYouTrackRootWithHubAdmin() {
        UserJSON defaultAdmin = this.getDefaultHubAdmin();
        if (defaultAdmin != null) {
            Companion.getLogger().debug("Merging YT root with Hub admin...");
            Entity entity = jetbrains.charisma.service.BeansKt.getUserService().getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"userService.root");
            XdUser user2 = (XdUser)XdExtensionsKt.toXd((Entity)entity);
            UserJSON userJson = new UserJSON();
            userJson.setId(EntityExtensionsKt.getHubUuid((XdEntity)user2));
            User user3 = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDAO().merge((Iterable)CollectionsKt.listOf((Object[])new UserJSON[]{userJson, defaultAdmin}), user2.getLogin(), user2.getFullName(), user2.getEmail(), user2.getJabberAccountName(), Boolean.valueOf(false));
            Intrinsics.checkExpressionValueIsNotNull((Object)user3, (String)"ringApi.userDAO.merge(li\u2026jabberAccountName, false)");
            User mergedUser = user3;
            EntityExtensionsKt.setHubUuid((XdEntity)user2, mergedUser.getId());
            if (jetbrains.youtrack.config.BeansKt.getRingConfig().hasEmbeddedHub()) {
                Iterator credentials;
                this.cleanupVcsUserNames(mergedUser);
                Iterable details = defaultAdmin.getDetails();
                if (details != null && (credentials = details.iterator()).hasNext()) {
                    RemoteUserDetailsDAO remoteUserDetailsDAO = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDetailsDAO();
                    Object t = credentials.next();
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"credentials.next()");
                    remoteUserDetailsDAO.delete(((DetailsJSON)t).getId());
                }
            }
            Companion.getLogger().info("YouTrack root has been merged with Hub admin. Id: " + mergedUser.getId());
        }
    }

    private final void cleanupVcsUserNames(User mergedUser) {
        try {
            ArrayList<VcsUserNameJSON> vcsUserNames = new ArrayList<VcsUserNameJSON>();
            for (VCSUserName vcsName : mergedUser.getVCSUserNames()) {
                if (vcsName == null || !(Intrinsics.areEqual((Object)"default_admin_login", (Object)vcsName.getName()) ^ true)) continue;
                vcsUserNames.add(new VcsUserNameJSON(vcsName));
            }
            UserJSON json = new UserJSON();
            json.setId(mergedUser.getId());
            json.setVCSUserNames((Iterable)vcsUserNames);
            UserClient userClient = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getUserClient();
            String string = mergedUser.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mergedUser.id");
            userClient.updateUser(string, json);
        }
        catch (Exception e) {
            Companion.getLogger().warn("Failed to cleanup vcs user names after merge", (Throwable)e);
        }
    }

    private final UserJSON getDefaultHubAdmin() {
        Filter filter = new Filter(null, 1, null);
        filter.query("name: default_admin_name");
        Partial partial = Partial.user((Partial.User[])new Partial.User[]{Partial.User.ID, Partial.User.DETAILS((Partial.Details[])new Partial.Details[]{Partial.Details.ID})});
        List items = this.userClient.getUserPage((BaseFilter)filter, (FieldPartial)partial).getItems();
        return items.isEmpty() ? null : (UserJSON)items.get(0);
    }

    @NotNull
    public final UserHubSyncAdapter getAdapter() {
        return this.adapter;
    }

    public HubUserExporter(@NotNull UserHubSyncAdapter adapter2, @NotNull HubDtoBuilder<? super XdUser, ? extends UserJSON> dtoBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)adapter2, (String)"adapter");
        Intrinsics.checkParameterIsNotNull(dtoBuilder, (String)"dtoBuilder");
        this.adapter = adapter2;
        this.dtoBuilder = dtoBuilder;
        this.importClient = new ImportClient(jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts()).getUsersImportClient();
        this.userClient = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getUserClient();
        this.ringUsers = new HashMap();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/export/HubUserExporter$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

