/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import java.util.HashMap;
import java.util.Map;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.PermissionClient;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.export.adapter.HubSyncAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/ring/export/adapter/PermissionsHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/HubSyncAdapter;", "Ljetbrains/youtrack/core/security/Permission;", "()V", "add", "Ljetbrains/youtrack/api/ring/HubExportResult;", "youtrackEntity", "bulkExport", "", "entities", "", "createDto", "Ljetbrains/jetpass/rest/dto/PermissionJSON;", "permission", "export", "getClient", "Ljetbrains/jetpass/client/accounts/PermissionClient;", "getServiceScopedClient", "Ljetbrains/jetpass/client/accounts/ServiceClient$PermissionClient;", "isExported", "", "remove", "update", "youtrack-ring-integration"})
public final class PermissionsHubSyncAdapter
extends HubSyncAdapter<Permission> {
    @Override
    public boolean isExported(@NotNull Permission youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        return EntityExtensionsKt.getHubUuid(youtrackEntity) != null;
    }

    @Override
    public void bulkExport(@NotNull Iterable<? extends Permission> entities) {
        Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
        HashMap keyToUuid = new HashMap();
        Filter filter = (Filter)new Filter(null, 1, null).query("service: 0-0-0-0-0 or service: " + jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
        for (PermissionJSON json : this.getClient().getPermissionPage((BaseFilter)filter, null).getItems()) {
            Map map = keyToUuid;
            String string = json.getKey();
            String string2 = json.getId();
            map.put(string, string2);
        }
        Iterable<? extends Permission> $receiver$iv = entities;
        for (Object object : $receiver$iv) {
            Permission permission2 = (Permission)object;
            boolean bl = false;
            try {
                String uuid2 = (String)keyToUuid.get(permission2.getKey());
                if (uuid2 == null) {
                    uuid2 = this.getServiceScopedClient().addPermission(this.createDto(permission2), (FieldPartial)Partial.permission((Partial.Permission[])new Partial.Permission[]{Partial.Permission.ID})).getId();
                }
                EntityExtensionsKt.setHubUuid(permission2, uuid2);
            }
            catch (Exception e) {
                jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("The following permission cannot be exported to hub: " + permission2.name(), e);
            }
        }
    }

    @Override
    @NotNull
    public HubExportResult add(@NotNull Permission youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        throw (Throwable)new UnsupportedOperationException("Dynamic permission creation is not supported");
    }

    @Override
    @NotNull
    public HubExportResult export(@NotNull Permission youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        throw (Throwable)new UnsupportedOperationException("Dynamic permission creation is not supported");
    }

    @Override
    public void remove(@NotNull Permission youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        throw (Throwable)new UnsupportedOperationException("Hub permission removal from YT side is not supported");
    }

    @Override
    public void update(@NotNull Permission youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        PermissionJSON permissionDto = new PermissionJSON();
        permissionDto.setName(youtrackEntity.getVisibleName());
        permissionDto.setDescription(youtrackEntity.getHumanizedDescription());
        BeansKt.getRingApi().getPermissionDAO().update(EntityExtensionsKt.getHubUuid(youtrackEntity), (IdItem)permissionDto);
    }

    private final ServiceClient.PermissionClient getServiceScopedClient() {
        ServiceClient serviceClient = BeansKt.getHubClient().getAccountsClient().getServiceClient();
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return serviceClient.getPermissionsClient(string);
    }

    private final PermissionClient getClient() {
        return BeansKt.getHubClient().getAccountsClient().getPermissionClient();
    }

    private final PermissionJSON createDto(Permission permission2) {
        PermissionJSON permissionDto = new PermissionJSON();
        permissionDto.setName(permission2.getVisibleName());
        permissionDto.setDescription(permission2.getHumanizedDescription());
        permissionDto.setKey(permission2.getKey());
        permissionDto.setOperation(permission2.getOperation().toString());
        permissionDto.setEntityType(permission2.getPersistentClass());
        permissionDto.setGlobal(Boolean.valueOf(permission2.isGlobal()));
        return permissionDto;
    }
}

