/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import java.security.cert.CertificateEncodingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.api.ssl.Certificate;
import jetbrains.jetpass.client.accounts.CertificateClient;
import jetbrains.jetpass.rest.dto.CertificateJSON;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.core.ssl.CertificateUtilKt;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.export.FailureExportResult;
import jetbrains.youtrack.ring.export.SuccessExportResult;
import jetbrains.youtrack.ring.export.adapter.XdEntityHubSyncAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.dnq.XdEntity;
import mu.KLogging;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/ring/export/adapter/TrustedCertificateHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/XdEntityHubSyncAdapter;", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "()V", "client", "Ljetbrains/jetpass/client/accounts/CertificateClient;", "getClient", "()Ljetbrains/jetpass/client/accounts/CertificateClient;", "add", "Ljetbrains/youtrack/api/ring/HubExportResult;", "youtrackEntity", "remove", "", "toCertificateDto", "Ljetbrains/jetpass/rest/dto/CertificateJSON;", "entry", "update", "Companion", "youtrack-ring-integration"})
public final class TrustedCertificateHubSyncAdapter
extends XdEntityHubSyncAdapter<XdStorageEntry> {
    public static final Companion Companion = new Companion(null);

    private final CertificateClient getClient() {
        return BeansKt.getHubClient().getAccountsClient().getCertificateClient();
    }

    @Override
    @NotNull
    public HubExportResult add(@NotNull XdStorageEntry youtrackEntity) {
        HubExportResult hubExportResult;
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        try {
            CertificateJSON created = this.getClient().createCertificate(this.toCertificateDto(youtrackEntity), null);
            EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, created.getId());
            String string = created.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"created.id!!");
            hubExportResult = new SuccessExportResult(string, "Trusted certificate " + youtrackEntity.getName() + " exported to Hub");
        }
        catch (WebApplicationException e) {
            HubExportResult hubExportResult2;
            Sequence certificates = BeansKt.getRingApi().getCertificateDAO().getByName(youtrackEntity.getName());
            Response response = e.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"e.response");
            if (response.getStatus() == 409 && certificates.isNotEmpty()) {
                Object object = certificates.first();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                String id2 = ((Certificate)object).getId();
                EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, id2);
                String string = id2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
                hubExportResult2 = new SuccessExportResult(string, "Trusted certificate " + youtrackEntity.getName() + " linked with Hub");
            } else {
                hubExportResult2 = new FailureExportResult("Trusted certificate " + youtrackEntity.getName() + " cannot be exported", (Exception)((Object)e));
            }
            hubExportResult = hubExportResult2;
        }
        return hubExportResult;
    }

    @Override
    public void update(@NotNull XdStorageEntry youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        try {
            this.getClient().updateCertificate(EntityExtensionsKt.getHubUuidNotNull((XdEntity)youtrackEntity), this.toCertificateDto(youtrackEntity));
        }
        catch (WebApplicationException e) {
            String hubMessage = (String)e.getResponse().readEntity(String.class);
            Companion.getLogger().warn(hubMessage, (Throwable)e);
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Unable to update truststore in Hub: " + e.getMessage());
        }
    }

    @Override
    public void remove(@NotNull XdStorageEntry youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        CertificateClient.deleteCertificate$default((CertificateClient)this.getClient(), (String)EntityExtensionsKt.getHubUuidNotNull((XdEntity)youtrackEntity), null, (int)2, null);
    }

    private final CertificateJSON toCertificateDto(XdStorageEntry entry) {
        CertificateJSON json = new CertificateJSON();
        json.setName(entry.getName());
        json.setAlgorithm(CertificateUtilKt.getPublicKeyAlgorithm((java.security.cert.Certificate)entry.getCertificate()));
        try {
            byte[] byArray = Base64.encodeBase64((byte[])entry.getCertificate().getEncoded());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.encodeBase64(entr\u2026getCertificate().encoded)");
            byte[] byArray2 = byArray;
            CertificateJSON certificateJSON = json;
            String string = new String(byArray2, Charsets.UTF_8);
            certificateJSON.setData(string);
        }
        catch (CertificateEncodingException ex) {
            Companion.getLogger().warn("Unable to serialize certificate for export", (Throwable)ex);
            throw (Throwable)new RuntimeException(ex);
        }
        return json;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/export/adapter/TrustedCertificateHubSyncAdapter$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

