/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.dto;

import com.intellij.hub.core.data.uri.DataURI;
import java.io.InputStream;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.youtrack.persistent.XdPersistentFile;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.export.dto.HubDtoBuilder;
import jetbrains.youtrack.ring.export.dto.UpdateGroupHubDtoBuilder$build$1;
import jetbrains.youtrack.ring.export.dto.UpdateGroupHubDtoBuilder$build$2;
import jetbrains.youtrack.ring.export.dto.UpdateGroupHubDtoBuilder$build$3;
import jetbrains.youtrack.ring.persistence.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/ring/export/dto/UpdateGroupHubDtoBuilder;", "Ljetbrains/youtrack/ring/export/dto/HubDtoBuilder;", "Ljetbrains/youtrack/persistent/XdUserGroup;", "Ljetbrains/jetpass/rest/dto/UserGroupJSON;", "oldEntity", "(Ljetbrains/youtrack/persistent/XdUserGroup;)V", "build", "entity", "getIconDataURI", "", "group", "youtrack-ring-integration"})
public final class UpdateGroupHubDtoBuilder
implements HubDtoBuilder<XdUserGroup, UserGroupJSON> {
    private final XdUserGroup oldEntity;

    @Override
    @NotNull
    public UserGroupJSON build(@NotNull XdUserGroup entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        UserGroupJSON json = new UserGroupJSON();
        json.setId(EntityExtensionsKt.getHubUuidNotNull((XdEntity)entity));
        if (ReflectionUtilKt.hasChanges((XdEntity)((XdEntity)this.oldEntity), (KProperty1)((KProperty1)UpdateGroupHubDtoBuilder$build$1.INSTANCE))) {
            json.setName(entity.getName());
        }
        if (ReflectionUtilKt.hasChanges((XdEntity)((XdEntity)this.oldEntity), (KProperty1)((KProperty1)UpdateGroupHubDtoBuilder$build$2.INSTANCE))) {
            json.setDescription(entity.getDescription());
        }
        if (entity.getIcon() != null && ReflectionUtilKt.hasChanges((XdEntity)((XdEntity)this.oldEntity), (KProperty1)((KProperty1)UpdateGroupHubDtoBuilder$build$3.INSTANCE))) {
            json.setIconUrl(this.getIconDataURI(entity));
        }
        return json;
    }

    private final String getIconDataURI(XdUserGroup group2) {
        try {
            XdPersistentFile icon = group2.getIcon();
            if (icon != null) {
                String string = icon.getMimeType();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                InputStream inputStream = icon.getContent();
                if (inputStream == null) {
                    Intrinsics.throwNpe();
                }
                return new DataURI(string, inputStream).getDataURI();
            }
        }
        catch (Exception e) {
            BeansKt.getPersistentLog().warn("Can't export icon", e);
        }
        return null;
    }

    public UpdateGroupHubDtoBuilder(@NotNull XdUserGroup oldEntity) {
        Intrinsics.checkParameterIsNotNull((Object)oldEntity, (String)"oldEntity");
        this.oldEntity = oldEntity;
    }

    @Override
    @Nullable
    public String getDataUri(@NotNull XdPersistentFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return HubDtoBuilder.DefaultImpls.getDataUri(this, $receiver);
    }
}

