/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import com.intellij.hub.auth.oauth2.token.AccessToken;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.client.oauth2.OAuth2Client;
import jetbrains.jetpass.client.oauth2.token.OAuth2ClientFlow;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.LinkUtil;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import jetbrains.mps.webr.runtime.util.ContentBuilder;
import jetbrains.youtrack.api.ring.HubAuthenticationClient;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.persistent.XdNotificationsConfig;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import webr.framework.runtime.response.JsCommandResponse;
import webr.framework.textBuilder.TBuilderContext;

@Component(value="hubAuthenticationClient")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/ring/impl/HubAuthenticationClientImpl;", "Ljetbrains/youtrack/api/ring/HubAuthenticationClient;", "()V", "doClientLogin", "", "template", "Ljetbrains/mps/webr/runtime/templateComponent/TemplateComponent;", "redirectUri", "", "login", "password", "loginAsHubService", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "youtrack-ring-integration"})
public final class HubAuthenticationClientImpl
implements HubAuthenticationClient {
    public void doClientLogin(@NotNull TemplateComponent template, @NotNull String redirectUri, @NotNull String login, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        Intrinsics.checkParameterIsNotNull((Object)redirectUri, (String)"redirectUri");
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        String id2 = URLEncoder.encode(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId(), StandardCharsets.UTF_8.displayName());
        String uri = URLEncoder.encode(((XdNotificationsConfig)XdNotificationsConfig.Companion.wrap((Entity)jetbrains.charisma.persistent.BeansKt.getNotificationsConfig())).getBaseUrl(), StandardCharsets.UTF_8.displayName());
        String hubLoginUrl = BeansKt.getRingUrls().getHubUrl() + "/api/rest/oauth2/interactive/login?response_type=token&redirect_uri=" + uri + "&client_id=" + id2 + "&scope=" + id2;
        template.addCommandResponse((JsCommandResponse)ResponseFactory.getJsResponseFactory().getEvalResponse(ContentBuilder.toString((_FunctionTypes._void_P1_E0)((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<TBuilderContext>(redirectUri, login, password, hubLoginUrl){
            final /* synthetic */ String $redirectUri;
            final /* synthetic */ String $login;
            final /* synthetic */ String $password;
            final /* synthetic */ String $hubLoginUrl;

            public final void invoke(TBuilderContext builderContext) {
                LinkUtil.addScriptDependencies((TBuilderContext)builderContext, (Iterable)CollectionsKt.arrayListOf((Object[])new String[]{"Webr.Event", "jetbrains.mps.webr.jquery.jquery"}));
                builderContext.appendIndent();
                builderContext.append("var redirect = function () {");
                builderContext.appendNewLine();
                builderContext.increaseIndent();
                builderContext.appendIndent();
                builderContext.append("Webr.Event.redirect(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)this.$redirectUri));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.decreaseIndent();
                builderContext.appendIndent();
                builderContext.append("};");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("var data = {username: \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)this.$login));
                builderContext.append("\", password: \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)this.$password));
                builderContext.append("\", rememberMe: true, service: \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)this.$redirectUri));
                builderContext.append("\"};");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("jQuery.ajax({url: \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)this.$hubLoginUrl));
                builderContext.append("\", type: \"post\", contentType: \"application/x-www-form-urlencoded\", data: data, success: redirect, error: redirect});");
                builderContext.appendNewLine();
            }
            {
                this.$redirectUri = string;
                this.$login = string2;
                this.$password = string3;
                this.$hubLoginUrl = string4;
            }
        }), (boolean)false, (TemplateComponent)template)));
    }

    @NotNull
    public AccessToken loginAsHubService() {
        OAuth2Client oauth2Client = jetbrains.youtrack.ring.client.BeansKt.getHubClientFactory().getClients().getOauthClient();
        OAuth2ClientFlow.Builder clientFlowBuilder = oauth2Client.clientFlow();
        clientFlowBuilder.clientId(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
        clientFlowBuilder.clientSecret(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getSecret());
        for (Service service : jetbrains.youtrack.ring.client.BeansKt.getRingApi().getServiceDAO().getAllItems()) {
            clientFlowBuilder.addScope(service.getId());
        }
        OAuth2ClientFlow clientFlow = clientFlowBuilder.build();
        return clientFlow.getToken();
    }
}

