/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import com.intellij.hub.auth.OAuthException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import jetbrains.charisma.authentication.BaseAuthenticationManager;
import jetbrains.charisma.authentication.IAuthenticationManager;
import jetbrains.charisma.authentication.LoginContext;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.HubReplicatingMarker;
import jetbrains.youtrack.ring.maintenance.BeansKt;
import jetbrains.youtrack.ring.sync.RingUser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.controller.BaseApplication;

@Component(value="hubAuthenticationManager")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/ring/impl/HubAuthenticationManager;", "Ljetbrains/charisma/authentication/BaseAuthenticationManager;", "()V", "assertRingIntegrationIsEnabled", "", "authorize", "Ljetbrains/exodus/entitystore/Entity;", "context", "Ljetbrains/charisma/authentication/LoginContext;", "getLogin", "Ljetbrains/charisma/authentication/IAuthenticationManager$LoginUrlBuilder;", "getLogout", "Ljetbrains/charisma/authentication/IAuthenticationManager$LogoutUrlBuilder;", "getRelativeUrl", "", "absoluteUrl", "Companion", "youtrack-ring-integration"})
public final class HubAuthenticationManager
extends BaseAuthenticationManager {
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entity authorize(@NotNull LoginContext context) {
        Entity user2;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.assertRingIntegrationIsEnabled();
        String string2 = context.getPassword();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.password");
        if (StringsKt.startsWith$default((String)string2, (String)"perm:", (boolean)false, (int)2, null)) {
            try {
                return jetbrains.charisma.persistent.BeansKt.getHubUuidResolver().resolveUserByAuthHeader("Bearer " + context.getPassword());
            }
            catch (Exception e) {
                Companion.getLogger().warn("Rest login attempt failed for user [" + context.getLogin() + ']', (Throwable)e);
            }
        }
        try {
            string = jetbrains.youtrack.ring.client.BeansKt.getHubClient().login(context);
        }
        catch (OAuthException e) {
            String message2 = "Rest login attempt failed: " + e.getMessage();
            if (StringsKt.contains$default((CharSequence)message2, (CharSequence)"Invalid resource owner credentials", (boolean)false, (int)2, null)) {
                Companion.getLogger().info(message2);
            } else {
                Companion.getLogger().warn(message2);
            }
            string = null;
        }
        catch (Throwable t) {
            Companion.getLogger().warn("Rest login attempt failed for user [" + context.getLogin() + ']', t);
            string = null;
        }
        String remoteUserId = string;
        if (remoteUserId == null && (user2 = context.getUser()) != null) {
            remoteUserId = EntityExtensionsKt.getHubUuid(user2);
        }
        if (remoteUserId != null) {
            Entity entity;
            boolean $i$f$muteEverything = false;
            try {
                HubReplicatingMarker.INSTANCE.suspendRingNotificationsForThread();
                jetbrains.youtrack.api.application.BeansKt.getRuleEngine().addIgnoreThread();
                jetbrains.charisma.persistent.BeansKt.getSystemApplyEventMarker().add();
                BeansKt.getEventIssueListener().addIgnoreThread();
                boolean bl = false;
                XdUser xdUser = new RingUser(remoteUserId).resolveOrSyncIfMissing();
                Entity resolved = xdUser != null ? xdUser.getEntity() : null;
                LegacySupportKt.flush();
                entity = resolved;
            }
            finally {
                HubReplicatingMarker.INSTANCE.resumeRingNotificationsForThread();
                jetbrains.youtrack.api.application.BeansKt.getRuleEngine().removeIgnoreThread();
                jetbrains.charisma.persistent.BeansKt.getSystemApplyEventMarker().remove();
                BeansKt.getEventIssueListener().removeIgnoreThread();
            }
            return entity;
        }
        return null;
    }

    @NotNull
    public IAuthenticationManager.LoginUrlBuilder getLogin() {
        this.assertRingIntegrationIsEnabled();
        return (IAuthenticationManager.LoginUrlBuilder)new BaseAuthenticationManager.LoginUrlBuilder(this){
            final /* synthetic */ HubAuthenticationManager this$0;

            /*
             * Unable to fully structure code
             */
            @NotNull
            public String url() {
                try {
                    if (this.returnTo == null) ** GOTO lbl-1000
                    v0 = this.returnTo;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"returnTo");
                    var2_1 = v0;
                    if (var2_1.length() == 0) lbl-1000:
                    // 2 sources

                    {
                        v1 = new StringBuilder();
                        v2 = BaseApplication.getRequest();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"BaseApplication.getRequest()");
                        v3 = v1.append(v2.getContextPath()).append("/").toString();
                    } else {
                        v3 = HubAuthenticationManager.access$getRelativeUrl(this.this$0, this.returnTo);
                    }
                    returnUrl = v3;
                    v4 = new StringBuilder();
                    v5 = BaseApplication.getRequest();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"BaseApplication.getRequest()");
                    builder = new URIBuilder(v4.append(v5.getContextPath()).append("/oauth").toString());
                    builder.addParameter("state", returnUrl);
                    if (this.message != null) {
                        builder.addParameter("message", this.message);
                    }
                    if (this.renew) {
                        builder.setFragment("renew");
                    }
                    v6 = builder.build().toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"builder.build().toString()");
                    result = v6;
                    return StringsKt.startsWith$default((String)result, (String)"/", (boolean)false, (int)2, null) != false ? result : '/' + result;
                }
                catch (URISyntaxException e) {
                    throw (Throwable)new RuntimeException(e);
                }
            }
            {
                this.this$0 = $outer;
                super((BaseAuthenticationManager)$outer);
            }
        };
    }

    @NotNull
    public IAuthenticationManager.LogoutUrlBuilder getLogout() {
        this.assertRingIntegrationIsEnabled();
        return (IAuthenticationManager.LogoutUrlBuilder)new BaseAuthenticationManager.LogoutUrlBuilder(this){
            final /* synthetic */ HubAuthenticationManager this$0;

            @NotNull
            public String url() {
                String string;
                String afterLoginUrl = jetbrains.charisma.main.BeansKt.getSecurityNavigator().getAfterLoginUrl();
                if (afterLoginUrl == null) {
                    String string2 = this.this$0.getLogin().renew().url();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"login.renew().url()");
                } else {
                    String string3 = this.this$0.getLogin().renew().returnTo(afterLoginUrl).url();
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"login.renew().returnTo(afterLoginUrl).url()");
                }
                return string;
            }
            {
                this.this$0 = $outer;
                super((BaseAuthenticationManager)$outer);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getRelativeUrl(String absoluteUrl) {
        if (absoluteUrl == null || StringsKt.startsWith$default((String)absoluteUrl, (String)"/", (boolean)false, (int)2, null)) return absoluteUrl;
        try {
            String string;
            String query;
            URL url = new URL(absoluteUrl);
            String string2 = query = url.getQuery();
            if (string2 != null) {
                CharSequence charSequence = string2;
                if (charSequence.length() > 0) {
                    string = url.getPath() + '?' + query;
                    return string;
                }
            }
            string = url.getPath();
            return string;
        }
        catch (MalformedURLException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private final void assertRingIntegrationIsEnabled() {
        boolean $i$f$transactional = false;
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(){

            public final Unit invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                if (!jetbrains.youtrack.config.BeansKt.getRingConfig().isEnabled()) {
                    throw (Throwable)new IllegalStateException("Ring integration is not active");
                }
                return Unit.INSTANCE;
            }
        }), (int)7, null);
    }

    public static final /* synthetic */ String access$getRelativeUrl(HubAuthenticationManager $this, String absoluteUrl) {
        return $this.getRelativeUrl(absoluteUrl);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/impl/HubAuthenticationManager$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

