/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.ring.HubUuidResolver;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.sync.RingGroup;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="hubUuidResolver")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/ring/impl/HubUuidResolverImpl;", "Ljetbrains/youtrack/api/ring/HubUuidResolver;", "()V", "findUsersByVcsUsername", "", "Ljetbrains/exodus/entitystore/Entity;", "name", "", "resolveGroup", "uuid", "resolveProjectByResourceUuid", "resolveProjectByUuidOnly", "resolveRole", "hubUuid", "resolveUser", "resolveUserByAuthHeader", "header", "resolveUserByUuidOnly", "resolveUserGroupByUuidOnly", "Companion", "youtrack-ring-integration"})
public final class HubUuidResolverImpl
implements HubUuidResolver {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Entity resolveProjectByResourceUuid(@NotNull String uuid2) {
        Resource hubResource;
        Intrinsics.checkParameterIsNotNull((Object)uuid2, (String)"uuid");
        Entity project = this.resolveProjectByUuidOnly(uuid2);
        if (BeansKt.getRingConfig().isEnabled() && EntityOperations.equals((Entity)project, null) && (hubResource = (Resource)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getResourceDAO().get(uuid2)) != null) {
            Iterator iterator2 = hubResource.getAliases().iterator();
            while (iterator2.hasNext()) {
                Alias alias;
                Alias alias2 = alias = (Alias)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)alias2, (String)"alias");
                String string = alias2.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"alias.id");
                Entity locatedByAlias = this.resolveProjectByUuidOnly(string);
                if (EntityOperations.equals((Entity)locatedByAlias, null)) continue;
                project = locatedByAlias;
            }
        }
        return project;
    }

    private final Entity resolveProjectByUuidOnly(String uuid2) {
        String entityType = "Project";
        PropertyEqual pe = new PropertyEqual("$$hubId$$", (Comparable)((Object)uuid2));
        return DnqUtils.cast((Object)QueryOperations.getFirst((Iterable)((Iterable)QueryOperations.query((String)entityType, (NodeBase)((NodeBase)pe)))), (String)"Project");
    }

    @Nullable
    public Entity resolveUserByAuthHeader(@Nullable String header) {
        boolean $i$f$transactional = false;
        return (Entity)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Entity>(header){
            final /* synthetic */ String $header$inlined;
            {
                this.$header$inlined = string;
                super(1);
            }

            public final Entity invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                XdUser xdUser = jetbrains.youtrack.ring.sync.BeansKt.getHubUserResolver().resolveByAuthHeader(this.$header$inlined);
                return xdUser != null ? xdUser.getEntity() : null;
            }
        }), (int)7, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Entity> findUsersByVcsUsername(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (BeansKt.getRingConfig().isEnabled()) {
            try {
                void $receiver$iv$iv;
                Filter filter = new Filter(null, 1, null);
                filter.query("vcsUserName: {" + name + '}');
                Iterable $receiver$iv = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getUserClient().getUserPage((BaseFilter)filter, null).getUsers();
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Entity entity;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    UserJSON it = (UserJSON)element$iv$iv;
                    boolean bl = false;
                    String string = it.getId();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.id!!");
                    if (this.resolveUser(string) == null) continue;
                    Entity it$iv$iv = entity;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            catch (Exception e) {
                Companion.getLogger().warn("Failed to resolve Hub user by VCS user name " + name, (Throwable)e);
            }
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public Entity resolveUser(@NotNull String uuid2) {
        Intrinsics.checkParameterIsNotNull((Object)uuid2, (String)"uuid");
        Entity user2 = this.resolveUserByUuidOnly(uuid2);
        if (BeansKt.getRingConfig().isEnabled()) {
            User hubUser;
            if (EntityOperations.equals((Entity)user2, null) && (hubUser = (User)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDAO().get(uuid2)) != null) {
                Iterator iterator2 = hubUser.getAliases().iterator();
                while (iterator2.hasNext()) {
                    Alias alias;
                    Alias alias2 = alias = (Alias)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)alias2, (String)"alias");
                    String string = alias2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"alias.id");
                    Entity localUserByAlias = this.resolveUserByUuidOnly(string);
                    if (EntityOperations.equals((Entity)localUserByAlias, null)) continue;
                    user2 = localUserByAlias;
                }
            }
            if (EntityOperations.equals((Entity)user2, null)) {
                XdUser xdUser = jetbrains.youtrack.ring.sync.BeansKt.getHubUserResolver().resolve(uuid2);
                user2 = xdUser != null ? xdUser.getEntity() : null;
            }
        }
        return user2;
    }

    @Nullable
    public Entity resolveGroup(@NotNull String uuid2) {
        Intrinsics.checkParameterIsNotNull((Object)uuid2, (String)"uuid");
        Entity group2 = this.resolveUserGroupByUuidOnly(uuid2);
        if (BeansKt.getRingConfig().isEnabled()) {
            UserGroup hubGroup;
            if (EntityOperations.equals((Entity)group2, null) && (hubGroup = (UserGroup)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserGroupDAO().get(uuid2)) != null) {
                Iterator iterator2 = hubGroup.getAliases().iterator();
                while (iterator2.hasNext()) {
                    Alias alias;
                    Alias alias2 = alias = (Alias)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)alias2, (String)"alias");
                    String string = alias2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"alias.id");
                    Entity localUserByAlias = this.resolveUserGroupByUuidOnly(string);
                    if (EntityOperations.equals((Entity)localUserByAlias, null)) continue;
                    group2 = localUserByAlias;
                }
            }
            if (EntityOperations.equals((Entity)group2, null)) {
                XdUserGroup xdUserGroup = new RingGroup(uuid2).resolve();
                group2 = xdUserGroup != null ? xdUserGroup.getEntity() : null;
            }
        }
        return group2;
    }

    @NotNull
    public Entity resolveRole(@NotNull String hubUuid) {
        Object element$iv2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)hubUuid, (String)"hubUuid");
            Iterable $receiver$iv = XdQueryKt.asIterable((XdQuery)XdRole.Companion.all());
            for (Object element$iv2 : $receiver$iv) {
                XdRole it = (XdRole)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)hubUuid, (Object)EntityExtensionsKt.getHubUuid((XdEntity)it))) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((XdRole)element$iv2).getEntity();
    }

    private final Entity resolveUserGroupByUuidOnly(String uuid2) {
        return QueryOperations.getFirst((Iterable)((Iterable)QueryOperations.query(null, (String)"UserGroup", (NodeBase)((NodeBase)new PropertyEqual("$$hubId$$", (Comparable)((Object)uuid2))))));
    }

    @Nullable
    public final Entity resolveUserByUuidOnly(@NotNull String uuid2) {
        Intrinsics.checkParameterIsNotNull((Object)uuid2, (String)"uuid");
        return QueryOperations.getFirst((Iterable)((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)((NodeBase)new PropertyEqual("$$hubId$$", (Comparable)((Object)uuid2))))));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/impl/HubUuidResolverImpl$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

