/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import java.net.URL;
import java.util.Calendar;
import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.ring.RingDataStore;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component(value="ringDataStore")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/ring/impl/RingDataStoreImpl;", "Ljetbrains/youtrack/api/ring/RingDataStore;", "()V", "findHubProject", "Ljetbrains/jetpass/api/security/Project;", "project", "Ljetbrains/exodus/entitystore/Entity;", "getGroupRingId", "", "userGroup", "getPermissionRingId", "permission", "Ljetbrains/youtrack/core/security/Permission;", "getProject", "ringId", "getProjectDefaultIconUrl", "ytProject", "getProjectIconUrl", "getProjectResourceId", "getProjectRingId", "getUserRingId", "user", "ProjectDecorator", "youtrack-ring-integration"})
public final class RingDataStoreImpl
implements RingDataStore {
    @Nullable
    public String getPermissionRingId(@NotNull Permission permission2) {
        Intrinsics.checkParameterIsNotNull((Object)permission2, (String)"permission");
        return EntityExtensionsKt.getHubUuid(permission2);
    }

    @Nullable
    public String getUserRingId(@NotNull Entity user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return EntityExtensionsKt.getHubUuid(user2);
    }

    @Nullable
    public String getGroupRingId(@NotNull Entity userGroup) {
        Intrinsics.checkParameterIsNotNull((Object)userGroup, (String)"userGroup");
        return EntityExtensionsKt.getHubUuid(userGroup);
    }

    @Nullable
    public Entity getProject(@NotNull String ringId) {
        Intrinsics.checkParameterIsNotNull((Object)ringId, (String)"ringId");
        List<Entity> projects2 = jetbrains.youtrack.ring.sync.BeansKt.getHubUuidCache().getProjects(ringId);
        return QueryOperations.getSize((Iterable)projects2) > 0 ? QueryOperations.getFirst((Iterable)projects2) : null;
    }

    @Nullable
    public String getProjectRingId(@NotNull Entity ytProject) {
        Intrinsics.checkParameterIsNotNull((Object)ytProject, (String)"ytProject");
        Project project = this.findHubProject(ytProject);
        return project != null ? project.getId() : null;
    }

    @Nullable
    public String getProjectResourceId(@NotNull Entity project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return EntityExtensionsKt.getHubUuid(XdExtensionsKt.toXd((Entity)project));
    }

    @Nullable
    public String getProjectIconUrl(@NotNull Entity ytProject) {
        Intrinsics.checkParameterIsNotNull((Object)ytProject, (String)"ytProject");
        Project project = this.findHubProject(ytProject);
        return project != null ? project.getIconUrl() : null;
    }

    @Nullable
    public String getProjectDefaultIconUrl(@NotNull Entity ytProject) {
        Intrinsics.checkParameterIsNotNull((Object)ytProject, (String)"ytProject");
        return "";
    }

    private final Project findHubProject(Entity project) {
        String resourceId = this.getProjectResourceId(project);
        if (resourceId != null) {
            Project project2;
            Project hubProject;
            Resource resource = (Resource)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getResourceDAO().get(resourceId);
            Object object = hubProject = resource != null ? resource.getProject() : null;
            if (BeansKt.getRingConfig().hasEmbeddedHub()) {
                ProjectDecorator projectDecorator;
                Project project3 = hubProject;
                if (project3 != null) {
                    Project project4;
                    Project it = project4 = project3;
                    boolean bl = false;
                    projectDecorator = new ProjectDecorator(it);
                } else {
                    projectDecorator = null;
                }
                project2 = projectDecorator;
            } else {
                project2 = hubProject;
            }
            return project2;
        }
        return null;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001d\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J-\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\n0\u0007H\u0097\u0001J-\u0010\u000b\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f\u0018\u00010\n0\u0007H\u0096\u0001J\u0011\u0010\r\u001a\n \t*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J\u0011\u0010\u000f\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0096\u0001J\u0011\u0010\u0010\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0096\u0001J\u0011\u0010\u0011\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0096\u0001J\b\u0010\u0012\u001a\u00020\bH\u0016J\u0011\u0010\u0013\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0096\u0001J\u0011\u0010\u0014\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0096\u0001J\u0011\u0010\u0015\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0096\u0001J\u0011\u0010\u0016\u001a\n \t*\u0004\u0018\u00010\u00170\u0017H\u0096\u0001J-\u0010\u0018\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00190\u0019 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\n0\u0007H\u0096\u0001J-\u0010\u001a\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u001b0\u001b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010\n0\u0007H\u0096\u0001J\u0011\u0010\u001c\u001a\n \t*\u0004\u0018\u00010\u001d0\u001dH\u0096\u0001J-\u0010\u001e\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00190\u0019 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\n0\u0007H\u0096\u0001J\u0016\u0010\u001f\u001a\n \t*\u0004\u0018\u00010 0 H\u0096\u0001\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\n \t*\u0004\u0018\u00010 0 H\u0096\u0001\u00a2\u0006\u0002\u0010!J\u0016\u0010#\u001a\n \t*\u0004\u0018\u00010 0 H\u0096\u0001\u00a2\u0006\u0002\u0010!J\u0016\u0010$\u001a\n \t*\u0004\u0018\u00010 0 H\u0096\u0001\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006%"}, d2={"Ljetbrains/youtrack/ring/impl/RingDataStoreImpl$ProjectDecorator;", "Ljetbrains/jetpass/api/security/Project;", "project", "(Ljetbrains/youtrack/ring/impl/RingDataStoreImpl;Ljetbrains/jetpass/api/security/Project;)V", "getProject", "()Ljetbrains/jetpass/api/security/Project;", "getAliasIds", "", "", "kotlin.jvm.PlatformType", "", "getAliases", "Ljetbrains/jetpass/api/Alias;", "getCreationTime", "Ljava/util/Calendar;", "getDashboard", "getDescription", "getIcon", "getIconUrl", "getId", "getKey", "getName", "getOwner", "Ljetbrains/jetpass/api/authority/User;", "getProjectRoles", "Ljetbrains/jetpass/api/security/ProjectRole;", "getResources", "Ljetbrains/jetpass/api/security/Resource;", "getTeam", "Ljetbrains/jetpass/api/authority/ProjectTeam;", "getTransitiveProjectRoles", "isArchived", "", "()Ljava/lang/Boolean;", "isDefaultIcon", "isGlobal", "isMyFavorite", "youtrack-ring-integration"})
    private final class ProjectDecorator
    implements Project {
        @NotNull
        private final Project project;

        @NotNull
        public String getIconUrl() {
            URL url = new URL(this.project.getIconUrl());
            return url.getPath() + '?' + url.getQuery();
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public ProjectDecorator(Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.project = project;
        }

        @Deprecated(message="Deprecated in Java")
        public Iterable<String> getAliasIds() {
            return this.project.getAliasIds();
        }

        public Iterable<Alias> getAliases() {
            return this.project.getAliases();
        }

        public Calendar getCreationTime() {
            return this.project.getCreationTime();
        }

        public String getDashboard() {
            return this.project.getDashboard();
        }

        public String getDescription() {
            return this.project.getDescription();
        }

        public String getIcon() {
            return this.project.getIcon();
        }

        public String getId() {
            return this.project.getId();
        }

        public String getKey() {
            return this.project.getKey();
        }

        public String getName() {
            return this.project.getName();
        }

        public User getOwner() {
            return this.project.getOwner();
        }

        public Iterable<ProjectRole> getProjectRoles() {
            return this.project.getProjectRoles();
        }

        public Iterable<Resource> getResources() {
            return this.project.getResources();
        }

        public ProjectTeam getTeam() {
            return this.project.getTeam();
        }

        public Iterable<ProjectRole> getTransitiveProjectRoles() {
            return this.project.getTransitiveProjectRoles();
        }

        public Boolean isArchived() {
            return this.project.isArchived();
        }

        public Boolean isDefaultIcon() {
            return this.project.isDefaultIcon();
        }

        public Boolean isGlobal() {
            return this.project.isGlobal();
        }

        public Boolean isMyFavorite() {
            return this.project.isMyFavorite();
        }
    }
}

