/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.listeners;

import com.google.gson.GsonBuilder;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.youtrack.ring.listeners.BundleRestClient;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import mu.KLogging;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="bundleRestClient")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0003\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\nJ \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/ring/listeners/BundleRestClient;", "", "()V", "client", "Lorg/apache/http/client/HttpClient;", "getClient", "()Lorg/apache/http/client/HttpClient;", "client$delegate", "Lkotlin/Lazy;", "shouldNotifyBundle", "", "getShouldNotifyBundle", "()Z", "shouldNotifyBundle$delegate", "buildUri", "Ljava/net/URI;", "post", "Lorg/apache/http/HttpResponse;", "propertyName", "", "propertyValue", "skipBundleValidation", "toJson", "BundleMessage", "BundleProperty", "Companion", "youtrack-ring-integration"})
public final class BundleRestClient {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy client$delegate = LazyKt.lazy((Function0)client.2.INSTANCE);
    @NotNull
    private final Lazy shouldNotifyBundle$delegate = LazyKt.lazy((Function0)shouldNotifyBundle.2.INSTANCE);
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BundleRestClient.class), "client", "getClient()Lorg/apache/http/client/HttpClient;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BundleRestClient.class), "shouldNotifyBundle", "getShouldNotifyBundle()Z"))};
        Companion = new Companion(null);
    }

    private final HttpClient getClient() {
        Lazy lazy = this.client$delegate;
        BundleRestClient bundleRestClient = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (HttpClient)lazy.getValue();
    }

    public final boolean getShouldNotifyBundle() {
        Lazy lazy = this.shouldNotifyBundle$delegate;
        BundleRestClient bundleRestClient = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final HttpResponse post(@NotNull String propertyName, @NotNull String propertyValue, boolean skipBundleValidation) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        Intrinsics.checkParameterIsNotNull((Object)propertyValue, (String)"propertyValue");
        HttpPost post = new HttpPost(this.buildUri());
        String json = this.toJson(propertyName, propertyValue, skipBundleValidation);
        post.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        HttpResponse httpResponse = this.getClient().execute((HttpUriRequest)post);
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponse, (String)"client.execute(post)");
        return httpResponse;
    }

    @NotNull
    public static /* synthetic */ HttpResponse post$default(BundleRestClient bundleRestClient, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return bundleRestClient.post(string, string2, bl);
    }

    private final URI buildUri() {
        String token = ConfigurationParameter.getParameter((String)"bundle.backend-api-token");
        String baseUrl = System.getProperty("jetbrains.youtrack.ring.configurator.internalUrl");
        URI uRI = UriBuilder.fromUri((String)baseUrl).path("api").path("settings").queryParam("bundleBackendToken", new Object[]{token}).build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(baseU\u2026endToken\", token).build()");
        return uRI;
    }

    private final String toJson(String propertyName, String propertyValue, boolean skipBundleValidation) {
        String string = new GsonBuilder().setPrettyPrinting().create().toJson((Object)new BundleMessage(new BundleProperty(propertyName, propertyValue), skipBundleValidation));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GsonBuilder()\n          \u2026), skipBundleValidation))");
        return string;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/ring/listeners/BundleRestClient$BundleMessage;", "", "property", "Ljetbrains/youtrack/ring/listeners/BundleRestClient$BundleProperty;", "skipValidation", "", "(Ljetbrains/youtrack/ring/listeners/BundleRestClient$BundleProperty;Z)V", "getProperty", "()Ljetbrains/youtrack/ring/listeners/BundleRestClient$BundleProperty;", "getSkipValidation", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "youtrack-ring-integration"})
    private static final class BundleMessage {
        @NotNull
        private final BundleProperty property;
        private final boolean skipValidation;

        @NotNull
        public final BundleProperty getProperty() {
            return this.property;
        }

        public final boolean getSkipValidation() {
            return this.skipValidation;
        }

        public BundleMessage(@NotNull BundleProperty property, boolean skipValidation) {
            Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
            this.property = property;
            this.skipValidation = skipValidation;
        }

        @NotNull
        public final BundleProperty component1() {
            return this.property;
        }

        public final boolean component2() {
            return this.skipValidation;
        }

        @NotNull
        public final BundleMessage copy(@NotNull BundleProperty property, boolean skipValidation) {
            Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
            return new BundleMessage(property, skipValidation);
        }

        @NotNull
        public static /* synthetic */ BundleMessage copy$default(BundleMessage bundleMessage, BundleProperty bundleProperty, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bundleProperty = bundleMessage.property;
            }
            if ((n & 2) != 0) {
                bl = bundleMessage.skipValidation;
            }
            return bundleMessage.copy(bundleProperty, bl);
        }

        @NotNull
        public String toString() {
            return "BundleMessage(property=" + this.property + ", skipValidation=" + this.skipValidation + ")";
        }

        public int hashCode() {
            BundleProperty bundleProperty = this.property;
            int n = (bundleProperty != null ? ((Object)bundleProperty).hashCode() : 0) * 31;
            int n2 = this.skipValidation ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleMessage)) break block3;
                    BundleMessage bundleMessage = (BundleMessage)object;
                    if (!Intrinsics.areEqual((Object)this.property, (Object)bundleMessage.property) || !(this.skipValidation == bundleMessage.skipValidation)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/ring/listeners/BundleRestClient$BundleProperty;", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "youtrack-ring-integration"})
    private static final class BundleProperty {
        @NotNull
        private final String name;
        @NotNull
        private final String value;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public BundleProperty(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.name = name;
            this.value = value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final BundleProperty copy(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new BundleProperty(name, value);
        }

        @NotNull
        public static /* synthetic */ BundleProperty copy$default(BundleProperty bundleProperty, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = bundleProperty.name;
            }
            if ((n & 2) != 0) {
                string2 = bundleProperty.value;
            }
            return bundleProperty.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "BundleProperty(name=" + this.name + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.value;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleProperty)) break block3;
                    BundleProperty bundleProperty = (BundleProperty)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)bundleProperty.name) || !Intrinsics.areEqual((Object)this.value, (Object)bundleProperty.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/listeners/BundleRestClient$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

