/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.listeners.hub;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import jetbrains.jetpass.api.event.Event;
import jetbrains.jetpass.api.ssl.Certificate;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.CertificateClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.CertificateJSON;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.core.ssl.XdTrustStorage;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.listeners.hub.FilteringHubEventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/ring/listeners/hub/TrustedCertificateHubEventListener;", "Ljetbrains/youtrack/ring/listeners/hub/FilteringHubEventListener;", "Ljetbrains/jetpass/api/ssl/Certificate;", "()V", "addOrUpdateEntry", "", "event", "Ljetbrains/jetpass/api/event/Event;", "deleteEntry", "hubUuid", "", "getClient", "Ljetbrains/jetpass/client/accounts/CertificateClient;", "getEntry", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "handleAdded", "handleRemoved", "handleUpdated", "Companion", "youtrack-ring-integration"})
public final class TrustedCertificateHubEventListener
extends FilteringHubEventListener<Certificate> {
    @NotNull
    private static final FieldPartial<Partial.Certificate> PARTIAL;
    public static final Companion Companion;

    @Override
    protected void handleAdded(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.addOrUpdateEntry(event);
    }

    @Override
    protected void handleUpdated(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.addOrUpdateEntry(event);
    }

    @Override
    protected void handleRemoved(@NotNull Event event) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            XdStorageEntry xdStorageEntry = this.getEntry(event.getTargetId());
            if (xdStorageEntry == null) break block0;
            xdStorageEntry.delete();
        }
    }

    private final void addOrUpdateEntry(Event event) {
        CertificateJSON json;
        CertificateClient certificateClient = this.getClient();
        String string = event.getTargetId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.targetId");
        CertificateJSON certificateJSON = json = certificateClient.getCertificate(string, PARTIAL);
        if ((certificateJSON != null ? certificateJSON.isDisabled() : null) == null) {
            CertificateJSON certificateJSON2 = json;
            this.deleteEntry(certificateJSON2 != null ? certificateJSON2.getId() : null);
        } else {
            XdStorageEntry entry = this.getEntry(event.getTargetId());
            ByteArrayInputStream stream = new ByteArrayInputStream(Base64.decodeBase64((String)json.getData()));
            XdTrustStorage xdTrustStorage = jetbrains.charisma.ssl.keystore.BeansKt.getTrustStorage();
            InputStream inputStream = stream;
            String string2 = json.getName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"json.name!!");
            entry = xdTrustStorage.addTrustedCert(inputStream, string2, entry);
            String string3 = json.getName();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            entry.setName(string3);
            EntityExtensionsKt.setHubUuid((XdEntity)entry, json.getId());
        }
    }

    private final XdStorageEntry getEntry(String hubUuid) {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)XdQueryKt.toList((XdQuery)((XdQuery)jetbrains.charisma.ssl.keystore.BeansKt.getTrustStorage().getEntries()));
            for (Object t : iterable2) {
                XdStorageEntry it = (XdStorageEntry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)EntityExtensionsKt.getHubUuid((XdEntity)it), (Object)hubUuid)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void deleteEntry(String hubUuid) {
        block0: {
            XdStorageEntry xdStorageEntry;
            XdStorageEntry xdStorageEntry2 = this.getEntry(hubUuid);
            if (xdStorageEntry2 == null) break block0;
            XdStorageEntry it = xdStorageEntry = xdStorageEntry2;
            boolean bl = false;
            Companion.getLogger().info("Certificate " + it.getName() + " is disabled or deleted in Hub, removing local instance");
            it.delete();
        }
    }

    private final CertificateClient getClient() {
        return BeansKt.getHubClient().getAccountsClient().getCertificateClient();
    }

    public TrustedCertificateHubEventListener() {
        super(false);
    }

    static {
        Companion = new Companion(null);
        PARTIAL = new FieldPartial((BaseField[])new Partial.Certificate[]{Partial.Certificate.ID, Partial.Certificate.DATA, Partial.Certificate.NAME, Partial.Certificate.DISABLED});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/ring/listeners/hub/TrustedCertificateHubEventListener$Companion;", "Lmu/KLogging;", "()V", "PARTIAL", "Ljetbrains/jetpass/client/FieldPartial;", "Ljetbrains/jetpass/client/accounts/Partial$Certificate;", "kotlin.jvm.PlatformType", "getPARTIAL", "()Ljetbrains/jetpass/client/FieldPartial;", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final FieldPartial<Partial.Certificate> getPARTIAL() {
            return PARTIAL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

