/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.refactoring;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.persistent.XdApplicationMetaData;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.refactoring.XdRefactoring;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.refactoring.RingRefactoringUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/ring/refactoring/RefactoringSyncLoginsWithHub;", "Ljetbrains/youtrack/refactoring/XdRefactoring;", "()V", "apply", "", "meta", "Ljetbrains/youtrack/persistent/XdApplicationMetaData;", "getName", "", "postOurLoginsToHub", "updateOurLoginsFromHub", "updateUserBatch", "", "batch", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/persistent/XdUser;", "Companion", "youtrack-ring-integration"})
public final class RefactoringSyncLoginsWithHub
extends XdRefactoring {
    private static final int BATCH_SIZE = 500;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return "Sync and normalize user login field between Youtrack and Hub";
    }

    public void apply(@NotNull XdApplicationMetaData meta) {
        Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
        if (ConfigurationParameter.getParameter((String)"jetbrains.youtrack.ring.syncLoginsFromHub") == null) {
            this.postOurLoginsToHub();
        } else {
            this.updateOurLoginsFromHub();
        }
    }

    private final void postOurLoginsToHub() {
        RingRefactoringUtilKt.startJob(this, new Runnable(this){
            final /* synthetic */ RefactoringSyncLoginsWithHub this$0;

            public final void run() {
                try {
                    int top = 0;
                    XdQuery users = XdUser.Companion.getAllUsers();
                    XdQuery nextBatch = XdQueryKt.take((XdQuery)XdQueryKt.drop((XdQuery)users, (int)top), (int)500);
                    do {
                        long batchUpdateTime = RefactoringSyncLoginsWithHub.access$updateUserBatch(this.this$0, nextBatch);
                        RefactoringSyncLoginsWithHub.Companion.getLogger().info("Updating user logins in Hub. " + (top += XdQueryKt.size((XdQuery)nextBatch)) + " users processed");
                        Thread.sleep(batchUpdateTime);
                    } while (XdQueryKt.isNotEmpty((XdQuery)(nextBatch = XdQueryKt.take((XdQuery)XdQueryKt.drop((XdQuery)users, (int)top), (int)500))));
                    RefactoringSyncLoginsWithHub.Companion.getLogger().info("Hub logins update completed: " + top + " users processed");
                    this.this$0.markApplied();
                }
                catch (Exception exception) {
                    RefactoringSyncLoginsWithHub.Companion.getLogger().warn("", (Throwable)exception);
                }
            }
            {
                this.this$0 = refactoringSyncLoginsWithHub;
            }
        });
    }

    private final long updateUserBatch(XdQuery<? extends XdUser> batch) {
        long startTime = System.currentTimeMillis();
        Iterable $receiver$iv = XdQueryKt.asIterable(batch);
        for (Object element$iv : $receiver$iv) {
            XdUser it = (XdUser)element$iv;
            boolean bl = false;
            String id2 = EntityExtensionsKt.getHubUuid((XdEntity)it);
            if (id2 == null) {
                Companion.getLogger().warn("Unable to post login " + it.getLogin() + " to Hub. No Hub mapping found to update the user.");
                continue;
            }
            it.fixLogin();
            String login = it.getLogin();
            UserJSON user2 = new UserJSON();
            user2.setLogin(login);
            try {
                BeansKt.getHubClient().getAccountsClient().getUserClient().updateUser(id2, user2);
            }
            catch (WebApplicationException e) {
                Response response = e.getResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"e.response");
                if (response.getStatus() == 409) {
                    Companion.getLogger().warn("Unable to post login " + login + " to Hub as it's not unique, skipping ");
                    continue;
                }
                Response response2 = e.getResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"e.response");
                if (response2.getStatus() == 403) {
                    Companion.getLogger().warn("Unable to post login " + login + " to Hub (forbidden)");
                    throw (Throwable)e;
                }
                Response response3 = e.getResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"e.response");
                if (response3.getStatus() == 404) {
                    Companion.getLogger().warn("Unable to post login " + login + " to Hub due to broken mapping");
                    EntityExtensionsKt.setHubUuid((XdEntity)it, (String)null);
                    continue;
                }
                Companion.getLogger().warn("Unable to post login " + login + " to Hub, skipping", (Throwable)e);
            }
            catch (DataAccessException e) {
                Companion.getLogger().warn("Unable to post login " + login + " to Hub, skipping", (Throwable)e);
            }
        }
        return System.currentTimeMillis() - startTime;
    }

    private final void updateOurLoginsFromHub() {
        int skip = 0;
        int batchSize = 250;
        Filter filter = (Filter)((Filter)new Filter(null, 1, null).top(batchSize)).skip(skip);
        UserClient.Page page = BeansKt.getHubClient().getAccountsClient().getUserClient().getUserPage((BaseFilter)filter, (FieldPartial)Partial.user((Partial.User[])new Partial.User[]{Partial.User.ID, Partial.User.LOGIN}));
        HashMap ringUsers = new HashMap();
        while (page.getUsers().size() > 0) {
            for (UserJSON user2 : page.getUsers()) {
                String string;
                String string2;
                Map map = ringUsers;
                if (user2.getId() == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"user.id!!");
                if (user2.getLogin() == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.login!!");
                map.put(string2, string);
            }
            filter.skip(skip += batchSize);
            page = BeansKt.getHubClient().getAccountsClient().getUserClient().getUserPage((BaseFilter)filter, (FieldPartial)Partial.user((Partial.User[])new Partial.User[]{Partial.User.ID, Partial.User.LOGIN}));
        }
        Iterable $receiver$iv = XdQueryKt.asIterable((XdQuery)XdUser.Companion.getAllUsers());
        for (Object element$iv : $receiver$iv) {
            XdUser it = (XdUser)element$iv;
            boolean bl = false;
            Map map = ringUsers;
            String string = EntityExtensionsKt.getHubUuid((XdEntity)it);
            String hubLogin = (String)map.get(string);
            String ytLogin = it.getLogin();
            if (hubLogin == null) {
                Companion.getLogger().info("No hub login found for user " + ytLogin + ", skipping");
                continue;
            }
            try {
                it.setLogin(hubLogin);
                LegacySupportKt.flush();
            }
            catch (ConstraintsValidationException e) {
                Companion.getLogger().warn("Failed to update login from Hub. '" + hubLogin + "' is not unique, skipping.");
                it.setLogin(ytLogin);
            }
        }
        this.markApplied();
    }

    public static final /* synthetic */ long access$updateUserBatch(RefactoringSyncLoginsWithHub $this, XdQuery batch) {
        return $this.updateUserBatch((XdQuery<? extends XdUser>)batch);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/ring/refactoring/RefactoringSyncLoginsWithHub$Companion;", "Lmu/KLogging;", "()V", "BATCH_SIZE", "", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

