/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.rest;

import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.gap.resource.Resource;
import jetbrains.jetpass.api.authority.User;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.gaprest.filters.AuthIgnored;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.HubReplicatingMarker;
import jetbrains.youtrack.ring.maintenance.BeansKt;
import jetbrains.youtrack.ring.sync.RingUser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/token")
@AuthIgnored
@Produces(value={"application/json"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/ring/rest/HubTokenResource;", "Ljetbrains/gap/resource/Resource;", "Ljetbrains/gap/resource/Entity;", "()V", "postToken", "Ljavax/ws/rs/core/Response;", "authHeader", "", "syncUser", "", "uuid", "Companion", "ResponseBuilder", "TokenResponse", "youtrack-ring-integration"})
public final class HubTokenResource
implements Resource<jetbrains.gap.resource.Entity> {
    public static final Companion Companion = new Companion(null);

    @POST
    @NotNull
    public final Response postToken(@HeaderParam(value="Authorization") @Nullable String authHeader) {
        ResponseBuilder response;
        block9: {
            response = new ResponseBuilder();
            try {
                if (jetbrains.charisma.persistent.BeansKt.getHubUuidResolver().resolveUserByAuthHeader(authHeader) == null) {
                    response.setMessage("Hub token is missing or invalid");
                    response.setStatus(Response.Status.FORBIDDEN);
                    break block9;
                }
                if (jetbrains.charisma.persistent.BeansKt.getCurrentUser().get() != null && !jetbrains.charisma.persistent.BeansKt.getCurrentUser().isGuest()) {
                    Entity entity = jetbrains.charisma.persistent.BeansKt.getCurrentUser().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"currentUser.get()");
                    String uuid2 = EntityExtensionsKt.getHubUuid(entity);
                    if (uuid2 != null) {
                        this.syncUser(uuid2);
                    }
                    Entity entity2 = jetbrains.charisma.persistent.BeansKt.getCurrentUser().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"currentUser.get()");
                    if (((XdUser)XdExtensionsKt.toXd((Entity)entity2)).getBanned()) {
                        response.banned();
                    }
                    break block9;
                }
                Entity entity = jetbrains.charisma.service.BeansKt.getUserService().checkGuest();
                if (entity != null && (entity = (XdUser)XdExtensionsKt.toXd((Entity)entity)) != null) {
                    if (entity.getBanned()) {
                        response.banned();
                        break block9;
                    }
                }
                response.setMessage("Authenticated as guest user");
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (string == null) {
                    String string2 = e.getClass().getName();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"e.javaClass.name");
                }
                response.setMessage(string);
                response.setStatus(Response.Status.FORBIDDEN);
                Companion.getLogger().warn("Can't authorize user by Hub token", (Throwable)e);
            }
        }
        return response.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void syncUser(String uuid2) {
        boolean $i$f$muteEverything = false;
        try {
            XdUser xdUser;
            HubReplicatingMarker.INSTANCE.suspendRingNotificationsForThread();
            jetbrains.youtrack.api.application.BeansKt.getRuleEngine().addIgnoreThread();
            jetbrains.charisma.persistent.BeansKt.getSystemApplyEventMarker().add();
            BeansKt.getEventIssueListener().addIgnoreThread();
            boolean bl = false;
            RingUser sync = null;
            User remoteUser = (User)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDAO().get(uuid2);
            sync = remoteUser == null ? new RingUser(uuid2) : new RingUser(remoteUser);
            EnvironmentConfig environmentConfig = jetbrains.youtrack.config.BeansKt.getPersistentDataEnvironment().getEnvironmentConfig();
            Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"persistentDataEnvironment.environmentConfig");
            if (environmentConfig.getEnvIsReadonly()) {
                xdUser = sync.resolveOrSyncIfMissing();
            } else {
                sync.resolveAndSync();
                LegacySupportKt.flush();
                xdUser = Unit.INSTANCE;
            }
            XdUser xdUser2 = xdUser;
        }
        finally {
            HubReplicatingMarker.INSTANCE.resumeRingNotificationsForThread();
            jetbrains.youtrack.api.application.BeansKt.getRuleEngine().removeIgnoreThread();
            jetbrains.charisma.persistent.BeansKt.getSystemApplyEventMarker().remove();
            BeansKt.getEventIssueListener().removeIgnoreThread();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/ring/rest/HubTokenResource$ResponseBuilder;", "", "()V", "message", "", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "status", "Ljavax/ws/rs/core/Response$Status;", "getStatus", "()Ljavax/ws/rs/core/Response$Status;", "setStatus", "(Ljavax/ws/rs/core/Response$Status;)V", "banned", "build", "Ljavax/ws/rs/core/Response;", "youtrack-ring-integration"})
    public static final class ResponseBuilder {
        @NotNull
        private Response.Status status = Response.Status.OK;
        @NotNull
        private String message = "User sync has revealed no issues";

        @NotNull
        public final Response.Status getStatus() {
            return this.status;
        }

        public final void setStatus(@NotNull Response.Status status) {
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"<set-?>");
            this.status = status;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.message = string;
        }

        @NotNull
        public final Response build() {
            Response response = Response.status((Response.Status)this.status).entity((Object)new TokenResponse(this.message, this.status == Response.Status.OK)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.status(status).\u2026ponse.Status.OK)).build()");
            return response;
        }

        @NotNull
        public final ResponseBuilder banned() {
            ResponseBuilder responseBuilder;
            ResponseBuilder $receiver = responseBuilder = this;
            boolean bl = false;
            $receiver.status = Response.Status.FORBIDDEN;
            $receiver.message = "User is banned";
            return responseBuilder;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/ring/rest/HubTokenResource$TokenResponse;", "", "message", "", "authenticated", "", "(Ljava/lang/String;Z)V", "getAuthenticated", "()Z", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "youtrack-ring-integration"})
    public static final class TokenResponse {
        @NotNull
        private final String message;
        private final boolean authenticated;

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public final boolean getAuthenticated() {
            return this.authenticated;
        }

        public TokenResponse(@NotNull String message2, boolean authenticated) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            this.message = message2;
            this.authenticated = authenticated;
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        public final boolean component2() {
            return this.authenticated;
        }

        @NotNull
        public final TokenResponse copy(@NotNull String message2, boolean authenticated) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            return new TokenResponse(message2, authenticated);
        }

        @NotNull
        public static /* synthetic */ TokenResponse copy$default(TokenResponse tokenResponse, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = tokenResponse.message;
            }
            if ((n & 2) != 0) {
                bl = tokenResponse.authenticated;
            }
            return tokenResponse.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "TokenResponse(message=" + this.message + ", authenticated=" + this.authenticated + ")";
        }

        public int hashCode() {
            String string = this.message;
            int n = (string != null ? string.hashCode() : 0) * 31;
            int n2 = this.authenticated ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TokenResponse)) break block3;
                    TokenResponse tokenResponse = (TokenResponse)object;
                    if (!Intrinsics.areEqual((Object)this.message, (Object)tokenResponse.message) || !(this.authenticated == tokenResponse.authenticated)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/rest/HubTokenResource$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

